/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.tdm.common.helper.OrgServiceHelper;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.common.util.TreeUtils;
import org.apache.commons.lang3.StringUtils;

public class PermissionUtils {
    public static HasPermOrgResult getAllPermOrgs(IFormView view) {
        return PermissionUtils.getAllPermOrgs(view, "47150e89000000ac");
    }

    public static HasPermOrgResult getAllPermOrgs(IFormView view, String perm) {
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        String entityid = view.getEntityId();
        if (view instanceof ListView) {
            entityid = ((ListView)view).getBillFormId();
        }
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                appid = mainEntityType.getAppId();
            }
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityid, (String)perm);
        return hasPermOrgResult;
    }

    public static HasPermOrgResult getAllPermOrgs(IFormView view, String entityId, String perm) {
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                appid = mainEntityType.getAppId();
            }
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityId, (String)perm);
        return hasPermOrgResult;
    }

    public static Long getDefaultOrgId() {
        Long orgId = RequestContext.get().getOrgId();
        QFilter filter = new QFilter("id", "=", (Object)orgId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(16);
        TreeUtils.convertParam("id", orgId, map);
        TreeUtils.convertParam("status", "1", map);
        DynamicObjectCollection orgCollection = OrgServiceHelper.queryOrgListByCondition(map);
        if (orgCollection != null && orgCollection.size() > 0) {
            return orgId;
        }
        DynamicObjectCollection orgCollection1 = OrgServiceHelper.queryOrgListByCondition(TreeUtils.convertParam("status", "1"));
        if (orgCollection1 != null && orgCollection1.size() > 0) {
            return ((DynamicObject)orgCollection1.get(0)).getLong("id");
        }
        return 0L;
    }

    public static Long getAccountingDefaultOrgId(IFormView view) {
        Long orgId = RequestContext.get().getOrgId();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        List allOrg = OrgUnitServiceHelper.getAllOrg((String)"10");
        if (hasPermOrgResult.hasAllOrgPerm()) {
            if (allOrg.contains(orgId)) {
                return orgId;
            }
            return (Long)allOrg.get(0);
        }
        List orgList = hasPermOrgResult.getHasPermOrgs();
        List collect = orgList.stream().filter(allOrg::contains).collect(Collectors.toList());
        if (EmptyCheckUtils.isEmpty(collect)) {
            return 0L;
        }
        if (collect.contains(orgId)) {
            return orgId;
        }
        return (Long)collect.get(0);
    }

    public static List<Long> getAccountingOrgIds(IFormView view) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        List allOrg = OrgUnitServiceHelper.getAllOrg((String)"10");
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return allOrg;
        }
        List orgList = hasPermOrgResult.getHasPermOrgs();
        List<Long> collect = orgList.stream().filter(allOrg::contains).collect(Collectors.toList());
        return collect;
    }

    public static boolean hasSpecificPerm(IFormView view, String perm) {
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        String entityid = view.getEntityId();
        if (view instanceof ListView) {
            entityid = ((ListView)view).getBillFormId();
        }
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                appid = mainEntityType.getAppId();
            }
        }
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appid, (String)entityid, (String)perm);
    }
}

