/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class PollutionBaseDataUtils {
    private static final String ENTITY_TAX_MAIN = "tctb_tax_main";
    private static final List<String> FIRST_WATER_LIST = Lists.newArrayList((Object[])new String[]{"40201", "4020101", "4020102", "4020103", "4020104", "4020105", "4020106", "4020107", "4020108", "4020109", "4020110", "405", "406", "407"});
    private static final List<String> SECOND_WATER_LIST = Lists.newArrayList((Object[])new String[]{"40202", "405", "406", "407"});
    private static final List<String> THREE_WATER_LIST = Lists.newArrayList((Object[])new String[]{"40203", "4020301", "4020302", "4020303", "4020304", "4020305", "4020306", "4020307", "4020308", "4020309"});
    private static final List<String> FOUR_WATER_LIST = Lists.newArrayList((Object[])new String[]{"40204", "4020401", "4020402", "4020403", "4020404", "4020405", "4020406", "4020407"});
    private static final List<String> AIR_LIST = Lists.newArrayList((Object[])new String[]{"401", "405", "406", "407"});
    private static final List<String> NOISE_LIST = Lists.newArrayList((Object[])new String[]{"403", "408", "40301", "40302", "40303", "40304", "40305", "40306"});
    private static final List<String> RUBBISH_LIST = Lists.newArrayList((Object[])new String[]{"404", "206", "101213001", "101213002", "101213003", "101213004", "101213005", "101213006", "101213007", "101213099", "40407"});

    public static List<String> getNumber(String wrwlbNumber, String swrwzlNumber) {
        if ("101".equals(wrwlbNumber) && "301".equals(swrwzlNumber)) {
            return FIRST_WATER_LIST;
        }
        if ("101".equals(wrwlbNumber) && "302".equals(swrwzlNumber)) {
            List<String> collect = IntStream.rangeClosed(1, 51).boxed().map(s -> "40202" + String.format("%02d", s)).collect(Collectors.toList());
            collect.addAll(SECOND_WATER_LIST);
            return collect;
        }
        if ("101".equals(wrwlbNumber) && "303".equals(swrwzlNumber)) {
            return THREE_WATER_LIST;
        }
        if ("101".equals(wrwlbNumber) && "304".equals(swrwzlNumber)) {
            return FOUR_WATER_LIST;
        }
        if ("102".equals(wrwlbNumber)) {
            List<String> collect = IntStream.rangeClosed(1, 44).boxed().map(s -> "401" + String.format("%02d", s)).collect(Collectors.toList());
            collect.addAll(AIR_LIST);
            return collect;
        }
        if ("103".equals(wrwlbNumber)) {
            return NOISE_LIST;
        }
        if ("104".equals(wrwlbNumber)) {
            return RUBBISH_LIST;
        }
        return new ArrayList<String>();
    }

    public static DynamicObjectCollection getHbsEntryLists(String parentNumber, List<String> numbers) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)parentNumber), new QFilter("entry_detail.subnumber", "in", numbers)};
        return QueryServiceHelper.query((String)"tpo_hbs_bizdef", (String)"entry_detail.*", (QFilter[])qFilters);
    }

    public static DynamicObjectCollection getHbsEntity(Long orgid) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        DynamicObject taxMain = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_TAX_MAIN, (QFilter[])new QFilter[]{orgFilter});
        if (taxMain != null) {
            DynamicObjectCollection hjbhsentity = taxMain.getDynamicObjectCollection("hjbhsentity");
            return hjbhsentity;
        }
        return null;
    }

    public static DynamicObject getTaxTypeCard(Long orgid, String taxtype) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        DynamicObject taxMain = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_TAX_MAIN, (QFilter[])new QFilter[]{orgFilter});
        if (taxMain != null) {
            Optional<DynamicObject> optional;
            DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
            if (CollectionUtils.isNotEmpty((Collection)categoryentryentity) && (optional = categoryentryentity.stream().filter(s -> taxtype.equals(s.getString("taxtype"))).findFirst()).isPresent()) {
                return optional.get();
            }
            return null;
        }
        return null;
    }

    public static Boolean validHbsEntityBaseData(Long orgId, Predicate<DynamicObject> predicate) {
        Boolean result = Boolean.FALSE;
        DynamicObjectCollection dynamicObjects = PollutionBaseDataUtils.getHbsEntity(orgId);
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            result = dynamicObjects.stream().allMatch(s -> predicate.test((DynamicObject)s));
        }
        return result;
    }
}

