/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tdm.common.util.ExceptionUtil;

public class ResourceUtil {
    private static final Log logger = LogFactory.getLog(ResourceUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(String fileName) {
        ClassLoader classLoader = ResourceUtil.class.getClassLoader();
        BufferedReader reader = null;
        StringBuilder content = new StringBuilder();
        try {
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls != null && urls.hasMoreElements()) {
                URL url = urls.nextElement();
                reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.toString(e));
            String string = null;
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.error(ExceptionUtil.toString(e));
            }
        }
        return content.toString();
    }
}

