/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.interfaces.RSAKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class RsaUtil {
    public static byte[] decrypt(byte[] encryptedData, PrivateKey privateKey) throws Exception {
        RSAKey k = (RSAKey)((Object)privateKey);
        int keySize = k.getModulus().bitLength() / 8;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privateKey);
        return RsaUtil.doFinal(cipher, encryptedData, keySize);
    }

    private static byte[] doFinal(Cipher cipher, byte[] encryptedData, int keySize) throws BadPaddingException, IllegalBlockSizeException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int inputLen = encryptedData.length;
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] block = inputLen - offSet > keySize ? cipher.doFinal(encryptedData, offSet, keySize) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(block, 0, block.length);
            offSet = ++i * keySize;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }
}

