/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.common.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SolidWasteValidatorUtils {
    private static final String TDM_SOLID_WASTE_INFO = "tdm_solid_waste_info";
    private static final Set<String> mustInputs = new HashSet<String>(Arrays.asList("bydtfwcsl", "wrwpfl", "dwse", "ynse", "bqybtse"));
    private static final Set<String> largeZeros = new HashSet<String>(Arrays.asList("bydtfwcsl", "bygtfwccl", "bygtfwczl", "bygtfwzhlyl", "wrwpfl", "bqyjse"));
    private static final Set<String> LessGtfwcsl = new HashSet<String>(Arrays.asList("bygtfwccl", "bygtfwczl", "bygtfwzhlyl"));
    private static Map<String, String> disPlayName = new HashMap<String, String>(32);
    private static final String tabLine = "\t\n";

    public static void saveValid(Object o, StringBuilder errorsMsg) {
        disPlayName = SolidWasteValidatorUtils.getDisplayName(BusinessDataServiceHelper.newDynamicObject((String)TDM_SOLID_WASTE_INFO));
        SolidWasteValidatorUtils.checkMustInput(o, errorsMsg);
        SolidWasteValidatorUtils.checkBigThanZero(o, errorsMsg);
        SolidWasteValidatorUtils.checkLessGtfwcsl(o, errorsMsg);
        SolidWasteValidatorUtils.checkLessWrwpfl(o, errorsMsg);
        SolidWasteValidatorUtils.checkMoreBygtfwzhlyl(o, errorsMsg);
    }

    private static Map<String, String> getDisplayName(DynamicObject dynamicObject) {
        Map<String, String> collect = dynamicObject.getDataEntityType().getProperties().stream().collect(Collectors.toMap(s -> s.getName(), s -> s.getDisplayName() != null ? s.getDisplayName().getLocaleValue() : ""));
        return collect;
    }

    private static void checkMustInput(Object objects, StringBuilder errorsMsg) {
        List<Object> columns = new ArrayList(16);
        if (objects instanceof DynamicObject) {
            columns = mustInputs.stream().filter(m -> Objects.isNull(((DynamicObject)objects).get(m))).collect(Collectors.toList());
        } else if (objects instanceof JSONObject) {
            columns = mustInputs.stream().filter(m -> Objects.isNull(((JSONObject)objects).get(m))).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(columns)) {
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s", (String)"SolidWasteValidatorUtils_0", (String)"taxc-tdm-common", (Object[])new Object[0]), columns.stream().map(s -> disPlayName.get(s)).collect(Collectors.joining(",")));
            errorsMsg.append(msg).append(tabLine);
        }
    }

    private static void checkBigThanZero(Object objects, StringBuilder errorsMsg) {
        List<Object> columns = new ArrayList(16);
        if (objects instanceof DynamicObject) {
            columns = largeZeros.stream().filter(m -> ((DynamicObject)objects).getBigDecimal(m).compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toList());
        } else if (objects instanceof JSONObject) {
            columns = largeZeros.stream().filter(m -> ((JSONObject)objects).getBigDecimal(m).compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(columns)) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"SolidWasteValidatorUtils_1", (String)"taxc-tdm-common", (Object[])new Object[0]), columns.stream().map(s -> disPlayName.get(s)).collect(Collectors.joining(",")));
            errorsMsg.append(msg).append(tabLine);
        }
    }

    private static void checkLessGtfwcsl(Object objects, StringBuilder errorsMsg) {
        List<Object> columns = new ArrayList(16);
        if (objects instanceof DynamicObject) {
            columns = LessGtfwcsl.stream().filter(m -> ((DynamicObject)objects).getBigDecimal(m).compareTo(((DynamicObject)objects).getBigDecimal("bydtfwcsl")) > 0).collect(Collectors.toList());
        } else if (objects instanceof JSONObject) {
            columns = LessGtfwcsl.stream().filter(m -> ((JSONObject)objects).getBigDecimal(m).compareTo(((JSONObject)objects).getBigDecimal("bydtfwcsl")) > 0).collect(Collectors.toList());
        }
        if (columns.size() > 0) {
            columns.forEach(c -> {
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u8d85\u8fc7%2$s\u3002", (String)"SolidWasteValidatorUtils_2", (String)"taxc-tdm-common", (Object[])new Object[0]), disPlayName.get(c), disPlayName.get("bydtfwcsl"));
                errorsMsg.append(msg).append(tabLine);
            });
        }
    }

    private static void checkLessWrwpfl(Object objects, StringBuilder errorsMsg) {
        Boolean flag = Boolean.FALSE;
        if (objects instanceof DynamicObject) {
            flag = ((DynamicObject)objects).getBigDecimal("bygtfwzhlyl").compareTo(((DynamicObject)objects).getBigDecimal("wrwpfl")) > 0;
        } else if (objects instanceof JSONObject) {
            flag = ((JSONObject)objects).getBigDecimal("bygtfwzhlyl").compareTo(((JSONObject)objects).getBigDecimal("wrwpfl")) > 0;
        }
        if (flag.booleanValue()) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u8d85\u8fc7%2$s\u3002", (String)"SolidWasteValidatorUtils_2", (String)"taxc-tdm-common", (Object[])new Object[0]), disPlayName.get("bygtfwzhlyl"), disPlayName.get("wrwpfl"));
            errorsMsg.append(msg).append(tabLine);
        }
    }

    private static void checkMoreBygtfwzhlyl(Object objects, StringBuilder errorsMsg) {
        Boolean flag = Boolean.FALSE;
        if (objects instanceof DynamicObject) {
            flag = ((DynamicObject)objects).getDynamicObject("taxdeduction") != null && ((DynamicObject)objects).getBigDecimal("bygtfwzhlyl").compareTo(BigDecimal.ZERO) <= 0;
        } else if (objects instanceof JSONObject) {
            flag = ((JSONObject)objects).get((Object)"taxdeduction") != null && ((JSONObject)objects).getBigDecimal("bygtfwzhlyl").compareTo(BigDecimal.ZERO) <= 0;
        }
        if (flag.booleanValue()) {
            String msg = String.format(ResManager.loadKDString((String)"\u82e5\u4eab\u53d7\u7efc\u5408\u5229\u7528\u56fa\u4f53\u5e9f\u7269\u7a0e\u6536\u4f18\u60e0\uff0c\u8bf7\u786e\u4fdd\u201c%s\u201d\u5927\u4e8e0", (String)"SolidWasteValidatorUtils_4", (String)"taxc-tdm-common", (Object[])new Object[0]), disPlayName.get("bygtfwzhlyl"));
            errorsMsg.append(msg).append(tabLine);
        }
    }
}

