/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.account;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class TaxcAccountBusiness {
    private static Log logger = LogFactory.getLog(TaxcAccountBusiness.class);
    private static final String ROOT_NODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String DEFAULT_VALUE = " ";

    public static List<TreeNode> queryChildNode(String parentId, List<QFilter> filters, String order) {
        QFilter idFilter = null;
        idFilter = ROOT_NODE_ID.equals(parentId) ? new QFilter("parent.id", "=", (Object)DEFAULT_VALUE) : new QFilter("parent.id", "=", (Object)parentId);
        filters.add(idFilter);
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(10);
        String selectFields = "id,number,name";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"taxc_tdm_account_query", (String)"tdm_account", (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)order);){
            while (ds.hasNext()) {
                Row row = ds.next();
                TreeNode node = new TreeNode(parentId, row.getString("id"), row.getString("name"));
                node.setChildren(new ArrayList(1));
                childNodes.add(node);
            }
        }
        return childNodes;
    }

    public static DynamicObjectCollection getChildrenDynamicObject(List<Object> pkIds, Long orgId) {
        String longNumberDLM;
        Long time1 = System.currentTimeMillis();
        String entityName = "tdm_account";
        String selectFields = "id,org.id,longnumber";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", pkIds)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        HashSet<Long> orgIds = new HashSet<Long>(10);
        HashSet<String> longnumberList = new HashSet<String>(100);
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            if (dynamicObject.getString("longnumber") != null && !"".equals(dynamicObject.getString("longnumber").trim())) {
                longnumberList.add(dynamicObject.getString("longnumber"));
            }
            orgIds.add(dynamicObject.getLong("org.id"));
        }
        String dom = longNumberDLM = ".";
        ArrayList childLongNumberList = new ArrayList(1000);
        longnumberList.stream().forEach(v1 -> {
            boolean isChild = longnumberList.stream().anyMatch(v2 -> !v1.equals(v2) && v1.indexOf(v2 + dom) >= 0);
            if (isChild) {
                childLongNumberList.add(v1);
            }
        });
        longnumberList.removeAll(childLongNumberList);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)TaxcAccountBusiness.class.getName(), (String)entityName, (String)"id,longnumber,number", (QFilter[])new QFilter[]{orgFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String longnumber = row.getString("longnumber");
                boolean isContain = longnumberList.stream().anyMatch(v -> longnumber.equals(v) || longnumber.indexOf(v + dom) >= 0);
                if (!isContain) continue;
                pkIds.add(row.get("id"));
            }
        }
        DynamicObjectCollection result = null;
        QFilter baseQfilter = new QFilter("id", "in", pkIds);
        result = StringUtils.isNotBlank((Object)orgId) ? QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{baseQfilter, new QFilter("org", "=", (Object)orgId)}) : QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{baseQfilter});
        Long time2 = System.currentTimeMillis();
        logger.info("getChildrenDynamicObject \u8017\u8d39:" + (time2 - time1));
        return result;
    }

    public static List<String> checkRefrenceResult(String baseEntityTypeKey, DynamicObjectCollection list) {
        Long time1 = System.currentTimeMillis();
        BaseDataCheckRefrence checkRef = new BaseDataCheckRefrence();
        ArrayList<String> numberList = new ArrayList<String>();
        ArrayList ids = new ArrayList(list.size());
        HashMap idMap = new HashMap();
        list.stream().forEach(o -> {
            ids.add(o.get("id"));
            idMap.put(o.get("id"), o.getString("number"));
        });
        Map checkResult = BaseDataRefrenceHelper.checkRefrenced((String)baseEntityTypeKey, (Object[])ids.toArray(), null, null, null);
        for (Map.Entry entry : checkResult.entrySet()) {
            if (!((BaseDataCheckRefrenceResult)entry.getValue()).isRefence()) continue;
            numberList.add((String)idMap.get(entry.getKey()));
        }
        Long time2 = System.currentTimeMillis();
        logger.error("checkRefrenceResult \u8017\u8d39:" + (time2 - time1));
        return numberList;
    }

    public static void deleteAccountByIds(List ids) {
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        DeleteServiceHelper.delete((String)"tdm_account", (QFilter[])new QFilter[]{qFilter});
    }

    public static void deleteAccountSummaryByIds(List ids) {
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        DeleteServiceHelper.delete((String)"tdm_account_summary", (QFilter[])new QFilter[]{qFilter});
    }
}

