/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.assettaxcard;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.OperationResultHelper;
import kd.taxc.tdm.business.assettaxcard.AssetTaxCardService;

public class AssetTaxCardCalcTask
extends AbstractTask {
    public static final String TASK_PARAM_PKIDS = "pkIds";
    private AssetTaxCardService assetTaxCardService = new AssetTaxCardService();
    private static final Log log = LogFactory.getLog(AssetTaxCardCalcTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"AssetTaxCardCalcTask_0", (String)"taxc-tdm-business", (Object[])new Object[0]), null);
        List pkIds = (List)map.get(TASK_PARAM_PKIDS);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tdm_asset_taxc_card");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)mainEntityType);
        Map<String, Object> validateMap = this.assetTaxCardService.calcValidate(dynamicObjects);
        List successList = (List)validateMap.get("successList");
        List errorMsgList = (List)validateMap.get("errorMsgList");
        successList.forEach(d -> d.set("depreciationstatus", (Object)"3"));
        SaveServiceHelper.save((DynamicObject[])successList.toArray(new DynamicObject[0]));
        successList.sort(Comparator.comparing(d -> d.getDate("accountingperiod")));
        ArrayList<DynamicObject> errorList = new ArrayList<DynamicObject>();
        ArrayList<Object> successPkIds = new ArrayList<Object>();
        int total = successList.size();
        int progress = 0;
        for (DynamicObject dynamicObject : successList) {
            if (this.isStop()) {
                this.stop();
            }
            try {
                this.assetTaxCardService.calcDepreciation(dynamicObject);
                dynamicObject.set("depreciationstatus", (Object)"1");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                successPkIds.add(dynamicObject.getPkValue());
            }
            catch (Exception e) {
                errorList.add(dynamicObject);
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u3010%1$s\u3011\uff1a%2$s", (String)"AssetTaxCardCalcTask_3", (String)"taxc-tdm-business", (Object[])new Object[0]), dynamicObject.getString("number"), e.getMessage()));
            }
            this.feedbackProgress(++progress * 100 / total);
        }
        errorList.forEach(d -> d.set("depreciationstatus", (Object)"0"));
        SaveServiceHelper.save((DynamicObject[])errorList.toArray(new DynamicObject[0]));
        String successMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u6298\u65e7\u6210\u529f\u3002", (String)"AssetTaxCardCalcTask_1", (String)"taxc-tdm-business", (Object[])new Object[0]);
        String operateName = ResManager.loadKDString((String)"\u8ba1\u7b97\u6298\u65e7", (String)"AssetTaxCardCalcTask_2", (String)"taxc-tdm-business", (Object[])new Object[0]);
        OperationResult operateResult = OperationResultHelper.getFatalErrorOperateResult((String)operateName, (List)errorMsgList, (String)successMsg, (int)pkIds.size(), successPkIds);
        this.feedbackCustomdata(SerializationUtils.toJsonString((Object)operateResult));
    }

    private void feedbackCustomdata(String operateResult) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("operateResult", operateResult);
        this.feedbackCustomdata(result);
    }
}

