/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.assettaxcard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.OperationResultHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tdm.business.assettaxcard.AssetTaxCardService;

public class AssetTaxCardConfirmTask
extends AbstractTask {
    public static final String TASK_PARAM_PKIDS = "pkIds";
    private AssetTaxCardService assetTaxCardService = new AssetTaxCardService();
    private static final Log log = LogFactory.getLog(AssetTaxCardConfirmTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"AssetTaxCardConfirmTask_0", (String)"taxc-tdm-business", (Object[])new Object[0]), null);
        List pkIds = (List)map.get(TASK_PARAM_PKIDS);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tdm_asset_taxc_card");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)mainEntityType);
        Map<String, Object> validateMap = this.assetTaxCardService.confirmValidate(dynamicObjects);
        List successList = (List)validateMap.get("successList");
        List errorMsgList = (List)validateMap.get("errorMsgList");
        if (EmptyCheckUtils.isNotEmpty((Object)successList)) {
            try (TXHandle h = TX.required();){
                try {
                    this.assetTaxCardService.confirmDepreciation(this, successList);
                }
                catch (Throwable t) {
                    h.markRollback();
                    log.error("\u4efb\u52a1\u5931\u8d25", t);
                }
            }
        }
        List successPkIds = successList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        String successMsg = ResManager.loadKDString((String)"\u786e\u8ba4\u6298\u65e7\u6210\u529f\u3002", (String)"AssetTaxCardConfirmTask_1", (String)"taxc-tdm-business", (Object[])new Object[0]);
        String operateName = ResManager.loadKDString((String)"\u786e\u8ba4\u6298\u65e7", (String)"AssetTaxCardConfirmTask_2", (String)"taxc-tdm-business", (Object[])new Object[0]);
        OperationResult operateResult = OperationResultHelper.getFatalErrorOperateResult((String)operateName, (List)errorMsgList, (String)successMsg, (int)pkIds.size(), successPkIds);
        this.feedbackCustomdata(SerializationUtils.toJsonString((Object)operateResult));
    }

    private void feedbackCustomdata(String operateResult) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("operateResult", operateResult);
        this.feedbackCustomdata(result);
    }

    public void feedbackProgress(int progress) {
        super.feedbackProgress(progress);
    }

    public boolean isStop() {
        return super.isStop();
    }
}

