/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.assettaxcard;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tdm.business.assettaxcard.AssetTaxCardConfirmTask;

public class AssetTaxCardService {
    private static final String DEPRECIATION_METHOD_NXPJF = "TD-001";
    private static final String DEPRECIATION_METHOD_NSZHF = "TD-002";
    private static final String DEPRECIATION_METHOD_SBYEDJF = "TD-003";
    private static final String YBZJ = "ybzj";
    private static final String JSZJ = "jszj";

    public DynamicObject queryLastMonthTaxCardData(long assetdataid, String taxaccountingbook, Date accountingperiod) {
        Date lastMonth = DateUtils.addMonth((Date)accountingperiod, (int)-1);
        QFilter q1 = new QFilter("assetdata", "=", (Object)assetdataid);
        QFilter q2 = new QFilter("taxaccountingbook", "=", (Object)taxaccountingbook);
        QFilter q3 = new QFilter("accountingperiod", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)lastMonth)).and("accountingperiod", "<=", (Object)DateUtils.getLastDateOfMonth((Date)lastMonth));
        DynamicObject object = QueryServiceHelper.queryOne((String)"tdm_asset_taxc_card", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3});
        if (EmptyCheckUtils.isNotEmpty((Object)object)) {
            return BusinessDataServiceHelper.loadSingle((Object)object.get("id"), (String)"tdm_asset_taxc_card");
        }
        return null;
    }

    private DynamicObject queryCurrentAccountDepreciationData(long accountOrg, String assetcode, Date accountingperiod) {
        QFilter q1 = new QFilter("org", "=", (Object)accountOrg);
        QFilter q2 = new QFilter("assetcode", "=", (Object)assetcode);
        QFilter q3 = new QFilter("accountingperiod", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)accountingperiod)).and("accountingperiod", "<=", (Object)DateUtils.getLastDateOfMonth((Date)accountingperiod));
        return QueryServiceHelper.queryOne((String)"tdm_account_depreciation", (String)"currentamount,yearamount,cumulativeamount", (QFilter[])new QFilter[]{q1, q2, q3});
    }

    private DynamicObject queryCurrentYearAccountDepreciationData(long accountOrg, String assetcode, Date accountingperiod) {
        QFilter q1 = new QFilter("org", "=", (Object)accountOrg);
        QFilter q2 = new QFilter("assetcode", "=", (Object)assetcode);
        QFilter q3 = new QFilter("accountingperiod", ">=", (Object)DateUtils.getFirstDateOfYear((Date)accountingperiod)).and("accountingperiod", "<=", (Object)DateUtils.getLastDateOfMonth((Date)accountingperiod));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tdm_account_depreciation", (String)"currentamount,yearamount,cumulativeamount", (QFilter[])new QFilter[]{q1, q2, q3}, (String)"accountingperiod desc");
        if (EmptyCheckUtils.isNotEmpty((Object)dynamicObjects)) {
            return (DynamicObject)dynamicObjects.get(0);
        }
        return null;
    }

    private DynamicObject queryBeforeAccountDepreciationData(long accountOrg, String assetcode, Date accountingperiod) {
        QFilter q1 = new QFilter("org", "=", (Object)accountOrg);
        QFilter q2 = new QFilter("assetcode", "=", (Object)assetcode);
        QFilter q3 = new QFilter("accountingperiod", "<=", (Object)DateUtils.getLastDateOfMonth((Date)accountingperiod));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tdm_account_depreciation", (String)"currentamount,yearamount,cumulativeamount", (QFilter[])new QFilter[]{q1, q2, q3}, (String)"accountingperiod desc");
        if (EmptyCheckUtils.isNotEmpty((Object)dynamicObjects)) {
            return (DynamicObject)dynamicObjects.get(0);
        }
        return null;
    }

    public boolean existUnConfirmedCardInPrePeriod(DynamicObject dynamicObject) {
        long assetdataid = dynamicObject.getLong("assetdata.id");
        String taxaccountingbook = dynamicObject.getString("taxaccountingbook");
        Date accountingperiod = dynamicObject.getDate("accountingperiod");
        Date start = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)accountingperiod, (int)-1));
        Date end = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)accountingperiod, (int)-1));
        QFilter q1 = new QFilter("assetdata", "=", (Object)assetdataid);
        QFilter q2 = new QFilter("taxaccountingbook", "=", (Object)taxaccountingbook);
        QFilter q3 = new QFilter("accountingperiod", ">=", (Object)start).and("accountingperiod", "<=", (Object)end);
        QFilter q4 = new QFilter("depreciationstatus", "!=", (Object)"2");
        return QueryServiceHelper.exists((String)dynamicObject.getDataEntityType().getName(), (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    public boolean existConfirmedCardInFuturePeriod(DynamicObject dynamicObject) {
        long assetdataid = dynamicObject.getLong("assetdata.id");
        String taxaccountingbook = dynamicObject.getString("taxaccountingbook");
        Date accountingperiod = dynamicObject.getDate("accountingperiod");
        QFilter q1 = new QFilter("assetdata", "=", (Object)assetdataid);
        QFilter q2 = new QFilter("taxaccountingbook", "=", (Object)taxaccountingbook);
        QFilter q3 = new QFilter("accountingperiod", ">", (Object)accountingperiod);
        QFilter q4 = new QFilter("depreciationstatus", "=", (Object)"2");
        return QueryServiceHelper.exists((String)dynamicObject.getDataEntityType().getName(), (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    public Map<String, Object> calcValidate(DynamicObject[] dynamicObjects) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String depreciationstatus = dynamicObject.getString("depreciationstatus");
            if ("3".equals(depreciationstatus)) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u3010%s\u3011\uff1a\u8ba1\u7b97\u6298\u65e7\u4e2d\uff0c\u8bf7\u8ba1\u7b97\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"AssetTaxCardService_0", (String)"taxc-tdm-business", (Object[])new Object[0]), dynamicObject.getString("number")));
                continue;
            }
            if ("2".equals(depreciationstatus)) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u3010%s\u3011\uff1a\u5df2\u786e\u8ba4\u6298\u65e7\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u8ba1\u7b97\u6298\u65e7\u3002", (String)"AssetTaxCardService_5", (String)"taxc-tdm-business", (Object[])new Object[0]), dynamicObject.getString("number")));
                continue;
            }
            if (!"1".equals(dynamicObject.getString("policyconfirmationstatus"))) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u3010%s\u3011\uff1a\u653f\u7b56\u672a\u786e\u8ba4\uff0c\u8bf7\u5148\u786e\u8ba4\u3002", (String)"AssetTaxCardService_4", (String)"taxc-tdm-business", (Object[])new Object[0]), dynamicObject.getString("number")));
                continue;
            }
            boolean exists = this.existUnConfirmedCardInPrePeriod(dynamicObject);
            if (exists) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u3010%s\u3011\uff1a\u8ba1\u7b97\u6298\u65e7\u5931\u8d25\uff0c\u5b58\u5728\u5386\u53f2\u671f\u95f4\u5361\u7247\u6298\u65e7\u672a\u786e\u8ba4\uff0c\u8bf7\u5148\u8ba1\u7b97\u6298\u65e7\u3002", (String)"AssetTaxCardService_1", (String)"taxc-tdm-business", (Object[])new Object[0]), dynamicObject.getString("number")));
                continue;
            }
            successList.add(dynamicObject);
        }
        result.put("errorMsgList", errorMsgList);
        result.put("successList", successList);
        return result;
    }

    public void calcDepreciation(DynamicObject dynamicObject) {
        int taxdepreciatedperiods;
        Date accountingperiod;
        String taxaccountingbook;
        long assetdataid = dynamicObject.getLong("assetdata.id");
        DynamicObject prePeriodAssetTaxCard = this.queryLastMonthTaxCardData(assetdataid, taxaccountingbook = dynamicObject.getString("taxaccountingbook"), accountingperiod = dynamicObject.getDate("accountingperiod"));
        if (prePeriodAssetTaxCard != null) {
            taxdepreciatedperiods = prePeriodAssetTaxCard.getInt("taxdepreciatedperiods") + 1;
            taxdepreciatedperiods = Math.min(taxdepreciatedperiods, dynamicObject.getInt("taxamortizationperiods"));
        } else {
            taxdepreciatedperiods = 1;
        }
        dynamicObject.set("taxdepreciatedperiods", (Object)taxdepreciatedperiods);
        int taxsurplusdepperiods = dynamicObject.getInt("taxamortizationperiods") - dynamicObject.getInt("taxdepreciatedperiods");
        dynamicObject.set("taxsurplusdepperiods", (Object)taxsurplusdepperiods);
        String booktaxdifferent = dynamicObject.getString("booktaxdifferent");
        if ("0".equals(booktaxdifferent)) {
            String assetcode;
            long accountOrg = dynamicObject.getLong("accountorg.id");
            DynamicObject currentAccountDepreciation = this.queryCurrentAccountDepreciationData(accountOrg, assetcode = dynamicObject.getString("assetdata.assetcode"), accountingperiod);
            dynamicObject.set("taxcurrentdepamount", currentAccountDepreciation != null ? currentAccountDepreciation.get("currentamount") : BigDecimal.ZERO);
            DynamicObject currentYearAccountDepreciationData = this.queryCurrentYearAccountDepreciationData(accountOrg, assetcode, accountingperiod);
            dynamicObject.set("taxthisyeardepamount", currentYearAccountDepreciationData != null ? currentYearAccountDepreciationData.get("yearamount") : BigDecimal.ZERO);
            DynamicObject beforeAccountDepreciationData = this.queryBeforeAccountDepreciationData(accountOrg, assetcode, accountingperiod);
            dynamicObject.set("taxaccumulateddepamount", beforeAccountDepreciationData != null ? beforeAccountDepreciationData.get("cumulativeamount") : BigDecimal.ZERO);
        } else if ("1".equals(booktaxdifferent)) {
            BigDecimal taxcurrentdepamount = this.calctaxcurrentdepamount(prePeriodAssetTaxCard, dynamicObject);
            if (EmptyCheckUtils.isNotEmpty((Object)taxcurrentdepamount)) {
                dynamicObject.set("taxcurrentdepamount", (Object)taxcurrentdepamount);
            }
            if (DateUtils.getMonthOfDate((Date)accountingperiod) == 1) {
                dynamicObject.set("taxthisyeardepamount", (Object)dynamicObject.getBigDecimal("taxcurrentdepamount"));
            } else {
                BigDecimal lasttaxthisyeardepamount = prePeriodAssetTaxCard != null ? prePeriodAssetTaxCard.getBigDecimal("taxthisyeardepamount") : BigDecimal.ZERO;
                dynamicObject.set("taxthisyeardepamount", (Object)BigDecimalUtil.addObjects((Object[])new Object[]{lasttaxthisyeardepamount, dynamicObject.getBigDecimal("taxcurrentdepamount")}));
            }
            BigDecimal lasttaxaccumulateddepamount = prePeriodAssetTaxCard != null ? prePeriodAssetTaxCard.getBigDecimal("taxaccumulateddepamount") : BigDecimal.ZERO;
            dynamicObject.set("taxaccumulateddepamount", (Object)BigDecimalUtil.addObjects((Object[])new Object[]{lasttaxaccumulateddepamount, dynamicObject.getBigDecimal("taxcurrentdepamount")}));
        }
        BigDecimal netamount = BigDecimalUtil.addObjects((Object[])new Object[]{dynamicObject.getBigDecimal("taxbase"), dynamicObject.getBigDecimal("taxaccumulateddepamount").negate(), dynamicObject.getBigDecimal("taxresidualvalue").negate()});
        dynamicObject.set("netamount", (Object)netamount);
    }

    private BigDecimal calctaxcurrentdepamount(DynamicObject prePeriodAssetTaxCard, DynamicObject dynamicObject) {
        if (prePeriodAssetTaxCard != null && prePeriodAssetTaxCard.getBigDecimal("taxsurplusdepperiods").compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ZERO;
        }
        Date startdate = dynamicObject.getDate("startdate");
        Date accountingperiod = dynamicObject.getDate("accountingperiod");
        boolean isFirstPeriod = DateUtils.formatMonth((Date)DateUtils.addMonth((Date)startdate, (int)1)).equals(DateUtils.formatMonth((Date)accountingperiod));
        String depreciationadjustmethod = dynamicObject.getString("depreciationadjustmethod");
        DynamicObject taxdepreciation = dynamicObject.getDynamicObject("taxdepreciation");
        if (prePeriodAssetTaxCard == null && !isFirstPeriod) {
            return BigDecimal.ZERO;
        }
        if (taxdepreciation != null && "wlsy".equals(depreciationadjustmethod)) {
            String number = taxdepreciation.getString("number");
            if (DEPRECIATION_METHOD_NXPJF.equals(number)) {
                int taxdepreciatedperiods;
                BigDecimal taxbase = dynamicObject.getBigDecimal("taxbase");
                BigDecimal taxresidualvalue = dynamicObject.getBigDecimal("taxresidualvalue");
                BigDecimal preTaxaccumulateddepamount = prePeriodAssetTaxCard != null ? prePeriodAssetTaxCard.getBigDecimal("taxaccumulateddepamount") : BigDecimal.ZERO;
                int taxamortizationperiods = dynamicObject.getInt("taxamortizationperiods");
                int n = taxdepreciatedperiods = prePeriodAssetTaxCard != null ? prePeriodAssetTaxCard.getInt("taxdepreciatedperiods") : 0;
                if (taxamortizationperiods != taxdepreciatedperiods) {
                    return BigDecimalUtil.divideObject((Object)taxbase.subtract(taxresidualvalue).subtract(preTaxaccumulateddepamount), (Object)(taxamortizationperiods - taxdepreciatedperiods), (int)2);
                }
            } else if (DEPRECIATION_METHOD_NSZHF.equals(number)) {
                DynamicObject pre = this.findPreAssetTaxCard(dynamicObject, 13);
                int yjsynx = (int)Math.ceil(BigDecimalUtil.divideObject((Object)dynamicObject.getInt("taxamortizationperiods"), (Object)12, (int)10).doubleValue());
                int ysynx = Math.floorDiv(prePeriodAssetTaxCard != null ? prePeriodAssetTaxCard.getInt("taxdepreciatedperiods") + 1 : 1, 12);
                int sysynx = yjsynx - ysynx;
                BigDecimal yearDepreciationRate = BigDecimal.ZERO;
                if (sysynx != 0) {
                    yearDepreciationRate = BigDecimalUtil.divideObject((Object)(yjsynx - ysynx), (Object)((double)(sysynx * (sysynx + 1)) * 0.5), (int)10);
                }
                BigDecimal taxbase = pre != null ? pre.getBigDecimal("taxbase") : dynamicObject.getBigDecimal("taxbase");
                BigDecimal taxresidualvalue = pre != null ? pre.getBigDecimal("taxresidualvalue") : dynamicObject.getBigDecimal("taxresidualvalue");
                BigDecimal taxaccumulateddepamount = pre != null ? pre.getBigDecimal("taxaccumulateddepamount") : BigDecimal.ZERO;
                BigDecimal nzje = BigDecimalUtil.multiplyObject((Object)yearDepreciationRate, (Object)BigDecimalUtil.addObjects((Object[])new Object[]{taxbase, taxresidualvalue.negate(), taxaccumulateddepamount.negate()}), (int)2);
                Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)accountingperiod);
                int ndkjqjs = Math.min(Math.min(DateUtils.getMonthDiff((Date)lastDateOfYear, (Date)startdate), dynamicObject.getInt("taxsurplusdepperiods")), 12);
                if (ndkjqjs != 0) {
                    return BigDecimalUtil.divideObject((Object)nzje, (Object)ndkjqjs, (int)2);
                }
            } else if (DEPRECIATION_METHOD_SBYEDJF.equals(number)) {
                int taxsurplusdepperiods = dynamicObject.getInt("taxsurplusdepperiods");
                if (taxsurplusdepperiods > 24) {
                    DynamicObject pre = this.findPreAssetTaxCard(dynamicObject, 13);
                    int sysynx = (int)Math.ceil(BigDecimalUtil.divideObject((Object)dynamicObject.getInt("taxsurplusdepperiods"), (Object)12, (int)10).doubleValue());
                    BigDecimal yearDepreciationRate = BigDecimal.ZERO;
                    if (sysynx != 0) {
                        yearDepreciationRate = BigDecimalUtil.divideObject((Object)2, (Object)sysynx, (int)10);
                    }
                    BigDecimal taxbase = pre != null ? pre.getBigDecimal("taxbase") : dynamicObject.getBigDecimal("taxbase");
                    BigDecimal taxresidualvalue = pre != null ? pre.getBigDecimal("taxresidualvalue") : dynamicObject.getBigDecimal("taxresidualvalue");
                    BigDecimal taxaccumulateddepamount = pre != null ? pre.getBigDecimal("taxaccumulateddepamount") : BigDecimal.ZERO;
                    BigDecimal nzje = BigDecimalUtil.multiplyObject((Object)yearDepreciationRate, (Object)BigDecimalUtil.addObjects((Object[])new Object[]{taxbase, taxresidualvalue.negate(), taxaccumulateddepamount.negate()}), (int)2);
                    Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)accountingperiod);
                    int ndkjqjs = Math.min(Math.min(DateUtils.getMonthDiff((Date)lastDateOfYear, (Date)startdate), dynamicObject.getInt("taxsurplusdepperiods")), 12);
                    if (ndkjqjs != 0) {
                        return BigDecimalUtil.divideObject((Object)nzje, (Object)ndkjqjs, (int)2);
                    }
                } else {
                    BigDecimal taxaccumulateddepamount;
                    DynamicObject pre = this.findPreAssetTaxCard(dynamicObject, 25);
                    if (pre == null && !isFirstPeriod) {
                        return BigDecimal.ZERO;
                    }
                    Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)accountingperiod);
                    int ndkjqjs = Math.min(Math.min(DateUtils.getMonthDiff((Date)lastDateOfYear, (Date)startdate), dynamicObject.getInt("taxsurplusdepperiods")), 12);
                    BigDecimal taxbase = pre != null ? pre.getBigDecimal("taxbase") : dynamicObject.getBigDecimal("taxbase");
                    BigDecimal taxresidualvalue = pre != null ? pre.getBigDecimal("taxresidualvalue") : dynamicObject.getBigDecimal("taxresidualvalue");
                    BigDecimal bigDecimal = taxaccumulateddepamount = pre != null ? pre.getBigDecimal("taxaccumulateddepamount") : BigDecimal.ZERO;
                    if (ndkjqjs != 0) {
                        return BigDecimalUtil.divideObject((Object)BigDecimalUtil.addObjects((Object[])new Object[]{taxbase, taxresidualvalue.negate(), taxaccumulateddepamount.negate()}), (Object)(2 * ndkjqjs), (int)2);
                    }
                }
            }
        } else if ("zstz".equals(depreciationadjustmethod)) {
            // empty if block
        }
        return null;
    }

    private DynamicObject findPreAssetTaxCard(DynamicObject dynamicObject, int monthBefore) {
        long assetdataId = dynamicObject.getLong("assetdata.id");
        String taxaccountingbook = dynamicObject.getString("taxaccountingbook");
        Date accountingperiod = dynamicObject.getDate("accountingperiod");
        Date start = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)accountingperiod, (int)(-monthBefore)));
        Date end = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)accountingperiod, (int)-1));
        QFilter q1 = new QFilter("assetdata", "=", (Object)assetdataId);
        QFilter q2 = new QFilter("taxaccountingbook", "=", (Object)taxaccountingbook);
        QFilter q3 = new QFilter("accountingperiod", ">=", (Object)start);
        QFilter q4 = new QFilter("accountingperiod", "<=", (Object)end);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tdm_asset_taxc_card", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4}, (String)"accountingperiod asc", (int)1);
        if (EmptyCheckUtils.isNotEmpty((Object)dynamicObjects)) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)dynamicObjects.get(0)).getLong("id"), (String)"tdm_asset_taxc_card");
        }
        return null;
    }

    public Map<String, Object> confirmValidate(DynamicObject[] dynamicObjects) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!"1".equals(dynamicObject.getString("policyconfirmationstatus"))) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u3010%s\u3011\uff1a\u653f\u7b56\u672a\u786e\u8ba4\uff0c\u8bf7\u5148\u786e\u8ba4\u3002", (String)"AssetTaxCardService_4", (String)"taxc-tdm-business", (Object[])new Object[0]), dynamicObject.getString("number")));
                continue;
            }
            boolean exists = this.existUnConfirmedCardInPrePeriod(dynamicObject);
            if (exists) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u3010%s\u3011\uff1a\u786e\u8ba4\u6298\u65e7\u5931\u8d25\uff0c\u5b58\u5728\u5386\u53f2\u671f\u95f4\u5361\u7247\u672a\u786e\u8ba4\u6298\u65e7\uff0c\u8bf7\u5148\u786e\u8ba4\u5386\u53f2\u671f\u95f4\u5361\u7247\u6298\u65e7\u3002", (String)"AssetTaxCardService_3", (String)"taxc-tdm-business", (Object[])new Object[0]), dynamicObject.getString("number")));
                continue;
            }
            successList.add(dynamicObject);
        }
        result.put("errorMsgList", errorMsgList);
        result.put("successList", successList);
        return result;
    }

    public void confirmDepreciation(AssetTaxCardConfirmTask task, List<DynamicObject> dynamicObjects) {
        int total = dynamicObjects.size();
        int progress = 0;
        Map<String, List<DynamicObject>> assetTaxCardGroupByMap = dynamicObjects.stream().collect(Collectors.groupingBy(a -> a.getString("taxaccountingbook")));
        Map<String, DynamicObject> taxDepreciations = this.getTaxDepreciation(assetTaxCardGroupByMap.get(YBZJ));
        Map<String, DynamicObject> actualDepreciationsByYbzj = this.getActualDepreciation(assetTaxCardGroupByMap.get(YBZJ));
        Map<String, DynamicObject> taxCardsMap = this.getTaxCardWithoutAccelerate(assetTaxCardGroupByMap.get(YBZJ));
        Map<String, DynamicObject> actualDepreciationsByJszj = this.getActualDepreciation(assetTaxCardGroupByMap.get(JSZJ));
        for (DynamicObject object : dynamicObjects) {
            String key;
            if (task.isStop()) {
                task.stop();
            }
            if (YBZJ.equals(object.getString("taxaccountingbook"))) {
                key = this.getKey(object);
                DynamicObject taxDepreciation = taxDepreciations.get(key) != null ? taxDepreciations.get(key) : BusinessDataServiceHelper.newDynamicObject((String)"tdm_tax_depreciation");
                this.updateTaxDepreciation(taxDepreciation, object);
                this.confirmDepreciation(object);
                String taxCardKey = object.getLong("assetdata.id") + "_" + DateUtils.format((Date)object.getDate("accountingperiod"));
                if (taxCardsMap.get(taxCardKey) == null) {
                    DynamicObject actualDepreciation = actualDepreciationsByYbzj.get(key) != null ? actualDepreciationsByYbzj.get(key) : BusinessDataServiceHelper.newDynamicObject((String)"tdm_actual_depreciation");
                    this.updateActualDepreciation(actualDepreciation, object);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{actualDepreciation});
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taxDepreciation});
            } else if (JSZJ.equals(object.getString("taxaccountingbook"))) {
                key = this.getKey(object);
                DynamicObject actualDepreciation = actualDepreciationsByJszj.get(key) != null ? actualDepreciationsByJszj.get(key) : BusinessDataServiceHelper.newDynamicObject((String)"tdm_actual_depreciation");
                this.updateActualDepreciation(actualDepreciation, object);
                this.confirmDepreciation(object);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{actualDepreciation});
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            task.feedbackProgress(++progress * 100 / total);
        }
    }

    public void confirmDepreciation(DynamicObject dynamicObject) {
        dynamicObject.set("depreciationstatus", (Object)"2");
    }

    private String getKey(DynamicObject dynamicObject) {
        String key = dynamicObject.getLong("accountorg.id") + "_" + dynamicObject.getString("assetdata.assetcode") + "_" + DateUtils.format((Date)dynamicObject.getDate("accountingperiod"));
        return key;
    }

    private void updateTaxDepreciation(DynamicObject depreciationObject, DynamicObject taxCardObject) {
        depreciationObject.set("org", (Object)taxCardObject.getLong("accountorg.id"));
        depreciationObject.set("taxassetcategory", (Object)taxCardObject.getString("taxassetclass.class"));
        depreciationObject.set("assetcode", (Object)taxCardObject.getString("assetdata.assetcode"));
        depreciationObject.set("assetname", (Object)taxCardObject.getString("assetdata.assetname"));
        depreciationObject.set("accountingperiod", (Object)taxCardObject.getDate("accountingperiod"));
        depreciationObject.set("calctaxbase", (Object)taxCardObject.getBigDecimal("taxbase"));
        depreciationObject.set("taxresidualvalue", (Object)taxCardObject.getBigDecimal("taxresidualvalue"));
        depreciationObject.set("taxamortizationmethod", (Object)taxCardObject.getString("taxdepreciation.name"));
        depreciationObject.set("taxamortizationperiods", (Object)taxCardObject.getInt("taxamortizationperiods"));
        depreciationObject.set("taxcurrentamount", (Object)taxCardObject.getBigDecimal("taxcurrentdepamount"));
        depreciationObject.set("taxyearamount", (Object)taxCardObject.getBigDecimal("taxthisyeardepamount"));
        depreciationObject.set("taxcumulativeamount", (Object)taxCardObject.getBigDecimal("taxaccumulateddepamount"));
        depreciationObject.set("datasource", (Object)"sysgen");
    }

    private void updateActualDepreciation(DynamicObject depreciationObject, DynamicObject taxCardObject) {
        depreciationObject.set("org", (Object)taxCardObject.getLong("accountorg.id"));
        depreciationObject.set("taxassetstype", (Object)taxCardObject.getString("taxassetclass.class"));
        depreciationObject.set("acceleratedepretype", (Object)taxCardObject.getString("quicktaxassetclass.class"));
        depreciationObject.set("assetcode", (Object)taxCardObject.getString("assetdata.assetcode"));
        depreciationObject.set("assetname", (Object)taxCardObject.getString("assetdata.assetname"));
        depreciationObject.set("accountingperiod", (Object)taxCardObject.getDate("accountingperiod"));
        depreciationObject.set("calctaxbase", (Object)taxCardObject.getBigDecimal("taxbase"));
        depreciationObject.set("taxresidualvalue", (Object)taxCardObject.getBigDecimal("taxresidualvalue"));
        depreciationObject.set("taxactualmethod", (Object)taxCardObject.getString("taxdepreciation.name"));
        depreciationObject.set("integerfield", (Object)taxCardObject.getInt("taxamortizationperiods"));
        depreciationObject.set("taxcurrentamount", (Object)taxCardObject.getBigDecimal("taxcurrentdepamount"));
        depreciationObject.set("taxyearamount", (Object)taxCardObject.getBigDecimal("taxthisyeardepamount"));
        depreciationObject.set("taxcumulativeamount", (Object)taxCardObject.getBigDecimal("taxaccumulateddepamount"));
        depreciationObject.set("datasource", (Object)"sysgen");
    }

    public Map<String, DynamicObject> getTaxDepreciation(List<DynamicObject> list) {
        if (list == null) {
            return new HashMap<String, DynamicObject>();
        }
        List<Long> accorgIds = list.stream().map(a -> a.getLong("accountorg.id")).collect(Collectors.toList());
        List<String> assetcodes = list.stream().map(a -> a.getString("assetdata.assetcode")).collect(Collectors.toList());
        List<Date> accountingperiods = list.stream().map(a -> a.getDate("accountingperiod")).collect(Collectors.toList());
        DynamicObject[] objects = this.getTaxDepreciation(accorgIds, assetcodes, accountingperiods);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(objects.length);
        for (DynamicObject object : objects) {
            map.put(object.getLong("org.id") + "_" + object.getString("assetcode") + "_" + DateUtils.format((Date)object.getDate("accountingperiod")), object);
        }
        return map;
    }

    public DynamicObject[] getTaxDepreciation(List<Long> accorgIds, List<String> assetcodes, List<Date> accountingperiods) {
        QFilter qFilter = new QFilter("org", "in", accorgIds);
        qFilter.and("assetcode", "in", assetcodes);
        qFilter.and("accountingperiod", "in", accountingperiods);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"tdm_tax_depreciation", (String)"id,org,taxassetcategory,assetcode,assetname,accountingperiod,calctaxbase,taxresidualvalue,taxamortizationmethod,taxamortizationperiods,taxcurrentamount,taxyearamount,taxcumulativeamount,datasource,modifytime,modifier", (QFilter[])new QFilter[]{qFilter});
        return objects;
    }

    public Map<String, DynamicObject> getActualDepreciation(List<DynamicObject> list) {
        if (list == null) {
            return new HashMap<String, DynamicObject>();
        }
        List<Long> accorgIds = list.stream().map(a -> a.getLong("accountorg.id")).collect(Collectors.toList());
        List<String> assetcodes = list.stream().map(a -> a.getString("assetdata.assetcode")).collect(Collectors.toList());
        List<Date> accountingperiods = list.stream().map(a -> a.getDate("accountingperiod")).collect(Collectors.toList());
        DynamicObject[] objects = this.getActualDepreciation(accorgIds, assetcodes, accountingperiods);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(objects.length);
        for (DynamicObject object : objects) {
            map.put(object.getLong("org.id") + "_" + object.getString("assetcode") + "_" + DateUtils.format((Date)object.getDate("accountingperiod")), object);
        }
        return map;
    }

    public DynamicObject[] getActualDepreciation(List<Long> accorgIds, List<String> assetcodes, List<Date> accountingperiods) {
        QFilter qFilter = new QFilter("org", "in", accorgIds);
        qFilter.and("assetcode", "in", assetcodes);
        qFilter.and("accountingperiod", "in", accountingperiods);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"tdm_actual_depreciation", (String)"id,org,taxassetstype,acceleratedepretype,assetcode,assetname,accountingperiod,calctaxbase,taxresidualvalue,taxactualmethod,integerfield,taxcurrentamount,taxyearamount,taxcumulativeamount,datasource,modifytime,modifier", (QFilter[])new QFilter[]{qFilter});
        return objects;
    }

    public Map<String, DynamicObject> getTaxCardWithoutAccelerate(List<DynamicObject> list) {
        if (list == null) {
            return new HashMap<String, DynamicObject>();
        }
        List<Long> assetdataIds = list.stream().map(a -> a.getLong("assetdata.id")).collect(Collectors.toList());
        List<Date> accountingperiods = list.stream().map(a -> a.getDate("accountingperiod")).collect(Collectors.toList());
        DynamicObject[] objects = this.getTaxCardWithoutAccelerate(assetdataIds, accountingperiods);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(objects.length);
        for (DynamicObject object : objects) {
            map.put(object.getLong("assetdata.id") + "_" + DateUtils.format((Date)object.getDate("accountingperiod")), object);
        }
        return map;
    }

    public DynamicObject[] getTaxCardWithoutAccelerate(List<Long> assetdataIds, List<Date> accountingperiods) {
        QFilter qFilter = new QFilter("assetdata.id", "in", assetdataIds);
        qFilter.and("accountingperiod", "in", accountingperiods);
        qFilter.and("taxaccountingbook", "in", (Object)JSZJ);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"tdm_asset_taxc_card", (String)"id,assetdata.id,accountingperiod", (QFilter[])new QFilter[]{qFilter});
        return objects;
    }
}

