/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.assettaxcard;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class AssetTaxCardTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo.isTaskEnd()) {
            e.setClearTask(true);
            String data = taskInfo.getData();
            if (EmptyCheckUtils.isNotEmpty((Object)data)) {
                Map customs = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                String operateResult = (String)customs.get("operateResult");
                OperationResult o = (OperationResult)SerializationUtils.fromJsonString((String)operateResult, OperationResult.class);
                if (o.isSuccess()) {
                    this.getMainView().showSuccessNotification(o.getMessage());
                } else {
                    this.getMainView().showOperationResult(o);
                }
            }
        } else {
            this.showProgressForm();
        }
    }

    private void showProgressForm() {
        if (!this.isExistProgressForm()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("sch_taskprogress");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            if (StringUtils.isNotBlank((CharSequence)this.getJobFormInfo().getCaption())) {
                showParameter.setCaption(this.getJobFormInfo().getCaption());
            }
            showParameter.getCustomParams().put("ServiceAppId", this.getJobFormInfo().getJobInfo().getAppId());
            String jobInfoStr = SerializationUtils.toJsonString((Object)this.getJobFormInfo());
            showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
            showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
            showParameter.setCloseCallBack(this.getJobFormInfo().getCloseCallBack());
            this.getMainView().showForm(showParameter);
            this.setProgressPageId(showParameter.getPageId());
        }
    }

    public boolean release() {
        TaskInfo taskInfo = this.queryTask();
        return taskInfo.isTaskEnd();
    }
}

