/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.business.comparisonmodel.DataCompareBusiness;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareParams;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareTaskParams;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import kd.taxc.tdm.business.datacompare.DataCompareDataBusiness;
import kd.taxc.tdm.business.datacompare.enums.ResultLogStateEnum;
import kd.taxc.tdm.business.datacompare.enums.ResultStateEnum;
import kd.taxc.tdm.business.datacompare.model.FIDataCompareResult;
import kd.taxc.tdm.business.datacompare.model.FIDataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.model.FiAccountDTO;
import kd.taxc.tdm.business.datacompare.model.TaxAccountDTO;
import kd.taxc.tdm.business.datacompare.threadpools.ThreadPoolsUtils;
import kd.taxc.tdm.common.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataCompareBizBusiness {
    private static final Log logger = LogFactory.getLog(DataCompareBizBusiness.class);

    public static void submitDataCompareJob(Map<String, Object> params) {
        DynamicObject result = DataCompareBizBusiness.saveResult(params);
        params.put("resultid", result.getLong("id"));
        Long schemeId = ObjectUtils.toLong((Object)params.get("schemeid"));
        DataCompareParams dataCompareParams = new DataCompareParams();
        dataCompareParams.setSchemeId(schemeId);
        dataCompareParams.setParams(params);
        DataCompareBusiness.doCompare((DataCompareParams)dataCompareParams);
    }

    public static void submitResultRetryJob(Map<String, Object> params) {
        Long schemeId = ObjectUtils.toLong((Object)params.get("schemeid"));
        DataCompareParams dataCompareParams = new DataCompareParams();
        dataCompareParams.setSchemeId(schemeId);
        dataCompareParams.setParams(params);
        dataCompareParams.setRetry(true);
        dataCompareParams.setUseThread(false);
        DataCompareBusiness.doCompare((DataCompareParams)dataCompareParams);
    }

    public static DynamicObject saveResult(Map<String, Object> params) {
        Long schemeid = (Long)params.get("schemeid");
        Long id = DB.genLongId((String)"t_tdm_dc_result");
        DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"tdm_dc_result");
        result.set("id", (Object)id);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeid, (String)"tdm_dc_scheme");
        result.set("scheme", (Object)scheme);
        result.set("state", (Object)"C");
        result.set("starttime", (Object)new Date());
        result.set("creator", (Object)RequestContext.get().getCurrUserId());
        result.set("datarange_tag", (Object)SerializationUtils.toJsonString(params));
        result.set("billstatus", (Object)"A");
        SaveServiceHelper.saveOperate((String)"tdm_dc_result", (DynamicObject[])new DynamicObject[]{result}, (OperateOption)OperateOption.create());
        return result;
    }

    public static void saveResultLog(List<DataCompareTaskParams> taskParamsList) {
        if (taskParamsList.size() == 0) {
            return;
        }
        long[] ids = DB.genLongIds((String)"t_tdm_dc_resultlog", (int)taskParamsList.size());
        FIDataCompareTaskParams taskParams = null;
        ArrayList<DynamicObject> resultLogList = new ArrayList<DynamicObject>(taskParamsList.size());
        int size = taskParamsList.size();
        for (int i = 0; i < size; ++i) {
            taskParams = (FIDataCompareTaskParams)taskParamsList.get(i);
            taskParams.setLogId(ids[i]);
            resultLogList.add(DataCompareBizBusiness.paramToObject(taskParams));
        }
        SaveServiceHelper.save((DynamicObject[])resultLogList.toArray(new DynamicObject[resultLogList.size()]));
    }

    public static void updateResultLogState(FIDataCompareTaskParams compareParam, ResultLogStateEnum state) {
        DynamicObject result = BusinessDataServiceHelper.loadSingle((Object)compareParam.getLogId(), (String)"tdm_dc_resultlog");
        result.set("state", (Object)state.getValue());
        if (ResultLogStateEnum.RUN.getValue().equalsIgnoreCase(state.getValue())) {
            result.set("starttime", (Object)new Date());
        } else if (ResultLogStateEnum.SUCCESS.getValue().equalsIgnoreCase(state.getValue()) || ResultLogStateEnum.FAIL.getValue().equalsIgnoreCase(state.getValue())) {
            result.set("endtime", (Object)new Date());
        }
        result.set("source_count", (Object)compareParam.getSource_count());
        result.set("tar_count", (Object)compareParam.getTar_count());
        result.set("tar_noexistcount", (Object)compareParam.getTar_noexistcount());
        result.set("tar_diffcount", (Object)compareParam.getTar_diffcount());
        result.set("success_count", (Object)compareParam.getSuccess_count());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{result});
    }

    private static DynamicObject paramToObject(FIDataCompareTaskParams taskParams) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"tdm_dc_resultlog");
        obj.set("id", (Object)taskParams.getLogId());
        obj.set("resultid", (Object)taskParams.getResultId());
        obj.set("state", (Object)"C");
        obj.set("source_count", (Object)0);
        obj.set("tar_count", (Object)0);
        obj.set("tar_noexistcount", (Object)0);
        obj.set("tar_diffcount", (Object)0);
        obj.set("success_count", (Object)0);
        obj.set("datarange_tag", (Object)SerializationUtils.toJsonString((Object)((Object)taskParams)));
        return obj;
    }

    public static void updateResultState(Long id, ResultStateEnum state, String errormsg) {
        DynamicObject result = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tdm_dc_result");
        result.set("state", (Object)state.getValue());
        if (StringUtil.isNotEmpty((CharSequence)errormsg)) {
            result.set("errormsg_tag", (Object)errormsg);
            result.set("endtime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{result});
    }

    public static void updateResultFinish(FIDataCompareResult result) {
        if (result.getExceptionList().size() > 0) {
            String state = ResultLogStateEnum.FAIL.getValue();
            result.setState(state);
            String errorMsg = (String)result.getExceptionList().get(0);
            StringBuilder updateSql = new StringBuilder();
            updateSql.append(" update t_tdm_dc_result set fstate=?,ferrormsg_tag=?,fendtime=now()");
            updateSql.append(" where fid = ?");
            DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)updateSql.toString(), (Object[])new Object[]{state, errorMsg, result.getResultId()});
        } else if (result.getExecutorCount() == 0) {
            String state = ResultStateEnum.SUCCESS.getValue();
            result.setState(state);
            StringBuilder updateSql = new StringBuilder();
            updateSql.append(" update t_tdm_dc_result set fstate=?,fendtime=now(),ferrormsg_tag=null");
            updateSql.append(" where fid = ?");
            DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)updateSql.toString(), (Object[])new Object[]{state, result.getResultId()});
        } else {
            StringBuilder selectSql = new StringBuilder();
            selectSql.append(" select  sum(fsource_count) fsource_count, ");
            selectSql.append("         sum(ftar_noexistcount) ftar_noexistcount, ");
            selectSql.append("         sum(ftar_diffcount) ftar_diffcount,");
            selectSql.append("         sum(ftar_count) ftar_count,");
            selectSql.append("         sum(fsuccess_count) fsuccess_count");
            selectSql.append(" from  ").append("t_tdm_dc_resultlog").append(" where fresultid = ?  ");
            int source_count = 0;
            int tar_noexistcount = 0;
            int tar_diffcount = 0;
            int tar_count = 0;
            int success_count = 0;
            DataSet dataSet = DB.queryDataSet((String)DataCompareDataBusiness.class.getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)selectSql.toString(), (Object[])new Object[]{result.getResultId()});
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                source_count = row.getInteger("fsource_count");
                tar_noexistcount = row.getInteger("ftar_noexistcount");
                tar_diffcount = row.getInteger("ftar_diffcount");
                tar_count = row.getInteger("ftar_count");
                success_count = row.getInteger("fsuccess_count");
            }
            String state = tar_noexistcount == 0 && tar_diffcount == 0 ? ResultStateEnum.SUCCESS.getValue() : (success_count > 0 ? ResultStateEnum.PART.getValue() : ResultStateEnum.NO.getValue());
            result.setState(state);
            result.setSource_count(source_count);
            result.setTar_noexistcount(tar_noexistcount);
            result.setTar_diffcount(tar_diffcount);
            result.setTar_count(tar_count);
            result.setSuccess_count(success_count);
            StringBuilder updateSql = new StringBuilder();
            updateSql.append(" update t_tdm_dc_result set fsource_count = ?,ftar_noexistcount=?,ftar_diffcount=?,ftar_count=?,fsuccess_count=?,fstate=?,fendtime=now(),ferrormsg_tag=null");
            updateSql.append(" where fid = ?");
            DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)updateSql.toString(), (Object[])new Object[]{source_count, tar_noexistcount, tar_diffcount, tar_count, success_count, state, result.getResultId()});
        }
    }

    public static String submitResultDeleteJob(Map<String, Object> params) {
        JobInfo job = new JobInfo();
        job.setJobType(JobType.REALTIME);
        job.setName(ResManager.loadKDString((String)"\u6570\u636e\u6bd4\u5bf9\u7ed3\u679c\u5220\u9664\u4efb\u52a1", (String)"DataCompareBizBusiness_1", (String)"taxc-tdm-business", (Object[])new Object[0]));
        job.setTaskClassname("kd.taxc.tdm.business.datacompare.task.DataCompareDeleteTask");
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setId(UUID.randomUUID().toString());
        job.setParams(params);
        logger.info("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011submitResultDeleteJob JobClient dispatch");
        return JobClient.dispatch((JobInfo)job);
    }

    public static Future<Object> submitFuture(Callable call) {
        return ThreadPoolsUtils.submit(call);
    }

    public static Object getFutureValue(Future<Object> futrue) {
        try {
            return futrue.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011\u83b7\u53d6\u7ed3\u679c\u51fa\u9519\uff1a", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            return null;
        }
    }

    public static void waitFuture(List<Future<Object>> futrueList) {
        futrueList.forEach(v -> {
            try {
                v.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011\u83b7\u53d6\u7ed3\u679c\u51fa\u9519\uff1a", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        });
    }

    public static FiAccountDTO getFiAccountData(Long orgId, Long accountTableId, Date endDate, List<String> rootAccountNubmers) {
        DynamicObjectCollection accounts = DataCompareDataBusiness.getAccountList(orgId, accountTableId, endDate);
        return DataCompareBizBusiness.fiAccountCollToAccountDto(accounts, rootAccountNubmers);
    }

    public static TaxAccountDTO getTaxAccountData(Long orgId, List<String> rootAccountNubmers) {
        DynamicObjectCollection accounts = DataCompareDataBusiness.getTaxAccountList(orgId);
        return DataCompareBizBusiness.taxAccountCollToAccountDto(accounts, rootAccountNubmers);
    }

    private static FiAccountDTO fiAccountCollToAccountDto(DynamicObjectCollection accounts, List<String> rootNumbers) {
        List<String> rootAccountNumbers = accounts.stream().filter(v -> v.getLong("parent.id") == 0L).map(v -> v.getString("number")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rootNumbers)) {
            rootAccountNumbers.retainAll(rootNumbers);
        }
        ArrayList<String> accountNumbers = new ArrayList<String>(50);
        ArrayList<Long> accountIds = new ArrayList<Long>(50);
        HashMap<String, DynamicObject> accountRootMap = new HashMap<String, DynamicObject>(50);
        HashMap<String, DynamicObject> accountMap = new HashMap<String, DynamicObject>(50);
        HashMap<Long, DynamicObject> accountIdMap = new HashMap<Long, DynamicObject>(50);
        String rootAccountNumber = null;
        for (DynamicObject account : accounts) {
            accountIdMap.put(account.getLong("id"), account);
            accountMap.put(account.getString("number"), account);
            rootAccountNumber = DataCompareBizBusiness.getRootAcountNumber(account, rootAccountNumbers);
            if (!StringUtils.isNotBlank((CharSequence)rootAccountNumber)) continue;
            accountIds.add(account.getLong("id"));
            accountRootMap.put(account.getString("number"), (DynamicObject)accountMap.get(rootAccountNumber));
            accountNumbers.add(account.getString("number"));
        }
        FiAccountDTO accountDto = new FiAccountDTO();
        accountDto.setRootAccountNumbers(rootAccountNumbers);
        accountDto.setAccountIds(accountIds);
        accountDto.setAccountNumberMap(accountMap);
        accountDto.setAccountIdMap(accountIdMap);
        accountDto.setAccountNumbers(accountNumbers);
        accountDto.setAccountRootNumberMap(accountRootMap);
        return accountDto;
    }

    private static TaxAccountDTO taxAccountCollToAccountDto(DynamicObjectCollection accounts, List<String> rootNumbers) {
        List<String> rootAccountNumbers = accounts.stream().filter(v -> StringUtils.isEmpty((CharSequence)v.getString("parent.id")) || StringUtils.isEmpty((CharSequence)v.getString("parent.id").trim())).map(v -> v.getString("number")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rootNumbers)) {
            rootAccountNumbers.retainAll(rootNumbers);
        }
        ArrayList<String> accountIds = new ArrayList<String>(50);
        ArrayList<String> accountNumbers = new ArrayList<String>(50);
        HashMap<String, DynamicObject> accountRootMap = new HashMap<String, DynamicObject>(50);
        HashMap<String, DynamicObject> accountMap = new HashMap<String, DynamicObject>(50);
        String rootAccountNumber = null;
        for (DynamicObject account : accounts) {
            accountMap.put(account.getString("number"), account);
            rootAccountNumber = DataCompareBizBusiness.getRootAcountNumber(account, rootAccountNumbers);
            if (!StringUtils.isNotBlank((CharSequence)rootAccountNumber)) continue;
            accountRootMap.put(account.getString("number"), (DynamicObject)accountMap.get(rootAccountNumber));
            accountNumbers.add(account.getString("number"));
            accountIds.add(account.getString("id"));
        }
        TaxAccountDTO accountDto = new TaxAccountDTO();
        accountDto.setRootAccountNumbers(rootAccountNumbers);
        accountDto.setAccountIds(accountIds);
        accountDto.setAccountNumberMap(accountMap);
        accountDto.setAccountNumbers(accountNumbers);
        accountDto.setAccountRootNumberMap(accountRootMap);
        return accountDto;
    }

    public static String getRootAcountNumber(DynamicObject account, List<String> rootAccountNumbers) {
        String longnumber = account.getString("longnumber");
        if (StringUtils.isNotEmpty((CharSequence)longnumber)) {
            String rootAccountNumber = null;
            int size = rootAccountNumbers.size();
            for (int i = 0; i < size; ++i) {
                rootAccountNumber = rootAccountNumbers.get(i);
                if (longnumber.indexOf(rootAccountNumber) != 0) continue;
                return rootAccountNumber;
            }
        }
        return null;
    }
}

