/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.tdm.business.datacompare.enums.DataCompareSchemeConfig;
import kd.taxc.tdm.business.datacompare.enums.DataCompareSchemeEnum;
import kd.taxc.tdm.business.datacompare.enums.ResultLogStateEnum;
import kd.taxc.tdm.common.util.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DataCompareDataBusiness {
    public static Map<Long, DynamicObject> getAccountbookstypes(List<Long> ids) {
        QFilter filter = null;
        filter = CollectionUtils.isNotEmpty(ids) ? new QFilter("id", "in", ids) : new QFilter("1", "=", (Object)1);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id,name", (QFilter[])new QFilter[]{filter}, (String)"number");
        return coll.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
    }

    public static Map<String, Long> getAccountTableIds(List<Long> orgIds, List<Long> bookTypeIds) {
        QFilter filter = new QFilter("org.id", "in", orgIds);
        filter.and(new QFilter("bookstype.id", "in", bookTypeIds));
        filter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"org.id,bookstype.id,accounttable.id", (QFilter[])new QFilter[]{filter});
        HashMap<String, Long> map = new HashMap<String, Long>(10);
        String key = null;
        for (DynamicObject obj : coll) {
            key = obj.getLong("org.id") + "_" + obj.getLong("bookstype.id");
            map.put(key, obj.getLong("accounttable.id"));
        }
        return map;
    }

    public static Map<Long, List<Long>> getSupportBookTypeIdsByOrgIdsMap(List<Long> orgIds) {
        QFilter filter = new QFilter("org.id", "in", orgIds);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"org.id,bookstype.id", (QFilter[])new QFilter[]{filter});
        HashMap<Long, List<Long>> orgSupportBookTypeIdsMap = new HashMap<Long, List<Long>>(10);
        for (DynamicObject obj : coll) {
            Long orgId = obj.getLong("org.id");
            List bookTypes = orgSupportBookTypeIdsMap.computeIfAbsent(orgId, d -> new ArrayList());
            bookTypes.add(obj.getLong("bookstype.id"));
        }
        return orgSupportBookTypeIdsMap;
    }

    public static List<Long> getBookTypeIdsByOrgIds(List<Long> orgIds) {
        QFilter filter = new QFilter("org.id", "in", orgIds);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype.id", (QFilter[])new QFilter[]{filter});
        HashSet<Long> bookTypeIds = new HashSet<Long>(10);
        for (DynamicObject obj : coll) {
            bookTypeIds.add(obj.getLong("bookstype.id"));
        }
        return new ArrayList<Long>(bookTypeIds);
    }

    public static DynamicObjectCollection getPeriods(String startPeriod, String endPeriod) {
        QFilter periodFilter = new QFilter("number", ">=", (Object)startPeriod);
        periodFilter.and(new QFilter("number", "<=", (Object)endPeriod));
        periodFilter.and(new QFilter("periodtype", "=", (Object)1L));
        periodFilter.and(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
        return QueryServiceHelper.query((String)"bd_period", (String)"id,number,periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{periodFilter});
    }

    public static DynamicObjectCollection getPeriodAdjustByDate(Date date) {
        QFilter fitlers = new QFilter("beginDate", "<=", (Object)date);
        fitlers.and(new QFilter("enddate", ">=", (Object)date));
        fitlers.and(new QFilter("periodtype", "=", (Object)1L));
        fitlers.and(new QFilter("isadjustperiod", "=", (Object)Boolean.TRUE));
        return QueryServiceHelper.query((String)"bd_period", (String)"id,number,periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{fitlers});
    }

    public static DynamicObjectCollection getAccountList(Long orgId, Long accountTableId, Date enddate) {
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        QFilter accountTableFilter = new QFilter("accounttable", "=", (Object)accountTableId);
        QFilter dateFitler = new QFilter("startdate", "<=", (Object)enddate).and(new QFilter("enddate", ">=", (Object)enddate));
        return BaseDataServiceHelper.queryBaseData((String)"bd_accountview", (Long)orgId, (QFilter)orgFilter.and(accountTableFilter).and(dateFitler), (String)"id,number,name,longnumber,parent.id");
    }

    public static DynamicObjectCollection getTaxAccountList(Long orgId) {
        QFilter filters = new QFilter("org.id", "=", (Object)orgId);
        return QueryServiceHelper.query((String)"tdm_account", (String)"id,number,name,longnumber,parent.id", (QFilter[])new QFilter[]{filters});
    }

    public static DynamicObject loadSingle(Long pk, String entityId) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityId);
    }

    public static void deleteTotalData(List<Long> resultIds, String entityId) {
        QFilter filter = new QFilter("resultid", "in", resultIds);
        DeleteServiceHelper.delete((String)entityId, (QFilter[])new QFilter[]{filter});
    }

    public static void deleteDetailData(List<Long> resultIds, String entityId) {
        QFilter filter = new QFilter("resultid", "in", resultIds);
        DeleteServiceHelper.delete((String)entityId, (QFilter[])new QFilter[]{filter});
    }

    public static void deleleOldData(Long resultId, Long schemeId, Long orgId, String booktype, int periodnumber) {
        DataCompareSchemeConfig config = DataCompareSchemeEnum.getEnum(schemeId).getConfig();
        QFilter filter = new QFilter("resultid", "=", (Object)resultId);
        filter.and(new QFilter("org.id", "=", (Object)orgId));
        filter.and(new QFilter("accountbookstype", "=", (Object)booktype));
        filter.and(new QFilter("periodnumber", "=", (Object)periodnumber));
        DeleteServiceHelper.delete((String)config.getTotalFormId(), (QFilter[])new QFilter[]{filter});
        DeleteServiceHelper.delete((String)config.getDetailFormId(), (QFilter[])new QFilter[]{filter});
    }

    public static void deleteResultLogData(List<Long> resultIds) {
        QFilter filter = new QFilter("resultid", "in", resultIds);
        DeleteServiceHelper.delete((String)"tdm_dc_resultlog", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection getOnTheWayResult(Long schemeId) {
        List<String> stateList = Arrays.asList("C", "R");
        QFilter filter = new QFilter("state", "in", stateList);
        filter.and("scheme.id", "=", (Object)schemeId);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"tdm_dc_result", (String)"datarange_tag", (QFilter[])new QFilter[]{filter});
        return coll;
    }

    public static DynamicObjectCollection queryOrgList(List<Long> orgIds) {
        QFilter qfilter = new QFilter("id", "in", orgIds);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{qfilter});
        return coll;
    }

    public static DynamicObjectCollection queryVoildOrgList() {
        QFilter qfilter = new QFilter("isbizorg", "=", (Object)Boolean.TRUE);
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        qfilter.and(new QFilter("istax", "=", (Object)"1"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{qfilter});
        return coll;
    }

    public static DynamicObjectCollection queryResultLogList(Long resultId) {
        String fields = "id,datarange_tag,state,source_count,tar_count,starttime,endtime";
        QFilter filter = new QFilter("resultid", "=", (Object)resultId);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"tdm_dc_resultlog", (String)fields, (QFilter[])new QFilter[]{filter}, (String)"id desc");
        return coll;
    }

    public static DynamicObjectCollection queryRetryResultLogList(Long resultId) {
        List<String> stateList = Arrays.asList(ResultLogStateEnum.CREATE.getValue(), ResultLogStateEnum.FAIL.getValue());
        String fields = "id,datarange_tag,state,source_count,tar_count,starttime,endtime";
        QFilter filter = new QFilter("resultid", "=", (Object)resultId);
        filter.and(new QFilter("state", "in", stateList));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"tdm_dc_resultlog", (String)fields, (QFilter[])new QFilter[]{filter}, (String)"id desc");
        return coll;
    }

    public static Map<String, Object> getDataRange(Long resultid) {
        DynamicObject result = BusinessDataServiceHelper.loadSingleFromCache((Object)resultid, (String)"tdm_dc_result");
        String dataRangeText = result.getString("datarange_tag");
        if (StringUtils.isNotBlank((CharSequence)dataRangeText)) {
            Map dataRange = (Map)SerializationUtils.fromJsonString((String)dataRangeText, HashMap.class);
            List orgIds_db = ObjectUtils.toLongList((List)((List)dataRange.get("orgIds")));
            List bookTypeIds_db = ObjectUtils.toLongList((List)((List)dataRange.get("bookTypeIds")));
            List rootAccountNumbers_db = (List)dataRange.get("rootAccountNumbers");
            String startPeriod = (String)dataRange.get("startPeriod");
            String endPeriod = (String)dataRange.get("endPeriod");
            HashMap<String, Object> dataRangeMap = new HashMap<String, Object>(10);
            dataRangeMap.put("orgIds", orgIds_db);
            dataRangeMap.put("bookTypeIds", bookTypeIds_db);
            dataRangeMap.put("rootAccountNumbers", rootAccountNumbers_db);
            dataRangeMap.put("startPeriod", startPeriod);
            dataRangeMap.put("endPeriod", endPeriod);
            return dataRangeMap;
        }
        return null;
    }
}

