/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.model;

import java.beans.Transient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareConfig;
import kd.taxc.tdm.business.datacompare.model.FIDataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.model.FiAccountDTO;
import kd.taxc.tdm.business.datacompare.model.TaxAccountDTO;
import kd.taxc.tdm.business.datacompare.model.VoucherSumVO;

public class VoucherDataCompareTaskParams
extends FIDataCompareTaskParams {
    private Long orgId;
    private Long bookTypeId;
    private Long periodId;
    private Long accountTableId;
    private List<String> rootAccountNumbers = new ArrayList<String>(10);
    private String orgName;
    private String bookTypeName;
    private int periodNumber;
    private List<String> allRootAccountNumbers = new ArrayList<String>(10);
    private DynamicObject period;
    private FiAccountDTO fiAccountDto;
    private TaxAccountDTO taxAccountDto;
    private Map<String, VoucherSumVO> voucherSumMap = new HashMap<String, VoucherSumVO>(50);

    public VoucherDataCompareTaskParams(DataCompareConfig config) {
        super(config);
    }

    public DynamicObject getAccountByNumber(String accountNumber) {
        DynamicObject dynamicObject = this.getFiAccountDto().getAccountNumberMap().get(accountNumber);
        if (dynamicObject == null) {
            dynamicObject = this.getTaxAccountDto().getAccountNumberMap().get(accountNumber);
        }
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s \uff0c\u79d1\u76ee\u7f16\u7801\uff1a%2$s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u79d1\u76ee\u6570\u636e", (String)"VoucherDataCompareTaskParams_0", (String)"taxc-tdm-business", (Object[])new Object[]{this.orgName, accountNumber}));
        }
        return dynamicObject;
    }

    public DynamicObject getAccountRootByNumber(String accountNumber) {
        DynamicObject dynamicObject = this.getFiAccountDto().getAccountRootNumberMap().get(accountNumber);
        if (dynamicObject == null) {
            dynamicObject = this.getTaxAccountDto().getAccountRootNumberMap().get(accountNumber);
        }
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s \uff0c\u79d1\u76ee\u7f16\u7801\uff1a%2$s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u4e00\u7ea7\u79d1\u76ee\u6570\u636e", (String)"VoucherDataCompareTaskParams_1", (String)"taxc-tdm-business", (Object[])new Object[]{this.orgName, accountNumber}));
        }
        return dynamicObject;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getBookTypeId() {
        return this.bookTypeId;
    }

    public void setBookTypeId(Long bookTypeId) {
        this.bookTypeId = bookTypeId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Long getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(Long accountTableId) {
        this.accountTableId = accountTableId;
    }

    public List<String> getRootAccountNumbers() {
        return this.rootAccountNumbers;
    }

    public void setRootAccountNumbers(List<String> rootAccountNumbers) {
        this.rootAccountNumbers = rootAccountNumbers;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBookTypeName() {
        return this.bookTypeName;
    }

    public void setBookTypeName(String bookTypeName) {
        this.bookTypeName = bookTypeName;
    }

    public int getPeriodNumber() {
        return this.periodNumber;
    }

    public void setPeriodNumber(int periodNumber) {
        this.periodNumber = periodNumber;
    }

    @Transient
    public Map<String, VoucherSumVO> getVoucherSumMap() {
        return this.voucherSumMap;
    }

    public void setVoucherSumMap(Map<String, VoucherSumVO> voucherSumMap) {
        this.voucherSumMap = voucherSumMap;
    }

    @Transient
    public FiAccountDTO getFiAccountDto() {
        return this.fiAccountDto;
    }

    public void setFiAccountDto(FiAccountDTO fiAccountDto) {
        this.fiAccountDto = fiAccountDto;
    }

    @Transient
    public TaxAccountDTO getTaxAccountDto() {
        return this.taxAccountDto;
    }

    public void setTaxAccountDto(TaxAccountDTO taxAccountDto) {
        this.taxAccountDto = taxAccountDto;
    }

    @Transient
    public DynamicObject getPeriod() {
        return this.period;
    }

    public void setPeriod(DynamicObject period) {
        this.period = period;
    }

    @Transient
    public List<String> getAllRootAccountNumbers() {
        return this.allRootAccountNumbers;
    }

    public void setAllRootAccountNumbers(List<String> allRootAccountNumbers) {
        this.allRootAccountNumbers = allRootAccountNumbers;
    }
}

