/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.service.impl;

import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataFetchService;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.enums.AcctDepreChangeFieldEnum;
import kd.taxc.tdm.business.datacompare.model.AccountDepreDataCompareTaskParams;
import kd.taxc.tdm.common.util.DateUtils;

public class AccountDepreDataAlgoFilterFetchService
implements IDataFetchService {
    private static String SRC_EXTRA_FIELDS = ",id id_src,org org_src,assetcode assetcode_src,TO_CHAR(accountingperiod,'yyyy-MM-dd') accountingperiod_src,assetname assetname_src";
    private static String DEST_EXTRA_FIELDS = ",id id_dest,org org_dest,assetcode assetcode_dest,TO_CHAR(accountingperiod,'yyyy-MM-dd') accountingperiod_dest,assetname assetname_dest";
    private static Log logger = LogFactory.getLog(AccountDepreDataAlgoFilterFetchService.class);

    public void initData(DataCompareTaskParams taskParams) {
    }

    public Object getSrcData(DataCompareTaskParams taskParams) {
        return this.getData("src", taskParams);
    }

    public Object getDestData(DataCompareTaskParams taskParams) {
        return this.getData("dest", taskParams);
    }

    public Object getData(String type, DataCompareTaskParams taskParams) {
        AccountDepreDataCompareTaskParams accountDepreTaskParam = (AccountDepreDataCompareTaskParams)taskParams;
        Long orgId = accountDepreTaskParam.getOrgId();
        String assetcode = accountDepreTaskParam.getAssetcode();
        Date startperiod = accountDepreTaskParam.getStartperiod();
        Date endperiod = accountDepreTaskParam.getEndperiod();
        if (orgId == null || StringUtils.isEmpty((String)assetcode) || startperiod == null) {
            return null;
        }
        if ("dest".equals(type)) {
            startperiod = DateUtils.addMonth((Date)startperiod, (int)-1);
            endperiod = endperiod == null ? null : DateUtils.addMonth((Date)endperiod, (int)-1);
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter assetcodeFilter = new QFilter("assetcode", "=", (Object)assetcode);
        QFilter periodFilter = new QFilter("accountingperiod", ">=", (Object)startperiod);
        if (endperiod != null) {
            periodFilter.and(new QFilter("accountingperiod", "<=", (Object)endperiod));
        }
        StringBuilder selectorSB = new StringBuilder();
        AcctDepreChangeFieldEnum[] changeFieldEnums = AcctDepreChangeFieldEnum.values();
        for (int i = 0; i < changeFieldEnums.length; ++i) {
            if (selectorSB.length() != 0) {
                selectorSB.append(",");
            }
            selectorSB.append((Object)changeFieldEnums[i]).append(" ").append((Object)changeFieldEnums[i]);
            if ("src".equals(type)) {
                selectorSB.append("_src");
                continue;
            }
            selectorSB.append("_dest");
        }
        if ("src".equals(type)) {
            selectorSB.append(SRC_EXTRA_FIELDS);
        } else {
            selectorSB.append(DEST_EXTRA_FIELDS);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tdm_account_depreciation", (String)selectorSB.toString(), (QFilter[])new QFilter[]{orgFilter, assetcodeFilter, periodFilter}, null);
        if ("dest".equals(type)) {
            dataSet = dataSet.addField("TO_CHAR(DATEADD(Month,1,accountingperiod_dest),'yyyy-MM-dd')", "period_dest");
        }
        return dataSet;
    }
}

