/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataCalculateService;
import kd.taxc.bdtaxr.common.enums.comparisonmodel.DataCompareEnum;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareConfig;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareParams;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareResult;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.enums.AcctDepreChangeFieldEnum;
import kd.taxc.tdm.business.datacompare.model.AccountDepreDataCompareTaskParams;

public class AccountDepreDataCalculateService
implements IDataCalculateService {
    public List<DataCompareTaskParams> buildTaskParamsList(DataCompareParams dataCompareParams, DataCompareResult result) {
        ArrayList<DataCompareTaskParams> taskParams = new ArrayList<DataCompareTaskParams>(10);
        DataCompareConfig config = DataCompareEnum.getEnum((Long)dataCompareParams.getSchemeId()).getConfig();
        if (dataCompareParams.getParams().containsKey("paramList")) {
            List paramList = (List)dataCompareParams.getParams().get("paramList");
            if (paramList != null && !paramList.isEmpty()) {
                for (Map paramMap : paramList) {
                    AccountDepreDataCompareTaskParams taskParam = new AccountDepreDataCompareTaskParams(config);
                    taskParam.setOrgId((Long)paramMap.get("orgId"));
                    taskParam.setAssetcode((String)paramMap.get("assetcode"));
                    taskParam.setStartperiod((Date)paramMap.get("currentPeriod"));
                    taskParam.setEndperiod((Date)paramMap.get("currentPeriod"));
                    taskParams.add(taskParam);
                }
            }
        } else {
            AccountDepreDataCompareTaskParams taskParam = new AccountDepreDataCompareTaskParams(config);
            taskParam.setOrgId((Long)dataCompareParams.getParams().get("orgId"));
            taskParam.setAssetcode((String)dataCompareParams.getParams().get("assetcode"));
            taskParam.setStartperiod((Date)dataCompareParams.getParams().get("startperiod"));
            taskParam.setEndperiod((Date)dataCompareParams.getParams().get("endperiod"));
            taskParams.add(taskParam);
        }
        return taskParams;
    }

    public int getBatchSize() {
        return 2;
    }

    public Object calculate(Object srcData, Object destData, DataCompareTaskParams taskParams) {
        DataSet srcDataSet = (DataSet)srcData;
        DataSet destDataSet = (DataSet)destData;
        if (srcData == null || destData == null) {
            return null;
        }
        DataSet joinedDataSet = srcDataSet.fullJoin(destDataSet).on("org_src", "org_dest").on("assetcode_src", "assetcode_dest").on("accountingperiod_src", "period_dest").select(this.getSelectFields()).finish();
        return this.doCompare(joinedDataSet);
    }

    protected String[] getSelectFields() {
        AcctDepreChangeFieldEnum[] changeFieldEnum;
        ArrayList<String> selectFieldsList = new ArrayList<String>(19);
        for (AcctDepreChangeFieldEnum acctDepreChangeFieldEnum : changeFieldEnum = AcctDepreChangeFieldEnum.values()) {
            selectFieldsList.add(acctDepreChangeFieldEnum.getFieldName() + "_src");
            selectFieldsList.add(acctDepreChangeFieldEnum.getFieldName() + "_dest");
        }
        selectFieldsList.add("id_src");
        selectFieldsList.add("id_dest");
        selectFieldsList.add("assetcode_src");
        selectFieldsList.add("assetcode_dest");
        selectFieldsList.add("org_src");
        selectFieldsList.add("org_dest");
        selectFieldsList.add("accountingperiod_src");
        selectFieldsList.add("accountingperiod_dest");
        selectFieldsList.add("period_dest");
        selectFieldsList.add("assetname_src");
        selectFieldsList.add("assetname_dest");
        return selectFieldsList.toArray(new String[0]);
    }

    public DataSet doCompare(DataSet selectedDataSet) {
        AcctDepreChangeFieldEnum[] changeFieldEnums;
        StringBuilder expression = new StringBuilder();
        for (AcctDepreChangeFieldEnum changeFieldEnum : changeFieldEnums = AcctDepreChangeFieldEnum.values()) {
            expression.setLength(0);
            expression.append("case when ").append(changeFieldEnum.getFieldName()).append("_src is null then 'hasNull'");
            expression.append("     when ").append(changeFieldEnum.getFieldName()).append("_dest is null then 'hasNull'");
            expression.append("     when ").append(changeFieldEnum.getFieldName()).append("_src");
            expression.append("     != ").append(changeFieldEnum.getFieldName()).append("_dest then 'diff'");
            expression.append("     else 'same' end ");
            selectedDataSet = selectedDataSet.addField(expression.toString(), changeFieldEnum.getFieldName() + "_result");
        }
        return selectedDataSet;
    }
}

