/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.service.impl;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataResultService;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.enums.AcctDepreChangeFieldEnum;
import kd.taxc.tdm.business.datacompare.model.AccountDepreDataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.model.AcctDepreChangeEntryVO;
import kd.taxc.tdm.business.datacompare.model.AcctDepreChangeVO;
import org.apache.commons.collections4.CollectionUtils;

public class AccountDepreResultService
implements IDataResultService {
    private static Log logger = LogFactory.getLog(AccountDepreResultService.class);
    public static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final String INSERT_HEAD_SQL = "INSERT INTO t_tdm_acctdeprechange (fid,forg,fassetcode,fassetname,faccountingperiod,fpreaccountdepreid,faccountdepreid,fcreatedate) VALUES \n(?,?,?,?,?,?,?,?);";
    private static final String INSERT_ENTRY_SQL = "INSERT INTO t_tdm_acctdeprechange_e(fid,fentryid,fseq,fchangefield,fchangefieldname,foldvalue,fnewvalue) VALUES (?,?,?,?,?,?,?);";
    private static final String DELETE_HEAD_SQL = "DELETE FROM t_tdm_acctdeprechange WHERE faccountdepreid = ? ;";
    private static final String DELETE_ENTRY_SQL = "DELETE FROM t_tdm_acctdeprechange_e WHERE fid = (select fid from t_tdm_acctdeprechange where faccountdepreid = ?);";

    public static String dealValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            Instant instant = ((Date)value).toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
            return localDateTime.format(DATETIME_FORMAT);
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return "true";
            }
            return "false";
        }
        return value.toString();
    }

    public void saveResult(Object calResult, DataCompareTaskParams taskParams) {
        if (calResult == null) {
            return;
        }
        DataSet calResultDataSet = (DataSet)calResult;
        AccountDepreDataCompareTaskParams compareTaskParams = (AccountDepreDataCompareTaskParams)taskParams;
        ArrayList<Object[]> headParamList = new ArrayList<Object[]>(this.getBatchSize());
        ArrayList<Object[]> entryParamList = new ArrayList<Object[]>(this.getBatchSize());
        ArrayList<Object[]> deleteParamList = new ArrayList<Object[]>(this.getBatchSize());
        Row row = null;
        while (calResultDataSet.hasNext()) {
            row = calResultDataSet.next();
            this.addToParamList(row, compareTaskParams, headParamList, entryParamList, deleteParamList);
            if (headParamList.size() + entryParamList.size() < this.getBatchSize()) continue;
            this.saveCompareResult(headParamList, entryParamList, deleteParamList, compareTaskParams);
            headParamList.clear();
            entryParamList.clear();
            deleteParamList.clear();
        }
        if (headParamList.size() > 0 || entryParamList.size() > 0 || deleteParamList.size() > 0) {
            this.saveCompareResult(headParamList, entryParamList, deleteParamList, compareTaskParams);
        }
    }

    public void saveCompareResult(List<Object[]> headParamList, List<Object[]> entryParamList, List<Object[]> deleteParamList, AccountDepreDataCompareTaskParams taskParams) {
        try (TXHandle h = TX.required();){
            try {
                if (CollectionUtils.isNotEmpty(deleteParamList)) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)DELETE_ENTRY_SQL, deleteParamList);
                    DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)DELETE_HEAD_SQL, deleteParamList);
                }
                if (CollectionUtils.isNotEmpty(headParamList)) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)INSERT_HEAD_SQL, headParamList);
                }
                if (CollectionUtils.isNotEmpty(entryParamList)) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)INSERT_ENTRY_SQL, entryParamList);
                }
            }
            catch (Throwable t) {
                h.markRollback();
                logger.error("saveCompareResult error" + t.getMessage());
            }
        }
    }

    public void addToParamList(Row row, AccountDepreDataCompareTaskParams taskParams, List<Object[]> headParamList, List<Object[]> entryParamList, List<Object[]> deleteParamList) {
        Long id_src;
        AcctDepreChangeFieldEnum[] changeFieldEnums;
        if (row.get("id_src") == null) {
            return;
        }
        Long headId = null;
        int seq = 1;
        ArrayList<AcctDepreChangeEntryVO> tempChangeEntryVOList = new ArrayList<AcctDepreChangeEntryVO>(10);
        for (AcctDepreChangeFieldEnum changeFieldEnum : changeFieldEnums = AcctDepreChangeFieldEnum.values()) {
            String compareResult = row.getString(changeFieldEnum.getFieldName() + "_result");
            if (!"diff".equals(compareResult) || AcctDepreChangeFieldEnum.ASSETORIVALUE == changeFieldEnum && BigDecimal.ZERO.compareTo(row.getBigDecimal(changeFieldEnum.getFieldName() + "_dest")) == 0) continue;
            if (headId == null) {
                headId = DB.genLongId((String)"t_tdm_acctdeprechange");
            }
            AcctDepreChangeEntryVO entryVO = new AcctDepreChangeEntryVO();
            entryVO.setId(headId);
            entryVO.setSeq(seq++);
            entryVO.setChangeField(changeFieldEnum.getFieldName());
            entryVO.setChangeFieldName(changeFieldEnum.getFieldChinese());
            entryVO.setOldvalue(AccountDepreResultService.dealValue(row.get(changeFieldEnum.getFieldName() + "_dest")));
            entryVO.setNewvalue(AccountDepreResultService.dealValue(row.get(changeFieldEnum.getFieldName() + "_src")));
            tempChangeEntryVOList.add(entryVO);
        }
        if (!tempChangeEntryVOList.isEmpty()) {
            long[] entryIds = DB.genLongIds((String)"t_tdm_acctdeprechange_e", (int)tempChangeEntryVOList.size());
            int index = 0;
            for (AcctDepreChangeEntryVO entryVO : tempChangeEntryVOList) {
                entryVO.setEntryId(entryIds[index++]);
                entryParamList.add(entryVO.toObjects());
            }
        }
        if (headId != null) {
            AcctDepreChangeVO headVO = new AcctDepreChangeVO();
            headVO.setId(headId);
            headVO.setOrgId(taskParams.getOrgId());
            headVO.setAssetcode(taskParams.getAssetcode());
            headVO.setAssetname(row.getString("assetname_src"));
            headVO.setPreAccountDepreId(row.getLong("id_dest"));
            headVO.setAccountDepreId(row.getLong("id_src"));
            headVO.setCreatedate(new Date());
            LocalDate localDate = LocalDate.parse(row.getString("accountingperiod_src"), DATE_FORMAT);
            headVO.setAccountingperiod(Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
            headParamList.add(headVO.toObjects());
        }
        if ((id_src = row.getLong("id_src")) != null) {
            deleteParamList.add(new Object[]{id_src});
        }
    }
}

