/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataFetchService;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.DataCompareBizBusiness;
import kd.taxc.tdm.business.datacompare.model.BalanceDataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.model.BalanceQueryParam;
import kd.taxc.tdm.business.datacompare.model.FiAccountDTO;
import kd.taxc.tdm.business.datacompare.model.TaxAccountDTO;
import kd.taxc.tdm.business.datacompare.util.BalanceServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class BalanceDataAlgoFilterFetchService
implements IDataFetchService {
    private static String[] SRC_SELECT_FIELDS = new String[]{"org", "booktype", "accounttable", "account", "dc", "currency", "measureunit", "beginlocal"};
    private static String[] SRC_GROUPBY_FIELDS = new String[]{"account", "org", "booktype", "accounttable", "currency", "measureunit", "dc"};
    private static String DEST_SELECT_FIELDS = "billno accountnumber_dest,openingbalancetype dc_dest,openinglocalcurrency,accountbookstype,sourcesys";

    public void initData(DataCompareTaskParams taskParams) {
        BalanceDataCompareTaskParams balanceTaskParams = (BalanceDataCompareTaskParams)taskParams;
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)balanceTaskParams.getPeriodId(), (String)"bd_period");
        FiAccountDTO fiAccountDto = DataCompareBizBusiness.getFiAccountData(balanceTaskParams.getOrgId(), balanceTaskParams.getAccountTableId(), period.getDate("enddate"), balanceTaskParams.getRootAccountNumbers());
        TaxAccountDTO taxAccountDto = DataCompareBizBusiness.getTaxAccountData(balanceTaskParams.getOrgId(), balanceTaskParams.getRootAccountNumbers());
        HashSet<String> set = new HashSet<String>(50);
        set.addAll(fiAccountDto.getRootAccountNumbers());
        set.addAll(taxAccountDto.getRootAccountNumbers());
        balanceTaskParams.setAllRootAccountNumbers(new ArrayList<String>(set));
        balanceTaskParams.setFiAccountDto(fiAccountDto);
        balanceTaskParams.setTaxAccountDto(taxAccountDto);
        balanceTaskParams.setPeriod(period);
    }

    public Object getSrcData(DataCompareTaskParams taskParams) {
        int i;
        BalanceDataCompareTaskParams balanceTaskParams = (BalanceDataCompareTaskParams)taskParams;
        BalanceQueryParam queryParam = new BalanceQueryParam();
        queryParam.setOrgId(balanceTaskParams.getOrgId());
        queryParam.setBookTypeId(balanceTaskParams.getBookTypeId());
        queryParam.setAccountTableId(balanceTaskParams.getAccountTableId());
        queryParam.setPeriodId(balanceTaskParams.getPeriodId());
        int size = SRC_SELECT_FIELDS.length;
        for (i = 0; i < size; ++i) {
            queryParam.addSelector(SRC_SELECT_FIELDS[i]);
        }
        size = SRC_GROUPBY_FIELDS.length;
        for (i = 0; i < size; ++i) {
            queryParam.addGroupBy(SRC_GROUPBY_FIELDS[i]);
        }
        if (balanceTaskParams.getFiAccountDto().getAccountIds().size() == 0) {
            RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"accountnumber_src", "dc_src", "beginlocal"}, (DataType[])new DataType[]{DataType.StringType, DataType.StringType, DataType.BigDecimalType});
            CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList(0));
            DataSet dataSet = Algo.create((String)this.getClass().getName()).createDataSet(new Input[]{inputs});
            return dataSet;
        }
        balanceTaskParams.getFiAccountDto().getAccountIds().forEach(accountId -> queryParam.setAccountAssgrp((Long)accountId, null));
        List<Map<String, Object>> balances = BalanceServiceHelper.getBalance(queryParam);
        List colls = balances.stream().map(v -> {
            DynamicObject account = balanceTaskParams.getFiAccountDto().getAccountIdMap().get(v.get("account"));
            Object[] objects = new Object[]{account != null ? account.getString("number") : String.valueOf(v.get("account")), v.get("dc"), v.get("beginlocal")};
            return objects;
        }).collect(Collectors.toList());
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"accountnumber_src", "dc_src", "beginlocal"}, (DataType[])new DataType[]{DataType.StringType, DataType.StringType, DataType.BigDecimalType});
        CollectionInput inputs = new CollectionInput(rowMeta, colls);
        DataSet dataSet = Algo.create((String)this.getClass().getName()).createDataSet(new Input[]{inputs});
        dataSet = dataSet.groupBy(new String[]{"accountnumber_src", "dc_src"}).sum("beginlocal", "beginlocal").finish();
        return dataSet;
    }

    public Object getDestData(DataCompareTaskParams taskParams) {
        BalanceDataCompareTaskParams balanceTaskParams = (BalanceDataCompareTaskParams)taskParams;
        String accountBooksTypeName = balanceTaskParams.getBookTypeName();
        DynamicObject period = balanceTaskParams.getPeriod();
        int periodYear = period.getInt("periodyear");
        int periodNumber = period.getInt("periodnumber");
        String accountYear = String.valueOf(periodYear);
        String accountperiod = periodNumber < 10 ? "0" + periodNumber : String.valueOf(periodNumber);
        QFilter orgFilter = new QFilter("org.id", "=", (Object)balanceTaskParams.getOrgId());
        QFilter accountYearFilter = new QFilter("accountyear", "=", (Object)accountYear);
        QFilter accountPeriodFilter = new QFilter("accountperiod", "=", (Object)accountperiod);
        QFilter[] filters = new QFilter[]{orgFilter, accountYearFilter, accountPeriodFilter};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tdm_balance_new", (String)DEST_SELECT_FIELDS, (QFilter[])filters, null);
        QFilter accountBookTypeFilter = new QFilter("accountbookstype", "=", (Object)accountBooksTypeName);
        QFilter defaultFilter = new QFilter("sourcesys", "=", (Object)ResManager.loadKDString((String)"\u8d22\u52a1\u4e91", (String)"BalanceDataAlgoFilterFetchService_0", (String)"taxc-tdm-business", (Object[])new Object[0]));
        dataSet = dataSet.filter(accountBookTypeFilter.and(defaultFilter).toString());
        if (CollectionUtils.isNotEmpty(balanceTaskParams.getRootAccountNumbers())) {
            if (CollectionUtils.isEmpty(balanceTaskParams.getTaxAccountDto().getAccountNumbers())) {
                QFilter accountFilter = new QFilter("1", "!=", (Object)1);
                dataSet = dataSet.filter(accountFilter.toString());
            } else {
                HashMap<String, List<String>> params = new HashMap<String, List<String>>();
                params.put("var", balanceTaskParams.getTaxAccountDto().getAccountNumbers());
                dataSet = dataSet.filter("accountnumber_dest in var", params);
            }
        }
        return dataSet;
    }
}

