/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.service.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.taxc.tdm.business.datacompare.DataCompareDataBusiness;
import kd.taxc.tdm.business.datacompare.enums.DataCompareDiffTypeEnum;
import kd.taxc.tdm.business.datacompare.enums.DataCompareStateEnum;
import kd.taxc.tdm.business.datacompare.model.BalanceDataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.model.BalanceSumVO;
import kd.taxc.tdm.business.datacompare.model.BalanceVO;
import kd.taxc.tdm.business.datacompare.model.FIDataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.service.impl.FIDataResultService;
import kd.taxc.tdm.common.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BalanceDataResultService
extends FIDataResultService {
    private static final String INSERT_DETAIL_SQL = "insert into t_tdm_dc_balance(fid,fresultid,ftotalid,forgid,faccountnumber,faccountname,fperiodnumber,faccountbookstype,fdebitbegin_src,fcreditbegin_src,fdebitbegin_dest,fcreditbegin_dest,fstate,fdifftype) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_TOTAL_SQL = "insert into t_tdm_dc_balancesum(fid,fresultid,forgid,faccountnumber,faccountname,fperiodnumber,faccountbookstype,fdebitbegin_src,fcreditbegin_src,fdebitbegin_dest,fcreditbegin_dest,fstate) values (?,?,?,?,?,?,?,?,?,?,?,?)";

    @Override
    public Object[] rowToObj(Row row, FIDataCompareTaskParams taskParams) {
        BalanceDataCompareTaskParams balanceTaskParams = (BalanceDataCompareTaskParams)taskParams;
        DynamicObject account = balanceTaskParams.getAccountByNumber(row.getString("accountnumber"));
        DynamicObject rootAccount = balanceTaskParams.getAccountRootByNumber(row.getString("accountnumber"));
        BalanceSumVO sumDto = balanceTaskParams.getBalanceSumMap().get(rootAccount.getString("number"));
        BalanceVO balanceVo = new BalanceVO();
        balanceVo.setResultId(balanceTaskParams.getResultId());
        balanceVo.setTotalId(sumDto.getId());
        balanceVo.setOrgId(balanceTaskParams.getOrgId());
        balanceVo.setAccountNumber(row.getString("accountnumber"));
        balanceVo.setAccountName(account.getString("name"));
        balanceVo.setPeriod(balanceTaskParams.getPeriodNumber());
        balanceVo.setBookType(balanceTaskParams.getBookTypeName());
        BigDecimal beginlocal = row.getBigDecimal("beginlocal");
        if (beginlocal != null) {
            String dc_flag = row.getString("dc_src");
            String debitFlag = "1";
            String creditFlag = "-1";
            if (StringUtil.isNotEmpty((CharSequence)dc_flag) && debitFlag.equalsIgnoreCase(dc_flag)) {
                balanceVo.setDebitbegin_src(beginlocal);
                balanceVo.setCreditbegin_src(BigDecimal.ZERO);
            } else if (StringUtil.isNotEmpty((CharSequence)dc_flag) && creditFlag.equalsIgnoreCase(dc_flag)) {
                balanceVo.setDebitbegin_src(BigDecimal.ZERO);
                balanceVo.setCreditbegin_src(beginlocal);
            } else if (beginlocal.compareTo(BigDecimal.ZERO) > 0) {
                balanceVo.setDebitbegin_src(beginlocal);
                balanceVo.setCreditbegin_src(BigDecimal.ZERO);
            } else {
                balanceVo.setDebitbegin_src(BigDecimal.ZERO);
                balanceVo.setCreditbegin_src(beginlocal.abs());
            }
        } else {
            balanceVo.setDebitbegin_src(BigDecimal.ZERO);
            balanceVo.setCreditbegin_src(BigDecimal.ZERO);
        }
        BigDecimal openinglocalcurrency = row.getBigDecimal("openinglocalcurrency");
        if (openinglocalcurrency != null) {
            String dc_flag = row.getString("dc_dest");
            String debitFlag = ResManager.loadKDString((String)"\u501f", (String)"BalanceDataResultService_0", (String)"taxc-tdm-business", (Object[])new Object[0]);
            String creditFlag = ResManager.loadKDString((String)"\u8d37", (String)"BalanceDataResultService_1", (String)"taxc-tdm-business", (Object[])new Object[0]);
            if (StringUtil.isNotEmpty((CharSequence)dc_flag) && debitFlag.equalsIgnoreCase(dc_flag)) {
                balanceVo.setDebitbegin_dest(openinglocalcurrency);
                balanceVo.setCreditbegin_dest(BigDecimal.ZERO);
            } else if (StringUtil.isNotEmpty((CharSequence)dc_flag) && creditFlag.equalsIgnoreCase(dc_flag)) {
                balanceVo.setDebitbegin_dest(BigDecimal.ZERO);
                balanceVo.setCreditbegin_dest(openinglocalcurrency);
            } else if (openinglocalcurrency.compareTo(BigDecimal.ZERO) > 0) {
                balanceVo.setDebitbegin_dest(openinglocalcurrency);
                balanceVo.setCreditbegin_dest(BigDecimal.ZERO);
            } else {
                balanceVo.setDebitbegin_dest(BigDecimal.ZERO);
                balanceVo.setCreditbegin_dest(openinglocalcurrency.abs());
            }
        } else {
            balanceVo.setDebitbegin_dest(BigDecimal.ZERO);
            balanceVo.setCreditbegin_dest(BigDecimal.ZERO);
        }
        balanceVo.setDifftype(row.getString("difftype"));
        balanceVo.setState(StringUtil.isEmpty((CharSequence)row.getString("difftype").trim()) ? DataCompareStateEnum.NORMAL.getValue() : DataCompareStateEnum.ERROR.getValue());
        this.updateTotal(balanceTaskParams, balanceVo);
        return balanceVo.toObjects();
    }

    private void updateTotal(FIDataCompareTaskParams taskParams, BalanceVO balanceVo) {
        BalanceDataCompareTaskParams balanceTaskParams = (BalanceDataCompareTaskParams)taskParams;
        String difftype = balanceVo.getDifftype();
        if (!difftype.equals(DataCompareDiffTypeEnum.SOURCE_NOTEXIST.getValue())) {
            balanceTaskParams.setSource_count(balanceTaskParams.getSource_count() + 1);
        }
        if (difftype.equals(DataCompareDiffTypeEnum.TAR_NOTEXIST.getValue())) {
            balanceTaskParams.setTar_noexistcount(balanceTaskParams.getTar_noexistcount() + 1);
        }
        if (difftype.equals(DataCompareDiffTypeEnum.SOURCE_NOTEXIST.getValue()) || difftype.equals(DataCompareDiffTypeEnum.TAR_NOTUPDATE.getValue())) {
            balanceTaskParams.setTar_diffcount(balanceTaskParams.getTar_diffcount() + 1);
        }
        if (!difftype.equals(DataCompareDiffTypeEnum.TAR_NOTEXIST.getValue())) {
            balanceTaskParams.setTar_count(balanceTaskParams.getTar_count() + 1);
        }
        if (StringUtil.isEmpty((CharSequence)difftype.trim())) {
            balanceTaskParams.setSuccess_count(balanceTaskParams.getSuccess_count() + 1);
        }
        DynamicObject rootAccount = balanceTaskParams.getAccountRootByNumber(balanceVo.getAccountNumber());
        BalanceSumVO sumDto = balanceTaskParams.getBalanceSumMap().get(rootAccount.getString("number"));
        sumDto.setDebitbegin_src(sumDto.getDebitbegin_src().add(this.isNullToZero(balanceVo.getDebitbegin_src())));
        sumDto.setCreditbegin_src(sumDto.getCreditbegin_src().add(this.isNullToZero(balanceVo.getCreditbegin_src())));
        sumDto.setDebitbegin_dest(sumDto.getDebitbegin_dest().add(this.isNullToZero(balanceVo.getDebitbegin_dest())));
        sumDto.setCreditbegin_dest(sumDto.getCreditbegin_dest().add(this.isNullToZero(balanceVo.getCreditbegin_dest())));
        if (!StringUtil.isEmpty((CharSequence)difftype.trim())) {
            sumDto.setState(DataCompareStateEnum.ERROR.getValue());
        }
        sumDto.setHasDetail(true);
    }

    @Override
    protected void deleteOldData(FIDataCompareTaskParams taskParams) {
        BalanceDataCompareTaskParams balanceTaskParams = (BalanceDataCompareTaskParams)taskParams;
        DataCompareDataBusiness.deleleOldData(balanceTaskParams.getResultId(), balanceTaskParams.getSchemeId(), balanceTaskParams.getOrgId(), balanceTaskParams.getBookTypeName(), balanceTaskParams.getPeriodNumber());
    }

    @Override
    protected void initTotal(FIDataCompareTaskParams taskParams) {
        BalanceDataCompareTaskParams balanceTaskParams = (BalanceDataCompareTaskParams)taskParams;
        List<String> rootAccountNumbers = balanceTaskParams.getAllRootAccountNumbers();
        int size = rootAccountNumbers.size();
        long[] ids = DB.genLongIds((String)"t_tdm_dc_balancesum", (int)size);
        ArrayList<BalanceSumVO> sumVoList = new ArrayList<BalanceSumVO>(size);
        for (int i = 0; i < size; ++i) {
            String rootAccountNumber = rootAccountNumbers.get(i);
            BalanceSumVO sumVo = new BalanceSumVO();
            sumVo.setId(ids[i]);
            sumVo.setResultId(balanceTaskParams.getResultId());
            sumVo.setOrgId(balanceTaskParams.getOrgId());
            sumVo.setBookType(balanceTaskParams.getBookTypeName());
            sumVo.setPeriod(balanceTaskParams.getPeriodNumber());
            sumVo.setAccountNumber(rootAccountNumber);
            sumVo.setAccountName(balanceTaskParams.getAccountByNumber(rootAccountNumber).getString("name"));
            sumVo.setState(DataCompareStateEnum.NORMAL.getValue());
            sumVo.setHasDetail(false);
            sumVoList.add(sumVo);
        }
        balanceTaskParams.setBalanceSumMap(sumVoList.stream().collect(Collectors.toMap(BalanceSumVO::getAccountNumber, v -> v, (m, n) -> m)));
    }

    @Override
    protected void saveTotal(FIDataCompareTaskParams taskParams) {
        BalanceDataCompareTaskParams balanceTaskParams = (BalanceDataCompareTaskParams)taskParams;
        List sumDtos = balanceTaskParams.getBalanceSumMap().values().stream().filter(BalanceSumVO::isHasDetail).collect(Collectors.toList());
        List sumDtoList = Lists.partition(sumDtos, (int)this.getBatchSize());
        for (List list : sumDtoList) {
            this.saveTotalData(list);
        }
    }

    private void saveTotalData(List<BalanceSumVO> list) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(list.size());
        for (BalanceSumVO dto : list) {
            paramList.add(dto.toObjects());
        }
        if (CollectionUtils.isNotEmpty(paramList)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)INSERT_TOTAL_SQL, paramList);
        }
    }

    @Override
    protected void saveDetail(List<Object[]> paramList, FIDataCompareTaskParams taskParams) {
        long[] ids = DB.genLongIds((String)"t_tdm_dc_balance", (int)paramList.size());
        Object[] objects = null;
        int size = paramList.size();
        for (int i = 0; i < size; ++i) {
            objects = paramList.get(i);
            objects[0] = ids[i];
        }
        if (CollectionUtils.isNotEmpty(paramList)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)INSERT_DETAIL_SQL, paramList);
        }
    }
}

