/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.service.impl;

import java.util.Map;
import kd.taxc.bdtaxr.business.comparisonmodel.service.impl.DataCompareService;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareParams;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareResult;
import kd.taxc.tdm.business.datacompare.DataCompareBizBusiness;
import kd.taxc.tdm.business.datacompare.enums.ResultStateEnum;
import kd.taxc.tdm.business.datacompare.model.FIDataCompareResult;
import kd.taxc.tdm.common.util.ObjectUtils;

public class FIDataCompareService
extends DataCompareService {
    protected void init(DataCompareParams dataCompareParams) {
        this.result = new FIDataCompareResult();
        FIDataCompareResult fiResult = (FIDataCompareResult)this.result;
        Map params = dataCompareParams.getParams();
        Long schemeid = ObjectUtils.toLong(params.get("schemeid"));
        Long resultid = ObjectUtils.toLong(params.get("resultid"));
        fiResult.setResultId(resultid);
        fiResult.setSchemeId(schemeid);
    }

    public void beforeCompare(DataCompareParams dataCompareParams) {
        super.beforeCompare(dataCompareParams);
        FIDataCompareResult fiResult = (FIDataCompareResult)this.result;
        DataCompareBizBusiness.updateResultState(fiResult.getResultId(), ResultStateEnum.RUN, null);
    }

    protected void doFailure(DataCompareParams dataCompareParams, DataCompareResult result, String msg) {
        super.doFailure(dataCompareParams, result, msg);
        Map params = dataCompareParams.getParams();
        Long resultid = ObjectUtils.toLong(params.get("resultid"));
        DataCompareBizBusiness.updateResultState(resultid, ResultStateEnum.FAIL, msg);
    }

    protected void doSuccess(DataCompareParams params, DataCompareResult result) {
        super.doSuccess(params, result);
        DataCompareBizBusiness.updateResultFinish((FIDataCompareResult)result);
    }
}

