/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataFetchService;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.DataCompareBizBusiness;
import kd.taxc.tdm.business.datacompare.DataCompareDataBusiness;
import kd.taxc.tdm.business.datacompare.model.FiAccountDTO;
import kd.taxc.tdm.business.datacompare.model.TaxAccountDTO;
import kd.taxc.tdm.business.datacompare.model.VoucherDataCompareTaskParams;
import org.apache.commons.collections4.CollectionUtils;

public class VoucherDataAlgoFilterFetchService
implements IDataFetchService {
    private static String SRC_SELECT_FIELDS = "entries.id id_src,billno vouchercode_src,concat(entries.seq,'') voucherrow_src,entries.account.id accountid_src,entries.account.number accountnumber_src,entries.debitlocal debitbegin_src,entries.creditlocal creditbegin_src";
    private static String DEST_SELECT_FIELDS = "id id_dest,vouchercode vouchercode_dest,voucherrow voucherrow_dest,billno accountnumber_dest,debitlocalcurrency debitbegin_dest,creditlocalcurrency creditbegin_dest,accountbookstype,sourcesys";

    public void initData(DataCompareTaskParams taskParams) {
        VoucherDataCompareTaskParams voucherTaskParams = (VoucherDataCompareTaskParams)taskParams;
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)voucherTaskParams.getPeriodId(), (String)"bd_period");
        FiAccountDTO fiAccountDto = DataCompareBizBusiness.getFiAccountData(voucherTaskParams.getOrgId(), voucherTaskParams.getAccountTableId(), period.getDate("enddate"), voucherTaskParams.getRootAccountNumbers());
        TaxAccountDTO taxAccountDto = DataCompareBizBusiness.getTaxAccountData(voucherTaskParams.getOrgId(), voucherTaskParams.getRootAccountNumbers());
        HashSet<String> set = new HashSet<String>(50);
        set.addAll(fiAccountDto.getRootAccountNumbers());
        set.addAll(taxAccountDto.getRootAccountNumbers());
        voucherTaskParams.setAllRootAccountNumbers(new ArrayList<String>(set));
        voucherTaskParams.setFiAccountDto(fiAccountDto);
        voucherTaskParams.setTaxAccountDto(taxAccountDto);
        voucherTaskParams.setPeriod(period);
    }

    public Object getSrcData(DataCompareTaskParams taskParams) {
        VoucherDataCompareTaskParams voucherTaskParams = (VoucherDataCompareTaskParams)taskParams;
        Date enddate = voucherTaskParams.getPeriod().getDate("enddate");
        DynamicObjectCollection periodColl = DataCompareDataBusiness.getPeriodAdjustByDate(enddate);
        List periodIds = periodColl.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("org.id", "=", (Object)voucherTaskParams.getOrgId());
        QFilter accountBookTypeFilter = new QFilter("booktype.id", "=", (Object)voucherTaskParams.getBookTypeId());
        QFilter periodFilter = null;
        if (CollectionUtils.isNotEmpty(periodIds)) {
            periodIds.add(voucherTaskParams.getPeriodId());
            periodFilter = new QFilter("period.id", "in", periodIds);
        } else {
            periodFilter = new QFilter("period.id", "=", (Object)voucherTaskParams.getPeriodId());
        }
        QFilter[] filters = new QFilter[]{orgFilter, periodFilter, accountBookTypeFilter};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_voucher", (String)SRC_SELECT_FIELDS, (QFilter[])filters, null);
        if (CollectionUtils.isNotEmpty(voucherTaskParams.getRootAccountNumbers())) {
            if (CollectionUtils.isEmpty(voucherTaskParams.getFiAccountDto().getAccountIds())) {
                QFilter accountFilter = new QFilter("1", "!=", (Object)1);
                dataSet = dataSet.filter(accountFilter.toString());
            } else {
                HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
                params.put("var", voucherTaskParams.getFiAccountDto().getAccountIds());
                dataSet = dataSet.filter("accountid_src in var", params);
            }
        }
        return dataSet;
    }

    public Object getDestData(DataCompareTaskParams taskParams) {
        VoucherDataCompareTaskParams voucherTaskParams = (VoucherDataCompareTaskParams)taskParams;
        DynamicObject accountbooksType = BusinessDataServiceHelper.loadSingleFromCache((Object)voucherTaskParams.getBookTypeId(), (String)"bd_accountbookstype");
        String accountBooksTypeName = accountbooksType.getString("name");
        DynamicObject period = voucherTaskParams.getPeriod();
        int periodYear = period.getInt("periodyear");
        int periodNumber = period.getInt("periodnumber");
        String accountYear = String.valueOf(periodYear);
        String accountperiod = periodNumber < 10 ? "0" + periodNumber : String.valueOf(periodNumber);
        QFilter orgFilter = new QFilter("org.id", "=", (Object)voucherTaskParams.getOrgId());
        QFilter accountYearFilter = new QFilter("accountyear", "=", (Object)accountYear);
        QFilter accountPeriodFilter = new QFilter("accountperiod", "=", (Object)accountperiod);
        QFilter[] filters = new QFilter[]{orgFilter, accountYearFilter, accountPeriodFilter};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tdm_recording_voucher_new", (String)DEST_SELECT_FIELDS, (QFilter[])filters, null);
        QFilter accountBookTypeFilter = new QFilter("accountbookstype", "=", (Object)accountBooksTypeName);
        QFilter defaultFilter = new QFilter("sourcesys", "=", (Object)ResManager.loadKDString((String)"\u8d22\u52a1\u4e91", (String)"VoucherDataAlgoFilterFetchService_0", (String)"taxc-tdm-business", (Object[])new Object[0]));
        dataSet = dataSet.filter(accountBookTypeFilter.and(defaultFilter).toString());
        if (CollectionUtils.isNotEmpty(voucherTaskParams.getRootAccountNumbers())) {
            if (CollectionUtils.isEmpty(voucherTaskParams.getTaxAccountDto().getAccountNumbers())) {
                QFilter accountFilter = new QFilter("1", "!=", (Object)1);
                dataSet = dataSet.filter(accountFilter.toString());
            } else {
                HashMap<String, List<String>> params = new HashMap<String, List<String>>();
                params.put("var", voucherTaskParams.getTaxAccountDto().getAccountNumbers());
                dataSet = dataSet.filter("accountnumber_dest in var", params);
            }
        }
        return dataSet;
    }
}

