/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataCalculateService;
import kd.taxc.bdtaxr.common.enums.comparisonmodel.DataCompareEnum;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareConfig;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareParams;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareResult;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.DataCompareBizBusiness;
import kd.taxc.tdm.business.datacompare.DataCompareDataBusiness;
import kd.taxc.tdm.business.datacompare.model.VoucherDataCompareTaskParams;
import kd.taxc.tdm.common.util.ObjectUtils;

public class VoucherDataCalculateService
implements IDataCalculateService {
    public List<DataCompareTaskParams> buildTaskParamsList(DataCompareParams dataCompareParams, DataCompareResult result) {
        Map params = dataCompareParams.getParams();
        if (dataCompareParams.isRetry()) {
            Long resultId = ObjectUtils.toLong(params.get("resultid"));
            DynamicObjectCollection resultLogList = DataCompareDataBusiness.queryRetryResultLogList(resultId);
            DataCompareConfig config = DataCompareEnum.getEnum((Long)dataCompareParams.getSchemeId()).getConfig();
            List<DataCompareTaskParams> taskParamsList = resultLogList.stream().map(v -> {
                Map map = (Map)SerializationUtils.fromJsonString((String)v.getString("datarange_tag"), Map.class);
                VoucherDataCompareTaskParams voucherTaskParams = new VoucherDataCompareTaskParams(config);
                voucherTaskParams.setLogId(ObjectUtils.toLong(map.get("logId")));
                voucherTaskParams.setResultId(resultId);
                voucherTaskParams.setSchemeId(dataCompareParams.getSchemeId());
                voucherTaskParams.setOrgId(ObjectUtils.toLong(map.get("orgId")));
                voucherTaskParams.setBookTypeId(ObjectUtils.toLong(map.get("bookTypeId")));
                voucherTaskParams.setPeriodId(ObjectUtils.toLong(map.get("periodId")));
                voucherTaskParams.setOrgName((String)map.get("orgName"));
                voucherTaskParams.setBookTypeName((String)map.get("bookTypeName"));
                voucherTaskParams.setPeriodNumber((Integer)map.get("periodNumber"));
                voucherTaskParams.setRootAccountNumbers((List)map.get("rootAccountNumbers"));
                voucherTaskParams.setAccountTableId(ObjectUtils.toLong(map.get("accountTableId")));
                voucherTaskParams.setRetry(true);
                return voucherTaskParams;
            }).collect(Collectors.toList());
            result.setExecutorCount(resultLogList.size());
            return taskParamsList;
        }
        List orgIds = ObjectUtils.toLongList((List)((List)params.get("orgIds")));
        List bookTypeIds = ObjectUtils.toLongList((List)((List)params.get("bookTypeIds")));
        List rootAccountNumbers = (List)params.get("rootAccountNumbers");
        List periodIds = ObjectUtils.toLongList((List)((List)params.get("periodIds")));
        String startPeriod = (String)params.get("startPeriod");
        String endPeriod = (String)params.get("endPeriod");
        Long resultId = ObjectUtils.toLong(params.get("resultid"));
        Long schemeId = ObjectUtils.toLong(params.get("schemeid"));
        DynamicObjectCollection orgColl = DataCompareDataBusiness.queryOrgList(orgIds);
        Map<Long, DynamicObject> orgMap = orgColl.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<Long, DynamicObject> bookTypeMap = DataCompareDataBusiness.getAccountbookstypes(bookTypeIds);
        Map<Long, List<Long>> orgSupportBookTypeIdsMap = DataCompareDataBusiness.getSupportBookTypeIdsByOrgIdsMap(orgIds);
        Map<String, Long> accountTableMap = DataCompareDataBusiness.getAccountTableIds(orgIds, bookTypeIds);
        DynamicObjectCollection periods = DataCompareDataBusiness.getPeriods(startPeriod, endPeriod);
        Map<Long, DynamicObject> periodMap = periods.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        ArrayList<DataCompareTaskParams> taskParamsList = new ArrayList<DataCompareTaskParams>(10);
        List cartesianProductList = Lists.cartesianProduct((List[])new List[]{orgIds, bookTypeIds, periodIds});
        DataCompareConfig config = DataCompareEnum.getEnum((Long)dataCompareParams.getSchemeId()).getConfig();
        for (List list : cartesianProductList) {
            Long orgId = (Long)list.get(0);
            Long bookTypeId = (Long)list.get(1);
            Long periodId = (Long)list.get(2);
            List<Long> supportBookTypes = orgSupportBookTypeIdsMap.get(orgId);
            if (supportBookTypes == null || !supportBookTypes.contains(bookTypeId)) continue;
            VoucherDataCompareTaskParams voucherTaskParams = new VoucherDataCompareTaskParams(config);
            voucherTaskParams.setResultId(resultId);
            voucherTaskParams.setSchemeId(schemeId);
            voucherTaskParams.setOrgId(orgId);
            voucherTaskParams.setBookTypeId(bookTypeId);
            voucherTaskParams.setPeriodId(periodId);
            voucherTaskParams.setOrgName(orgMap.get(orgId).getString("name"));
            voucherTaskParams.setBookTypeName(bookTypeMap.get(bookTypeId).getString("name"));
            voucherTaskParams.setPeriodNumber(periodMap.get(periodId).getInt("number"));
            voucherTaskParams.setRootAccountNumbers(rootAccountNumbers);
            voucherTaskParams.setAccountTableId(accountTableMap.get(orgId + "_" + bookTypeId));
            taskParamsList.add(voucherTaskParams);
        }
        result.setExecutorCount(taskParamsList.size());
        DataCompareBizBusiness.saveResultLog(taskParamsList);
        return taskParamsList;
    }

    public int getBatchSize() {
        return 2;
    }

    public Object calculate(Object srcData, Object destData, DataCompareTaskParams taskParams) {
        DataSet srcDataSet = (DataSet)srcData;
        DataSet destDataSet = (DataSet)destData;
        return srcDataSet.fullJoin(destDataSet).on("id_src", "id_dest").select(this.getSelectFields()).finish().addField(this.getCompareExpression(), "difftype");
    }

    protected String getCompareExpression() {
        StringBuilder expression = new StringBuilder();
        expression.append("case when id_dest is null then 'B' ");
        expression.append("     when id_src is null then 'C' ");
        expression.append("     when debitbegin_src != debitbegin_dest or creditbegin_src != creditbegin_dest then 'A' ");
        expression.append("     else ' ' end ");
        return expression.toString();
    }

    protected String[] getSelectFields() {
        return new String[]{"id_src", "id_dest", " case when id_dest is null then accountnumber_src else accountnumber_dest end accountnumber", " case when id_dest is null then vouchercode_src else vouchercode_dest end vouchercode", " case when id_dest is null then voucherrow_src else voucherrow_dest end voucherrow", "debitbegin_src", "creditbegin_src", "debitbegin_dest", "creditbegin_dest"};
    }
}

