/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.taxc.tdm.business.datacompare.DataCompareDataBusiness;
import kd.taxc.tdm.business.datacompare.enums.DataCompareDiffTypeEnum;
import kd.taxc.tdm.business.datacompare.enums.DataCompareStateEnum;
import kd.taxc.tdm.business.datacompare.model.FIDataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.model.VoucherDataCompareTaskParams;
import kd.taxc.tdm.business.datacompare.model.VoucherSumVO;
import kd.taxc.tdm.business.datacompare.model.VoucherVO;
import kd.taxc.tdm.business.datacompare.service.impl.FIDataResultService;
import kd.taxc.tdm.common.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;

public class VoucherDataResultService
extends FIDataResultService {
    private static final String INSERT_DETAIL_SQL = "insert into t_tdm_dc_voucher(fid,fresultid,ftotalid,forgid,faccountnumber,faccountname,fperiodnumber,faccountbookstype,fvouchercode,fvoucherrow,fdebitbegin_src,fcreditbegin_src,fdebitbegin_dest,fcreditbegin_dest,fstate,fdifftype) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_TOTAL_SQL = "insert into t_tdm_dc_vouchersum(fid,fresultid,forgid,faccountnumber,faccountname,fperiodnumber,faccountbookstype,fdebitbegin_src,fcreditbegin_src,fdebitbegin_dest,fcreditbegin_dest,fstate,fsource_count,ftar_count) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    @Override
    public Object[] rowToObj(Row row, FIDataCompareTaskParams taskParams) {
        VoucherDataCompareTaskParams voucherTaskParams = (VoucherDataCompareTaskParams)taskParams;
        DynamicObject account = voucherTaskParams.getAccountByNumber(row.getString("accountnumber"));
        DynamicObject rootAccount = voucherTaskParams.getAccountRootByNumber(row.getString("accountnumber"));
        VoucherSumVO sumDto = voucherTaskParams.getVoucherSumMap().get(rootAccount.getString("number"));
        VoucherVO voucherVo = new VoucherVO();
        voucherVo.setResultId(voucherTaskParams.getResultId());
        voucherVo.setTotalId(sumDto.getId());
        voucherVo.setOrgId(voucherTaskParams.getOrgId());
        voucherVo.setAccountNumber(row.getString("accountnumber"));
        voucherVo.setAccountName(account.getString("name"));
        voucherVo.setPeriod(voucherTaskParams.getPeriodNumber());
        voucherVo.setBookType(voucherTaskParams.getBookTypeName());
        voucherVo.setVouchercode(row.getString("vouchercode"));
        voucherVo.setVoucherrow(row.getString("voucherrow"));
        voucherVo.setDebitbegin_src(this.isNullToZero(row.getBigDecimal("debitbegin_src")));
        voucherVo.setCreditbegin_src(this.isNullToZero(row.getBigDecimal("creditbegin_src")));
        voucherVo.setDebitbegin_dest(this.isNullToZero(row.getBigDecimal("debitbegin_dest")));
        voucherVo.setCreditbegin_dest(this.isNullToZero(row.getBigDecimal("creditbegin_dest")));
        voucherVo.setDifftype(row.getString("difftype"));
        voucherVo.setState(StringUtil.isEmpty((CharSequence)row.getString("difftype").trim()) ? DataCompareStateEnum.NORMAL.getValue() : DataCompareStateEnum.ERROR.getValue());
        this.updateTotal(voucherTaskParams, row);
        return voucherVo.toObjects();
    }

    private void updateTotal(FIDataCompareTaskParams taskParams, Row row) {
        VoucherDataCompareTaskParams voucherTaskParams = (VoucherDataCompareTaskParams)taskParams;
        DynamicObject rootAccount = voucherTaskParams.getAccountRootByNumber(row.getString("accountnumber"));
        VoucherSumVO sumDto = voucherTaskParams.getVoucherSumMap().get(rootAccount.getString("number"));
        sumDto.setDebitbegin_src(sumDto.getDebitbegin_src().add(this.isNullToZero(row.getBigDecimal("debitbegin_src"))));
        sumDto.setCreditbegin_src(sumDto.getCreditbegin_src().add(this.isNullToZero(row.getBigDecimal("creditbegin_src"))));
        sumDto.setDebitbegin_dest(sumDto.getDebitbegin_dest().add(this.isNullToZero(row.getBigDecimal("debitbegin_dest"))));
        sumDto.setCreditbegin_dest(sumDto.getCreditbegin_dest().add(this.isNullToZero(row.getBigDecimal("creditbegin_dest"))));
        String difftype = row.getString("difftype");
        if (!difftype.equals(DataCompareDiffTypeEnum.SOURCE_NOTEXIST.getValue())) {
            voucherTaskParams.setSource_count(voucherTaskParams.getSource_count() + 1);
            sumDto.setSource_count(sumDto.getSource_count() + 1);
        }
        if (difftype.equals(DataCompareDiffTypeEnum.TAR_NOTEXIST.getValue())) {
            voucherTaskParams.setTar_noexistcount(voucherTaskParams.getTar_noexistcount() + 1);
        }
        if (difftype.equals(DataCompareDiffTypeEnum.SOURCE_NOTEXIST.getValue()) || difftype.equals(DataCompareDiffTypeEnum.TAR_NOTUPDATE.getValue())) {
            voucherTaskParams.setTar_diffcount(voucherTaskParams.getTar_diffcount() + 1);
        }
        if (!difftype.equals(DataCompareDiffTypeEnum.TAR_NOTEXIST.getValue())) {
            voucherTaskParams.setTar_count(voucherTaskParams.getTar_count() + 1);
            sumDto.setTar_count(sumDto.getTar_count() + 1);
        }
        if (StringUtil.isEmpty((CharSequence)difftype.trim())) {
            voucherTaskParams.setSuccess_count(voucherTaskParams.getSuccess_count() + 1);
        }
        if (!StringUtil.isEmpty((CharSequence)difftype.trim())) {
            sumDto.setState(DataCompareStateEnum.ERROR.getValue());
        }
        sumDto.setHasDetail(true);
    }

    @Override
    protected void deleteOldData(FIDataCompareTaskParams taskParams) {
        VoucherDataCompareTaskParams voucherTaskParams = (VoucherDataCompareTaskParams)taskParams;
        DataCompareDataBusiness.deleleOldData(voucherTaskParams.getResultId(), voucherTaskParams.getSchemeId(), voucherTaskParams.getOrgId(), voucherTaskParams.getBookTypeName(), voucherTaskParams.getPeriodNumber());
    }

    @Override
    protected void initTotal(FIDataCompareTaskParams taskParams) {
        VoucherDataCompareTaskParams voucherTaskParams = (VoucherDataCompareTaskParams)taskParams;
        List<String> rootAccountNumbers = voucherTaskParams.getAllRootAccountNumbers();
        int size = rootAccountNumbers.size();
        long[] ids = DB.genLongIds((String)"t_tdm_dc_vouchersum", (int)size);
        ArrayList<VoucherSumVO> sumVoList = new ArrayList<VoucherSumVO>(size);
        for (int i = 0; i < size; ++i) {
            String rootAccountNumber = rootAccountNumbers.get(i);
            VoucherSumVO sumVo = new VoucherSumVO();
            sumVo.setId(ids[i]);
            sumVo.setResultId(voucherTaskParams.getResultId());
            sumVo.setOrgId(voucherTaskParams.getOrgId());
            sumVo.setBookType(voucherTaskParams.getBookTypeName());
            sumVo.setPeriod(voucherTaskParams.getPeriodNumber());
            sumVo.setAccountNumber(rootAccountNumber);
            sumVo.setAccountName(voucherTaskParams.getAccountByNumber(rootAccountNumber).getString("name"));
            sumVo.setState(DataCompareStateEnum.NORMAL.getValue());
            sumVo.setHasDetail(false);
            sumVoList.add(sumVo);
        }
        voucherTaskParams.setVoucherSumMap(sumVoList.stream().collect(Collectors.toMap(VoucherSumVO::getAccountNumber, v -> v, (m, n) -> m)));
    }

    @Override
    protected void saveTotal(FIDataCompareTaskParams taskParams) {
        VoucherDataCompareTaskParams voucherTaskParams = (VoucherDataCompareTaskParams)taskParams;
        List sumDtos = voucherTaskParams.getVoucherSumMap().values().stream().filter(VoucherSumVO::isHasDetail).collect(Collectors.toList());
        List sumDtoList = Lists.partition(sumDtos, (int)this.getBatchSize());
        for (List list : sumDtoList) {
            this.saveTotalData(list);
        }
    }

    private void saveTotalData(List<VoucherSumVO> list) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(list.size());
        for (VoucherSumVO dto : list) {
            paramList.add(dto.toObjects());
        }
        if (CollectionUtils.isNotEmpty(paramList)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)INSERT_TOTAL_SQL, paramList);
        }
    }

    @Override
    protected void saveDetail(List<Object[]> paramList, FIDataCompareTaskParams taskParams) {
        long[] ids = DB.genLongIds((String)"t_tdm_dc_voucher", (int)paramList.size());
        Object[] objects = null;
        int size = paramList.size();
        for (int i = 0; i < size; ++i) {
            objects = paramList.get(i);
            objects[0] = ids[i];
        }
        if (CollectionUtils.isNotEmpty(paramList)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)INSERT_DETAIL_SQL, paramList);
        }
    }
}

