/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.taxc.tdm.business.datacompare.DataCompareDataBusiness;
import kd.taxc.tdm.business.datacompare.enums.DataCompareSchemeConfig;
import kd.taxc.tdm.business.datacompare.enums.DataCompareSchemeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class DataCompareDeleteTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(DataCompareDeleteTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011DataCompareDeleteTask.execute\u4efb\u52a1\u5f00\u59cb\u3002");
        List deletelist = (List)map.get("deletelist");
        if (CollectionUtils.isEmpty((Collection)deletelist)) {
            return;
        }
        HashMap<Long, List> entityList = new HashMap<Long, List>(4);
        ArrayList<Long> resultIds = new ArrayList<Long>(10);
        for (String string : deletelist) {
            String[] values = string.split("_");
            if (values.length < 2) continue;
            Long resultId = Long.valueOf(values[0]);
            Long schemeId = Long.valueOf(values[1]);
            List idList = entityList.computeIfAbsent(schemeId, v -> new ArrayList(10));
            idList.add(resultId);
            resultIds.add(resultId);
        }
        for (Map.Entry entry : entityList.entrySet()) {
            DataCompareSchemeConfig config = DataCompareSchemeEnum.getEnum((Long)entry.getKey()).getConfig();
            DataCompareDataBusiness.deleteTotalData((List)entry.getValue(), config.getTotalFormId());
            DataCompareDataBusiness.deleteDetailData((List)entry.getValue(), config.getDetailFormId());
        }
        DataCompareDataBusiness.deleteResultLogData(resultIds);
        logger.info("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011DataCompareDeleteTask.execute\u4efb\u52a1\u7ed3\u675f\u3002");
    }
}

