/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.datacompare.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.taxc.tdm.business.datacompare.DataCompareBizBusiness;
import kd.taxc.tdm.business.datacompare.DataCompareDataBusiness;
import kd.taxc.tdm.business.datacompare.enums.DataCompareSchemeEnum;

public class DataCompareScheduleTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(DataCompareScheduleTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String endPeriod;
        logger.info("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011DataCompareScheduleTask.execute:\u4efb\u52a1\u5f00\u59cb\u3002");
        DynamicObjectCollection orgs = DataCompareDataBusiness.queryVoildOrgList();
        List<Long> orgIds = orgs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        if (orgIds.size() == 0) {
            logger.error("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011DataCompareScheduleTask.execute:\u6838\u7b97\u7ec4\u7ec7\u6570\u636e\u67e5\u8be2\u5931\u8d25\u3002");
            return;
        }
        List<Long> bookTypeIds = DataCompareDataBusiness.getBookTypeIdsByOrgIds(orgIds);
        if (bookTypeIds.size() == 0) {
            logger.error("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011DataCompareScheduleTask.execute:\u8d26\u7c3f\u7c7b\u578b\u6570\u636e\u67e5\u8be2\u5931\u8d25\u3002");
            return;
        }
        String startPeriod = (String)map.get("startPeriod");
        DynamicObjectCollection periods = DataCompareDataBusiness.getPeriods(startPeriod, endPeriod = (String)map.get("endPeriod"));
        List periodIds = periods.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        if (periodIds.size() == 0) {
            logger.error("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011DataCompareScheduleTask.execute:\u4f1a\u8ba1\u671f\u95f4\u5f55\u5165\u4e0d\u5408\u6cd5\uff0c\u4f1a\u8ba1\u671f\u95f4\u8d77\uff1a{}\uff0c\u4f1a\u8ba1\u671f\u95f4\u81f3\uff1a{}", (Object)startPeriod, (Object)endPeriod);
            return;
        }
        for (DataCompareSchemeEnum scheme : DataCompareSchemeEnum.values()) {
            HashMap<String, Object> compareParams = new HashMap<String, Object>(10);
            compareParams.put("schemeid", scheme.getId());
            compareParams.put("orgIds", orgIds);
            compareParams.put("startPeriod", map.get("startPeriod"));
            compareParams.put("endPeriod", map.get("endPeriod"));
            compareParams.put("periodIds", periodIds);
            compareParams.put("bookTypeIds", bookTypeIds);
            compareParams.put("rootAccountNumbers", null);
            DataCompareBizBusiness.submitDataCompareJob(compareParams);
        }
        logger.info("\u3010\u6d89\u7a0e\u6570\u636e\u6bd4\u5bf9\u3011DataCompareScheduleTask.execute:\u4efb\u52a1\u7ed3\u675f\u3002");
    }
}

