/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.declaration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.taxc.tdm.business.declaration.ExportDeclarationGatherService;
import kd.taxc.tdm.business.declaration.ExportDeclarationService;
import kd.taxc.tdm.common.util.ExceptionUtil;
import kd.taxc.tdm.common.util.velocity.VmTemplateUtils;

public class ExportDeclarationBusiness {
    public static final Log logger = LogFactory.getLog(ExportDeclarationBusiness.class);

    public static List<Map<String, Object>> saveByIsc(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> saveResult = new ArrayList<Map<String, Object>>(10);
        ArrayList<String> tobeAddBillNo = new ArrayList<String>(10);
        List<String> billNos = list.stream().map(item -> (String)item.get("billno")).collect(Collectors.toList());
        DynamicObject[] dyns = ExportDeclarationService.queryByBillNo(billNos);
        Map<String, DynamicObject> dynMap = Arrays.stream(dyns).collect(Collectors.toMap(item -> (String)item.get("billNo"), item -> item));
        ArrayList<Map<String, Object>> tobeAdd = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> item2 : list) {
            String string = (String)item2.get("billno");
            if (StringUtils.isEmpty((String)string)) {
                saveResult.add(ExportDeclarationBusiness.newIscSaveResult("", false, ResManager.loadKDString((String)"\u51fa\u53e3\u62a5\u5173\u5355\u53f7\u4e3a\u7a7a", (String)"ExportDeclarationBusiness_3", (String)"taxc-tdm-business", (Object[])new Object[0])));
                continue;
            }
            DynamicObject dyn = dynMap.get(string);
            if (dyn == null) {
                tobeAdd.add(item2);
                tobeAddBillNo.add(string);
                continue;
            }
            if (ExportDeclarationBusiness.filterByBillstatus(dyn, "A")) {
                tobeAdd.add(item2);
                tobeAddBillNo.add(string);
                continue;
            }
            saveResult.add(ExportDeclarationBusiness.newIscSaveResult(string, false, ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u4e0d\u5141\u8bb8\u8986\u76d6", (String)"ExportDeclarationBusiness_0", (String)"taxc-tdm-business", (Object[])new Object[0])));
        }
        try {
            List<Map<String, Object>> resultList = ExportDeclarationService.saveByIsc(tobeAdd);
            for (int i = 0; i < resultList.size(); ++i) {
                Map<String, Object> map = resultList.get(i);
                if (i >= tobeAddBillNo.size()) continue;
                if ("FAILED".equals(map.get("type"))) {
                    saveResult.add(ExportDeclarationBusiness.newIscSaveResult((String)tobeAddBillNo.get(i), false, (String)map.get("errorMessage")));
                    continue;
                }
                saveResult.add(ExportDeclarationBusiness.newIscSaveResult((String)tobeAddBillNo.get(i), true, null));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(ExceptionUtil.toString((Exception)e));
            for (Map map : saveResult) {
                map.put("success", false);
                map.put("msg", ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u4fdd\u5b58\u5931\u8d25", (String)"ExportDeclarationBusiness_1", (String)"taxc-tdm-business", (Object[])new Object[0]));
            }
        }
        return saveResult;
    }

    public static String generateByVm(String inputTemplate, String templateName, Map<?, ?> contentMap) {
        return VmTemplateUtils.generateFromTemplate((String)inputTemplate, (String)templateName, contentMap).toString();
    }

    private static boolean filterByBillstatus(DynamicObject dyn, String billStatus) {
        String status = dyn.getString("billstatus");
        return status == null ? false : status.equals(billStatus);
    }

    private static Map<String, Object> newIscSaveResult(String billNo, Boolean success, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("billNo", billNo);
        map.put("success", success);
        map.put("msg", msg);
        return map;
    }

    public static void exportDeclarationGather(Map<String, Object> params) {
        ExportDeclarationGatherService.exportDeclarationGather(params);
    }
}

