/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.declaration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.business.executor.ThreadPoolEnum;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.executor.Task;
import kd.taxc.bdtaxr.common.helper.TaxcThreadPoolHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tdm.business.declaration.task.ExportDeclarationGatherThreadTask;
import kd.taxc.tdm.common.bean.ExportDeclarationGatherParam;
import kd.taxc.tdm.common.enums.DayFlagEnum;
import kd.taxc.tdm.common.enums.GatherStatusEnum;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.ObjectUtils;
import kd.taxc.tdm.common.util.StringUtil;

public class ExportDeclarationGatherService {
    private static Log logger = LogFactory.getLog(ExportDeclarationGatherService.class);

    public static void exportDeclarationGather(Map<String, Object> params) {
        ExportDeclarationGatherService.checkGatherParam(params);
        CopyOnWriteArrayList<ExportDeclarationGatherParam> gatherParams = new CopyOnWriteArrayList<ExportDeclarationGatherParam>();
        ExportDeclarationGatherService.buildGatherParamList(gatherParams, params);
        CopyOnWriteArrayList<String> exceptionList = new CopyOnWriteArrayList<String>();
        TaxcThreadPoolHelper.submit((Task)new ExportDeclarationGatherThreadTask(gatherParams, exceptionList), (ThreadPoolEnum)ThreadPoolEnum.TAXC_TDM, (boolean)true);
        if (exceptionList.size() > 0) {
            throw new KDBizException((String)exceptionList.get(0));
        }
    }

    private static void checkGatherParam(Map<String, Object> params) {
        String status;
        if (ObjectUtils.isEmpty((Object)params.get("orgnumbers"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExportDeclarationGatherService_0", (String)"taxc-tdm-business", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)params.get("dayflag"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExportDeclarationGatherService_1", (String)"taxc-tdm-business", (Object[])new Object[0]));
        }
        String dateFlag = params.get("dayflag").toString();
        if (DayFlagEnum.getInstance((String)dateFlag) == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u6807\u8bc6:%1$s\u8f93\u5165\u4e0d\u6b63\u786e\uff0c\u8303\u56f4%2$s", (String)"ExportDeclarationGatherService_2", (String)"taxc-tdm-business", (Object[])new Object[0]), dateFlag, DayFlagEnum.getValueRange()));
        }
        if (!ObjectUtils.isEmpty((Object)params.get("status")) && GatherStatusEnum.getInstance((String)(status = params.get("status").toString())) == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u72b6\u6001:%1$s\u8f93\u5165\u4e0d\u6b63\u786e\uff0c\u8303\u56f4%2$s", (String)"ExportDeclarationGatherService_3", (String)"taxc-tdm-business", (Object[])new Object[0]), status, GatherStatusEnum.getValueRange()));
        }
    }

    private static void buildGatherParamList(List<ExportDeclarationGatherParam> gatherParams, Map<String, Object> params) {
        List<String> orgNumbers = Arrays.stream(params.get("orgnumbers").toString().split(";")).collect(Collectors.toList());
        List<Long> orgIds = ExportDeclarationGatherService.getOrgIdsByNumbers(orgNumbers);
        if (orgIds == null || orgIds.size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\uff1a%s\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"ExportDeclarationGatherService_4", (String)"taxc-tdm-business", (Object[])new Object[0]), params.get("orgnumbers").toString()));
        }
        Date[] dateRange = ExportDeclarationGatherService.getDateRangeByFlag(params);
        if (dateRange == null || dateRange.length < 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u65e5\u671f\u8303\u56f4\u5931\u8d25\u3002", (String)"ExportDeclarationGatherService_5", (String)"taxc-tdm-business", (Object[])new Object[0]));
        }
        List<String> allStatus = ExportDeclarationGatherService.getAllStatus(params);
        if (allStatus == null || allStatus.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u72b6\u6001\u6807\u8bc6\u5931\u8d25\u3002", (String)"ExportDeclarationGatherService_6", (String)"taxc-tdm-business", (Object[])new Object[0]));
        }
        ExportDeclarationGatherParam gatherParam = null;
        for (Long orgId : orgIds) {
            for (String status : allStatus) {
                gatherParam = new ExportDeclarationGatherParam();
                gatherParam.setOrgId(orgId);
                gatherParam.setStartUpdateDate(dateRange[0]);
                gatherParam.setEndUpdateDate(dateRange[1]);
                gatherParam.setClearanceStatus(status);
                gatherParam.setSync(Boolean.valueOf(true));
                gatherParams.add(gatherParam);
            }
        }
    }

    private static List<Long> getOrgIdsByNumbers(List<String> orgNumbers) {
        TaxResult result = TaxcOrgDataServiceHelper.queryTaxcOrgByNumber(orgNumbers);
        if (result.isSuccess()) {
            return Arrays.stream((Object[])result.getData()).map(v -> v.getLong("id")).collect(Collectors.toList());
        }
        return null;
    }

    private static Date[] getDateRangeByFlag(Map<String, Object> params) {
        String dayflag = (String)params.get("dayflag");
        DayFlagEnum dayFlagEnum = DayFlagEnum.getInstance((String)dayflag);
        if (dayFlagEnum == null) {
            return null;
        }
        Date[] dateRange = new Date[2];
        Calendar calendar = null;
        switch (dayFlagEnum.getFlag()) {
            case "1": {
                dateRange[0] = DateUtils.getFirstPreDayOfDay();
                dateRange[1] = DateUtils.getLastPreDayOfDay();
                break;
            }
            case "2": {
                dateRange[0] = DateUtils.getFirstDayOfWeek();
                dateRange[1] = DateUtils.getLastDayOfWeek();
                break;
            }
            case "3": {
                calendar = Calendar.getInstance();
                dateRange[0] = DateUtils.getFirstDateOfMonth((Date)calendar.getTime());
                dateRange[1] = DateUtils.getLastDateOfMonth((Date)calendar.getTime());
                break;
            }
            case "4": {
                calendar = Calendar.getInstance();
                calendar.add(2, -1);
                dateRange[0] = DateUtils.getFirstDateOfMonth((Date)calendar.getTime());
                dateRange[1] = DateUtils.getLastDateOfMonth((Date)calendar.getTime());
                break;
            }
            case "5": {
                dateRange[0] = DateUtils.getLastMouthOfDay();
                dateRange[1] = DateUtils.getLastDayOfDay();
            }
        }
        return dateRange;
    }

    private static List<String> getAllStatus(Map<String, Object> params) {
        ArrayList<String> allStatus = new ArrayList<String>(10);
        String status = (String)params.get("status");
        if (StringUtil.isEmpty((CharSequence)status)) {
            for (GatherStatusEnum enumObject : GatherStatusEnum.values()) {
                allStatus.add(enumObject.getStatus());
            }
            allStatus.add("");
            return allStatus;
        }
        return Collections.singletonList(status);
    }

    public static void downloadExportDeclaration(ExportDeclarationGatherParam gatherParam) {
        logger.info("downloadExportDeclaration: gatherParam: {}", (Object)gatherParam.toString());
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"ExportDeclarationMService", (String)"downloadExportDeclaration", (Object[])new Object[]{gatherParam.getOrgId(), gatherParam.getStartUpdateDate(), gatherParam.getEndUpdateDate(), gatherParam.getExportDeclarationNo(), gatherParam.getClearanceStatus(), gatherParam.getSync()});
    }
}

