/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.declaration.algorithm;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bd.exchangerate.ExchangeRateDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.param.SystemParamDataServiceHelper;
import kd.taxc.tdm.common.constant.ExportDeclarationConstant;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.StringUtil;

public abstract class AbstractExportDeclarationAlgorithm {
    protected static final String APPNUMBER = "tcetr";
    protected Map<String, Object> cache = new HashMap<String, Object>();
    protected static final String APPPARAMETER_CACHE = "AppParameter";
    protected static final String EXCHANGERATE_CACHE = "ExchangeRate";
    protected Map<String, Object> appParameter = null;
    protected int defaultAmountPrecision = 2;

    protected void initParam() {
        this.appParameter = this.getAppParameterFromCache();
    }

    public void calculate() {
        this.calFreightex();
        this.calPremiumex();
        this.calSundryex();
        this.calEntryTradeex();
        this.calEntryYfAmount();
        this.calEntryBfAmount();
        this.calEntryZfAmount();
        this.calEntryMylaj();
    }

    protected void calFreightex() {
        DynamicObject currency = (DynamicObject)this.getValue("freightcurrency");
        BigDecimal exchangeRate = this.getExchangeRate(currency);
        this.setValue("freightex", exchangeRate);
    }

    protected void calPremiumex() {
        DynamicObject currency = (DynamicObject)this.getValue("premiumcurrency");
        BigDecimal exchangeRate = this.getExchangeRate(currency);
        this.setValue("premiumex", exchangeRate);
    }

    protected void calSundryex() {
        DynamicObject currency = (DynamicObject)this.getValue("sundrycurrency");
        BigDecimal exchangeRate = this.getExchangeRate(currency);
        this.setValue("sundryex", exchangeRate);
    }

    protected void calEntryYfAmount() {
        this.calEntryAmount("freightamount", "yfamount", "freightcurrency");
    }

    protected void calEntryBfAmount() {
        this.calEntryAmount("premiumamount", "bfamount", "premiumcurrency");
    }

    protected void calEntryZfAmount() {
        this.calEntryAmount("sundryamount", "zfamount", "sundrycurrency");
    }

    protected void calEntryAmount(String headkey, String entrykey, String currencykey) {
        BigDecimal headAmount = this.getNullToZero(headkey);
        BigDecimal totalTradeAmount = this.getEntryTotalAmount("tradeamount");
        if (BigDecimal.ZERO.compareTo(headAmount) == 0 || BigDecimal.ZERO.compareTo(totalTradeAmount) == 0) {
            int size = this.getEntrySize();
            for (int i = 0; i < size; ++i) {
                this.setValue(entrykey, BigDecimal.ZERO, i);
            }
            return;
        }
        int amountPrecision = this.getAmountPrecision(currencykey);
        BigDecimal totalEntryAmount = BigDecimal.ZERO;
        BigDecimal entryAmount = null;
        BigDecimal tradeAmount = null;
        int maxIndex = 0;
        BigDecimal maxEntryAmount = BigDecimal.ZERO;
        int size = this.getEntrySize();
        for (int i = 0; i < size; ++i) {
            tradeAmount = this.getNullToZero("tradeamount", i);
            entryAmount = headAmount.multiply(tradeAmount).divide(totalTradeAmount, amountPrecision, 1);
            if (i == 0) {
                maxEntryAmount = entryAmount;
            } else if (entryAmount.compareTo(maxEntryAmount) > 0) {
                maxEntryAmount = entryAmount;
                maxIndex = i;
            }
            totalEntryAmount = totalEntryAmount.add(entryAmount);
            this.setValue(entrykey, entryAmount, i);
        }
        BigDecimal diff = headAmount.subtract(totalEntryAmount);
        if (BigDecimal.ZERO.compareTo(diff) != 0) {
            this.setValue(entrykey, this.getNullToZero(entrykey, maxIndex).add(diff), maxIndex);
        }
    }

    protected boolean calTradeamount(int i) {
        BigDecimal tradePrice;
        BigDecimal tradeQty = this.getNullToZero("tradeqty", i);
        BigDecimal tradeAmount = tradeQty.multiply(tradePrice = this.getNullToZero("tradeprice", i)).setScale(this.getAmountPrecision("tradecurrency", i), RoundingMode.HALF_UP);
        if (tradeAmount.compareTo(BigDecimal.valueOf(9.9999999999999E11)) > 0) {
            this.setValue("tradeamount", 0, i);
            this.setValue("tradeqty", 0, i);
            this.setValue("tradeprice", 0, i);
            return true;
        }
        this.setValue("tradeamount", tradeAmount, i);
        return false;
    }

    protected void calEntryTradeex() {
        int size = this.getEntrySize();
        for (int i = 0; i < size; ++i) {
            this.calTradeex(i);
        }
    }

    protected void calTradeex(int i) {
        DynamicObject currency = (DynamicObject)this.getValue("tradecurrency", i);
        BigDecimal exchangeRate = this.getExchangeRate(currency);
        this.setValue("tradeex", exchangeRate, i);
    }

    protected void calEntryMylaj() {
        int size = this.getEntrySize();
        for (int i = 0; i < size; ++i) {
            this.calMylaj(i);
        }
    }

    protected void calMylaj(int i) {
        String tradeway = (String)this.getValue("tradeway");
        if (StringUtil.isEmpty((CharSequence)tradeway)) {
            this.setValue("mylaj", BigDecimal.ZERO, i);
            return;
        }
        int amountPrecision = this.getMylajAmountPrecision();
        BigDecimal mylaj = BigDecimal.ZERO;
        BigDecimal tradeAmount = this.getNullToZero("tradeamount", i);
        BigDecimal tradeEx = this.getNullToZero("tradeex", i);
        BigDecimal yfAmount = this.getNullToZero("yfamount", i);
        BigDecimal freightex = this.getNullToZero("freightex");
        BigDecimal bfAmount = this.getNullToZero("bfamount", i);
        BigDecimal premiumex = this.getNullToZero("premiumex");
        BigDecimal zfAmount = this.getNullToZero("zfamount", i);
        BigDecimal sundryex = this.getNullToZero("sundryex");
        switch (tradeway) {
            case "fob": {
                mylaj = tradeAmount.multiply(tradeEx).setScale(amountPrecision, RoundingMode.HALF_UP);
                break;
            }
            case "cif": {
                mylaj = tradeAmount.multiply(tradeEx).subtract(yfAmount.multiply(freightex)).subtract(bfAmount.multiply(premiumex)).add(zfAmount.multiply(sundryex)).setScale(amountPrecision, RoundingMode.HALF_UP);
                break;
            }
            case "cf": 
            case "fcr": {
                mylaj = tradeAmount.multiply(tradeEx).subtract(yfAmount.multiply(freightex)).setScale(amountPrecision, RoundingMode.HALF_UP).add(zfAmount.multiply(sundryex).setScale(amountPrecision, RoundingMode.HALF_UP));
                break;
            }
            case "exw": {
                mylaj = tradeAmount.multiply(tradeEx).add(zfAmount.multiply(sundryex)).setScale(amountPrecision, RoundingMode.HALF_UP);
            }
        }
        this.setValue("mylaj", mylaj, i);
    }

    protected int getAmountPrecision(String currencykey) {
        int amountPrecision = this.defaultAmountPrecision;
        DynamicObject currency = (DynamicObject)this.getValue(currencykey);
        if (currency != null) {
            amountPrecision = currency.getInt("amtprecision");
        }
        return amountPrecision;
    }

    protected int getAmountPrecision(String currencykey, int i) {
        int amountPrecision = this.defaultAmountPrecision;
        DynamicObject currency = (DynamicObject)this.getValue(currencykey, i);
        if (currency != null) {
            amountPrecision = currency.getInt("amtprecision");
        }
        return amountPrecision;
    }

    protected int getMylajAmountPrecision() {
        int amountPrecision = this.defaultAmountPrecision;
        DynamicObject currency = (DynamicObject)this.getValue("mylajcurrency");
        if (currency != null) {
            amountPrecision = currency.getInt("amtprecision");
        }
        return amountPrecision;
    }

    protected BigDecimal getExchangeRate(DynamicObject currency) {
        Date exportdate = (Date)this.getValue("exportdate");
        if (exportdate == null || currency == null || this.appParameter == null) {
            return BigDecimal.ZERO;
        }
        if (ExportDeclarationConstant.USD_CURRENCY_ID.longValue() == currency.getLong("id")) {
            return BigDecimal.ONE;
        }
        Object extable = this.appParameter.get("extable");
        String extype = (String)this.appParameter.get("extype");
        String exlogic = (String)this.appParameter.get("exlogic");
        if (extable == null || StringUtil.isBlank((CharSequence)extype) || StringUtil.isBlank((CharSequence)exlogic)) {
            return BigDecimal.ZERO;
        }
        Long exchangeTableID = this.getExchangeTableID(extable);
        Long sourceCurrencyId = currency.getLong("id");
        Date date = this.getExchangeDate(exportdate, exlogic);
        String convertMode = "zjhl".equals(extype) ? "1" : "2";
        BigDecimal exchangeRate = this.getExchangeRateFromCache(exchangeTableID, sourceCurrencyId, ExportDeclarationConstant.USD_CURRENCY_ID, convertMode, date);
        return exchangeRate;
    }

    protected Long getExchangeTableID(Object extable) {
        Long exchangeTableID = null;
        if (extable instanceof HashMap) {
            exchangeTableID = (Long)((HashMap)extable).get("id");
        } else if (extable instanceof DynamicObject) {
            exchangeTableID = (Long)((DynamicObject)extable).get("id");
        } else if (extable instanceof JSONObject) {
            exchangeTableID = ((JSONObject)extable).getLong("id");
        }
        return exchangeTableID;
    }

    protected Map<String, Object> getAppParameterFromCache() {
        TaxResult result;
        Long orgId;
        String key;
        DynamicObject org = (DynamicObject)this.getValue("org");
        Map appParameter = null;
        if (org != null && (appParameter = (Map)this.cache.get(key = String.format("%s.%s.%s", APPPARAMETER_CACHE, APPNUMBER, orgId = Long.valueOf(org.getLong("id"))))) == null && (result = SystemParamDataServiceHelper.getAppParameter((String)APPNUMBER, (Long)orgId)) != null && result.isSuccess()) {
            appParameter = (Map)result.getData();
            this.cache.put(key, appParameter);
        }
        return appParameter;
    }

    protected BigDecimal getExchangeRateFromCache(Long exchangeTableId, Long sourceCurrencyId, Long targetCurrencyId, String convertMode, Date date) {
        TaxResult result;
        String key = String.format("%1$s.%2$s.%3$s.%4$s.%5$s.%6$tY-%6$tm-%6$te", EXCHANGERATE_CACHE, exchangeTableId, sourceCurrencyId, targetCurrencyId, convertMode, date);
        BigDecimal exchangeRate = (BigDecimal)this.cache.get(key);
        if (exchangeRate == null && (result = ExchangeRateDataServiceHelper.getExchangeRate((Long)exchangeTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (String)convertMode, (Date)date)) != null && result.isSuccess()) {
            exchangeRate = (BigDecimal)result.getData();
            this.cache.put(key, exchangeRate);
        }
        return exchangeRate;
    }

    protected Date getExchangeDate(Date exportdate, String exlogic) {
        if ("qcz".equals(exlogic)) {
            return DateUtils.getFirstDateOfMonth((Date)exportdate);
        }
        if ("drz".equals(exlogic)) {
            return exportdate;
        }
        return exportdate;
    }

    protected BigDecimal getNullToZero(String key) {
        BigDecimal value = (BigDecimal)this.getValue(key);
        return value == null ? BigDecimal.ZERO : value;
    }

    protected BigDecimal getNullToZero(String key, int i) {
        BigDecimal value = (BigDecimal)this.getValue(key, i);
        return value == null ? BigDecimal.ZERO : value;
    }

    protected BigDecimal getEntryTotalAmount(String entryKey) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        int size = this.getEntrySize();
        for (int i = 0; i < size; ++i) {
            totalAmount = totalAmount.add(this.getNullToZero(entryKey, i));
        }
        return totalAmount;
    }

    protected abstract void setValue(String var1, Object var2);

    protected abstract Object getValue(String var1);

    protected abstract void setValue(String var1, Object var2, int var3);

    protected abstract Object getValue(String var1, int var2);

    protected abstract int getEntrySize();
}

