/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.declaration.algorithm;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tdm.business.declaration.algorithm.AbstractExportDeclarationAlgorithm;

public class ExportDeclarationAlgorithmForForm
extends AbstractExportDeclarationAlgorithm {
    protected static Log log = LogFactory.getLog(ExportDeclarationAlgorithmForForm.class);
    protected IFormView view;
    protected IDataModel model;

    public ExportDeclarationAlgorithmForForm(IFormView view, IDataModel model) {
        this.view = view;
        this.model = model;
        this.initParam();
    }

    public void calByChange(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (this.isExistField(this.model, "entryentity", fieldName)) {
            int rowIndex = changeData.getRowIndex();
            this.model.beginInit();
            boolean hasCal = this.calByEntryChange(fieldName, rowIndex);
            this.model.endInit();
            if (hasCal) {
                this.view.updateView("entryentity");
            }
        } else if (this.isExistField(this.model, fieldName)) {
            this.model.beginInit();
            boolean hasCal = this.calByChange(fieldName);
            this.model.endInit();
            if (hasCal) {
                this.view.updateView();
            }
        }
    }

    protected boolean calByChange(String key) {
        boolean hasCal = true;
        switch (key) {
            case "freightcurrency": {
                this.calFreightex();
                this.calEntryMylaj();
                break;
            }
            case "premiumcurrency": {
                this.calPremiumex();
                this.calEntryMylaj();
                break;
            }
            case "sundrycurrency": {
                this.calSundryex();
                this.calEntryMylaj();
                break;
            }
            case "exportdate": {
                this.calFreightex();
                this.calPremiumex();
                this.calSundryex();
                this.calEntryTradeex();
                this.calEntryMylaj();
                break;
            }
            case "freightamount": {
                this.calEntryYfAmount();
                this.calEntryMylaj();
                break;
            }
            case "premiumamount": {
                this.calEntryBfAmount();
                this.calEntryMylaj();
                break;
            }
            case "sundryamount": {
                this.calEntryZfAmount();
                this.calEntryMylaj();
                break;
            }
            case "freightex": 
            case "premiumex": 
            case "sundryex": 
            case "tradeway": {
                this.calEntryMylaj();
                break;
            }
            default: {
                hasCal = false;
            }
        }
        return hasCal;
    }

    protected boolean calByEntryChange(String key, int i) {
        boolean hasCal = true;
        boolean exceedLimit = false;
        switch (key) {
            case "tradeqty": 
            case "tradeprice": {
                exceedLimit = this.calTradeamount(i);
                this.calEntryYfAmount();
                this.calEntryBfAmount();
                this.calEntryZfAmount();
                this.calEntryMylaj();
                break;
            }
            case "tradecurrency": {
                this.calTradeex(i);
                this.calMylaj(i);
                break;
            }
            case "tradeamount": {
                this.calEntryYfAmount();
                this.calEntryBfAmount();
                this.calEntryZfAmount();
                this.calEntryMylaj();
                break;
            }
            case "tradeex": 
            case "yfamount": 
            case "bfamount": 
            case "zfamount": {
                this.calMylaj(i);
                break;
            }
            default: {
                hasCal = false;
            }
        }
        if (exceedLimit) {
            this.showErrorMsg(ResManager.loadKDString((String)"\u6210\u4ea4\u91d1\u989d\u8d85\u51fa\u8303\u56f4[0, 999999999999.99]\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ExportDeclarationAlgorithmForForm_0", (String)"taxc-tdm-business", (Object[])new Object[0]));
        }
        return hasCal;
    }

    public void calByDeleteRow() {
        this.calEntryYfAmount();
        this.calEntryBfAmount();
        this.calEntryZfAmount();
        this.calEntryMylaj();
        this.view.updateView("entryentity");
    }

    @Override
    protected void setValue(String key, Object value) {
        this.model.setValue(key, value);
    }

    @Override
    protected Object getValue(String key) {
        return this.model.getValue(key);
    }

    @Override
    protected void setValue(String key, Object value, int i) {
        DynamicObjectCollection entrys = this.model.getEntryEntity("entryentity");
        ((DynamicObject)entrys.get(i)).set(key, value);
    }

    @Override
    protected Object getValue(String key, int i) {
        DynamicObjectCollection entrys = this.model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        return ((DynamicObject)entrys.get(i)).get(key);
    }

    @Override
    protected int getEntrySize() {
        DynamicObjectCollection billEntry = this.model.getEntryEntity("entryentity");
        return billEntry.size();
    }

    protected boolean isExistField(IDataModel bill, String fieldName) {
        if (bill == null) {
            return false;
        }
        boolean isExist = false;
        IDataEntityProperty dataEntiryProperty = bill.getDataEntityType().findProperty(fieldName);
        if (dataEntiryProperty != null) {
            isExist = true;
        }
        return isExist;
    }

    protected boolean isExistField(IDataModel bill, String entryName, String fieldName) {
        if (bill == null) {
            return false;
        }
        Map type = bill.getDataEntityType().getAllEntities();
        EntityType entityType = (EntityType)type.get(entryName);
        boolean isExist = false;
        IDataEntityProperty dataEntiryProperty = entityType.findProperty(fieldName);
        if (dataEntiryProperty != null) {
            isExist = true;
        }
        return isExist;
    }

    protected void showErrorMsg(String msg) {
        this.view.showErrorNotification(msg);
    }
}

