/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.declaration.task;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.executor.Task;
import kd.taxc.tdm.business.declaration.ExportDeclarationGatherService;
import kd.taxc.tdm.common.bean.ExportDeclarationGatherParam;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExportDeclarationGatherThreadTask
extends Task<List<ExportDeclarationGatherParam>> {
    private static Log logger = LogFactory.getLog(ExportDeclarationGatherThreadTask.class);
    private static final int BATCH_SIZE = 2;
    private List<ExportDeclarationGatherParam> gatherParams = null;
    private List<String> exceptionList = null;

    public ExportDeclarationGatherThreadTask(List<ExportDeclarationGatherParam> gatherParams, List<String> exceptionList) {
        this.gatherParams = gatherParams;
        this.exceptionList = exceptionList;
    }

    public List<List<ExportDeclarationGatherParam>> getValue() {
        return Lists.partition(this.gatherParams, (int)2);
    }

    public List<ExportDeclarationGatherParam> executor(List<ExportDeclarationGatherParam> gatherParams) {
        for (ExportDeclarationGatherParam gatherParam : gatherParams) {
            try {
                ExportDeclarationGatherService.downloadExportDeclaration(gatherParam);
            }
            catch (Exception e) {
                String msg = ExceptionUtils.getStackTrace((Throwable)e);
                this.exceptionList.add(msg);
                logger.error("\u3010\u62a5\u5173\u5355\u91c7\u96c6\u4f5c\u4e1a\u3011\u6267\u884c\u5f02\u5e38\uff1a{}", (Object)msg);
            }
        }
        return gatherParams;
    }
}

