/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.depreciation;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.business.comparisonmodel.DataCompareBusiness;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareParams;
import kd.taxc.tdm.common.util.DateUtils;

public class AccountDepreciationChangeService {
    private static Log logger = LogFactory.getLog(AccountDepreciationChangeService.class);

    public static void calUpAndDownAndSaveChangeSingle(Long orgId, String assetcode, Date currentPeriod) {
        if (orgId == null || StringUtils.isEmpty((String)assetcode) || currentPeriod == null) {
            logger.info("calAndSaveChangeSingle skip ,unique params have null");
            return;
        }
        AccountDepreciationChangeService.calUpAndSaveChange(orgId, assetcode, currentPeriod, currentPeriod);
        Date nextPeriod = DateUtils.addMonth((Date)currentPeriod, (int)1);
        AccountDepreciationChangeService.calUpAndSaveChange(orgId, assetcode, nextPeriod, nextPeriod);
    }

    public static void calUpAndDownAndSaveChange(List<Map<String, Object>> paramList) {
        if (paramList == null || paramList.isEmpty()) {
            logger.info("calAndSaveChange skip ,paramList is null");
            return;
        }
        ArrayList nextPeriodParamList = new ArrayList(10);
        Iterator<Map<String, Object>> iterator = paramList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> param = iterator.next();
            if (param.get("orgId") == null || StringUtils.isEmpty((String)((String)param.get("assetcode"))) || param.get("currentPeriod") == null) {
                logger.info("calAndSaveChange skip ,unique params have null");
                iterator.remove();
                continue;
            }
            HashMap<String, Object> nextParam = new HashMap<String, Object>(3);
            nextParam.put("orgId", param.get("orgId"));
            nextParam.put("assetcode", param.get("assetcode"));
            Date currentPeriod = (Date)param.get("currentPeriod");
            Date nextPeriod = DateUtils.addMonth((Date)currentPeriod, (int)1);
            nextParam.put("currentPeriod", nextPeriod);
            nextPeriodParamList.add(nextParam);
        }
        paramList.addAll(nextPeriodParamList);
        AccountDepreciationChangeService.calUpAndSaveChange(paramList);
    }

    public static void calUpAndSaveChange(List<Map<String, Object>> paramList) {
        DataCompareParams compareParams = new DataCompareParams();
        HashMap<String, List<Map<String, Object>>> params = new HashMap<String, List<Map<String, Object>>>(16);
        params.put("paramList", paramList);
        compareParams.setParams(params);
        compareParams.setSchemeId(Long.valueOf(3L));
        DataCompareBusiness.doCompare((DataCompareParams)compareParams);
    }

    public static void calUpAndSaveChange(Long orgId, String assetcode, Date startPeriod, Date endPeriod) {
        DataCompareParams compareParams = new DataCompareParams();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("org", orgId);
        params.put("assetcode", assetcode);
        params.put("startperiod", startPeriod);
        params.put("endperiod", endPeriod);
        compareParams.setParams(params);
        compareParams.setSchemeId(Long.valueOf(3L));
        DataCompareBusiness.doCompare((DataCompareParams)compareParams);
    }

    public static void delChangeById(List<Long> accountDepreChangeIds) {
        if (accountDepreChangeIds != null && !accountDepreChangeIds.isEmpty()) {
            DeleteServiceHelper.delete((String)"tdm_accountdepre_change", (QFilter[])new QFilter[]{new QFilter("id", "in", accountDepreChangeIds)});
        }
    }

    public static void delChangeByCondition(List<DynamicObject> accountDepreChangeList) {
        if (accountDepreChangeList != null && !accountDepreChangeList.isEmpty()) {
            for (DynamicObject accountDepre : accountDepreChangeList) {
                QFilter orgFilter = new QFilter("org", "=", (Object)accountDepre.getLong("org"));
                QFilter assetcodeFilter = new QFilter("assetcode", "=", (Object)accountDepre.getString("assetcode"));
                QFilter periodFilter = new QFilter("accountingperiod", "=", (Object)accountDepre.getDate("accountingperiod"));
                DeleteServiceHelper.delete((String)"tdm_accountdepre_change", (QFilter[])new QFilter[]{orgFilter, assetcodeFilter, periodFilter});
            }
        }
    }

    public static void delChangeByFilter(QFilter filter) {
        if (filter == null) {
            return;
        }
        DeleteServiceHelper.delete((String)"tdm_accountdepre_change", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection queryChangeData(Long orgId, String assetcode, Date startdate, Date enddate) {
        DynamicObjectCollection changeDataCollection = new DynamicObjectCollection();
        if (orgId == null || StringUtils.isEmpty((String)assetcode) || startdate == null) {
            logger.info("AccountDepreciationChangeService.queryChangeData params missing:orgId:" + orgId + "  assetcode:" + assetcode + "  startdate" + startdate + " enddate" + enddate);
            return changeDataCollection;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter assetcodeFilter = new QFilter("assetcode", "=", (Object)assetcode);
        QFilter periodFilter = new QFilter("1", "=", (Object)1);
        if (enddate == null) {
            periodFilter = new QFilter("accountingperiod", ">=", (Object)startdate);
        } else {
            periodFilter = new QFilter("accountingperiod", ">=", (Object)startdate);
            periodFilter.and(new QFilter("accountingperiod", "<=", (Object)enddate));
        }
        changeDataCollection = QueryServiceHelper.query((String)"tdm_accountdepre_change", (String)"id,org,assetcode,assetname,accountingperiod,preaccountdepreid,accountdepreid,entryentity,createdate,entryentity.seq,entryentity.changefield,entryentity.changefieldname,entryentity.oldvalue,entryentity.newvalue", (QFilter[])new QFilter[]{orgFilter, assetcodeFilter, periodFilter});
        if (changeDataCollection.isEmpty()) {
            return changeDataCollection;
        }
        return changeDataCollection;
    }

    public static List<DynamicObjectCollection> batchQueryChangeData(List<Map<String, Object>> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        ArrayList<DynamicObjectCollection> changeDataCollectionList = new ArrayList<DynamicObjectCollection>(params.size());
        for (Map<String, Object> param : params) {
            changeDataCollectionList.add(AccountDepreciationChangeService.queryChangeData((Long)param.get("orgId"), (String)param.get("assetcode"), (Date)param.get("startdate"), (Date)param.get("enddate")));
        }
        return changeDataCollectionList;
    }
}

