/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.depreciation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.OperationResultHelper;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.PartitionSaveTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class AutoGenerateAssetCardService {
    private static String CARDENTITY = "tdm_asset_taxc_card";

    public static Map<String, Object> generateData(Map<String, String> orgmap, String accountingperiod) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        ArrayList<String> errorMsgList = new ArrayList<String>(8);
        result.put("successList", new ArrayList());
        result.put("errorMsgList", errorMsgList);
        HashMap<Long, Object> enableAccoutOrgMap = new HashMap<Long, Object>(8);
        Date periods = DateUtils.stringToDate2((String)accountingperiod);
        for (Map.Entry<String, String> entry : orgmap.entrySet()) {
            String orgName = entry.getValue();
            long accountOrgId = Long.parseLong(entry.getKey());
            Long taxOrgId = AutoGenerateAssetCardService.queryDefaultTaxOrgId(accountOrgId);
            if (taxOrgId == null) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7[%s]\u6ca1\u6709\u5339\u914d\u5230\u5bf9\u5e94\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"AutoGenerateAssetCardService_1", (String)"taxc-tdm-business", (Object[])new Object[0]), orgName));
                continue;
            }
            TaxResult taxcMainByOrgIdAndIsTaxpayer = TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)taxOrgId);
            if (!taxcMainByOrgIdAndIsTaxpayer.isSuccess() || !((Boolean)taxcMainByOrgIdAndIsTaxpayer.getData()).booleanValue()) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7[%s]\u5339\u914d\u5230\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u53ef\u7528\u3002", (String)"AutoGenerateAssetCardService_9", (String)"taxc-tdm-business", (Object[])new Object[0]), orgName));
                continue;
            }
            Long taxationsysId = AutoGenerateAssetCardService.getTaxareIdAndTaxationsysIdByOrgId(taxOrgId, true);
            if (taxationsysId == null) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7[%s]\u59d4\u6258\u7684\u7a0e\u52a1\u7ec4\u7ec7\u5339\u914d\u7684\u7a0e\u6536\u5236\u5ea6\u4e0d\u53ef\u7528\u3002", (String)"AutoGenerateAssetCardService_8", (String)"taxc-tdm-business", (Object[])new Object[0]), orgName));
                continue;
            }
            Long taxareId = AutoGenerateAssetCardService.getTaxareIdAndTaxationsysIdByOrgId(taxOrgId, false);
            if (taxareId == null) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7[%s]\u59d4\u6258\u7684\u7a0e\u52a1\u7ec4\u7ec7\u6ca1\u6709\u5b8c\u5584\u8f96\u533a\u5b57\u6bb5\uff0c\u8bf7\u5148\u524d\u5f80\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u7ef4\u62a4\u3002", (String)"AutoGenerateAssetCardService_2", (String)"taxc-tdm-business", (Object[])new Object[0]), orgName));
                continue;
            }
            HashMap<String, Long> taxorgmap = new HashMap<String, Long>(8);
            taxorgmap.put("taxOrgId", taxOrgId);
            taxorgmap.put("taxationsysId", taxationsysId);
            taxorgmap.put("taxareId", taxareId);
            enableAccoutOrgMap.put(accountOrgId, taxorgmap);
        }
        Set<Long> enableAccountOrgIds = enableAccoutOrgMap.keySet();
        DataSet assetDatas = AutoGenerateAssetCardService.queryAssetData(enableAccountOrgIds, periods);
        if (!assetDatas.hasNext()) {
            result.put("datasize", 0);
            errorMsgList.add(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6838\u7b97\u7ec4\u7ec7\u5728\u8be5\u4f1a\u8ba1\u671f\u95f4\u5185\u5747\u65e0\u7b26\u5408\u7684\u8d44\u4ea7\u6e05\u5355\u6570\u636e\u3002", (String)"AutoGenerateAssetCardService_0", (String)"taxc-tdm-business", (Object[])new Object[0]));
            return result;
        }
        Date lastPeroids = DateUtils.addMonth((Date)periods, (int)-1);
        Map<String, DynamicObject> assetIdMap = AutoGenerateAssetCardService.queryLastCardDatas(enableAccountOrgIds, lastPeroids);
        int count = AutoGenerateAssetCardService.handlerData(assetDatas, assetIdMap, periods, lastPeroids, enableAccoutOrgMap);
        result.put("datasize", count);
        result.put("errorMsgList", errorMsgList);
        return result;
    }

    private static DataSet queryAssetData(Set<Long> accountOrgIds, Date periods) {
        String entity = "tdm_asset_data";
        String selectField = "id,taxorg,assetcode,assetname,startdate,assetclass,assetstatus,cleaningdate,assetsvalue,nodepreciation,rdaddition,storagelocation,assetuse,initval,accamortizationperiods,accresidualvalue,accdepreciationmethod";
        QFilter orgFilter = new QFilter("taxorg", "in", accountOrgIds);
        QFilter accountingperiodFilter = new QFilter("startdate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)periods));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("assetstatus", "in", Arrays.asList("on", "stop")).or(new QFilter("assetstatus", "=", (Object)"clean").and(new QFilter("cleaningdate", ">=", (Object)periods)));
        QFilter assetclassFilter = new QFilter("assetclass", "is not null", null).and(new QFilter("assetclass", "!=", (Object)" "));
        DataSet assetData = QueryServiceHelper.queryDataSet((String)"queryAssetData", (String)entity, (String)selectField, (QFilter[])new QFilter[]{orgFilter, accountingperiodFilter, enableFilter, statusFilter, assetclassFilter}, null);
        DataSet cardDatas = AutoGenerateAssetCardService.queryCurrentPeroidsCards(accountOrgIds, periods);
        DataSet result = assetData.leftJoin(cardDatas).on("id", "assetdata").select(selectField.split(","), new String[]{"accountingperiod"}).finish().where("accountingperiod is null");
        return result;
    }

    private static DataSet queryCurrentPeroidsCards(Set<Long> accountOrgIds, Date periods) {
        String selectField = "assetdata,accountingperiod";
        QFilter accountorgFilter = new QFilter("accountorg", "in", accountOrgIds);
        QFilter preiodFilter = new QFilter("accountingperiod", "=", (Object)periods);
        QFilter taxaccountingbookFilter = new QFilter("taxaccountingbook", "=", (Object)"ybzj");
        DataSet cardDatas = QueryServiceHelper.queryDataSet((String)"queryCurrentPeroidsCards", (String)CARDENTITY, (String)selectField, (QFilter[])new QFilter[]{accountorgFilter, preiodFilter, taxaccountingbookFilter}, null);
        return cardDatas;
    }

    private static Long queryDefaultTaxOrgId(long accountOrgId) {
        Map orgRelationAccountToTax = OrgRelationDataServiceHelper.getOrgRelationAccountToTax((Long)accountOrgId, (boolean)true);
        List orglist = (List)orgRelationAccountToTax.get("data");
        if (!CollectionUtils.isEmpty((Collection)orglist)) {
            Optional<HashMap> first = orglist.stream().filter(o -> (Boolean)o.get("isDefault")).findFirst();
            if (first.isPresent()) {
                HashMap orgObj = first.get();
                return (Long)orgObj.get("orgId");
            }
            return (Long)((HashMap)orglist.get(0)).get("orgId");
        }
        TaxResult taxcMainByOrgIdAndIsTaxpayer = TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)accountOrgId);
        if (taxcMainByOrgIdAndIsTaxpayer.isSuccess() && ((Boolean)taxcMainByOrgIdAndIsTaxpayer.getData()).booleanValue()) {
            return accountOrgId;
        }
        return null;
    }

    private static Map<String, DynamicObject> queryLastCardDatas(Set<Long> accountOrgIds, Date lastPeroids) {
        QFilter accountorgFilter = new QFilter("accountorg", "in", accountOrgIds);
        QFilter lastPreiodFilter = new QFilter("accountingperiod", "=", (Object)lastPeroids);
        QFilter taxaccountingbookFilter = new QFilter("taxaccountingbook", "=", (Object)"ybzj");
        String selectField = "assetdata,accountorg,accountingperiod,taxassetclass,taxbase,taxdepreciation,taxamortizationperiods,depreciationadjustmethod,taxdepreciatedperiods, booktaxdifferenttype";
        DynamicObjectCollection lastCardDatas = QueryServiceHelper.query((String)CARDENTITY, (String)selectField, (QFilter[])new QFilter[]{accountorgFilter, lastPreiodFilter, taxaccountingbookFilter});
        return lastCardDatas.stream().collect(Collectors.toMap(k -> k.getString("assetdata") + DateUtils.format((Date)k.getDate("accountingperiod")), v -> v, (k1, k2) -> k1));
    }

    private static Long getTaxareIdAndTaxationsysIdByOrgId(long taxOrgId, boolean isTaxationsys) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)taxOrgId)});
        DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
        DynamicObject taxationsys = ((DynamicObject)entryentity.get(0)).getDynamicObject("entry_taxationsys");
        long taxationsysId = taxationsys.getLong("id");
        boolean exists = QueryServiceHelper.exists((String)"bd_taxationsys", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxationsysId), new QFilter("enable", "=", (Object)"1")});
        if (isTaxationsys) {
            if (exists) {
                return taxationsysId;
            }
            return null;
        }
        DynamicObjectCollection taxarea = ((DynamicObject)entryentity.get(0)).getDynamicObjectCollection("entry_taxarea");
        if (taxarea.size() > 0 && (exists = QueryServiceHelper.exists((String)"bastax_taxareagroup", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((DynamicObject)taxarea.get(0)).getLong("fbasedataid_id")), new QFilter("enable", "=", (Object)"1")}))) {
            return ((DynamicObject)taxarea.get(0)).getLong("fbasedataid_id");
        }
        return null;
    }

    private static int handlerData(DataSet assetDatas, Map<String, DynamicObject> assetIdMap, Date periods, Date lastPeroids, Map<Long, Object> enableAccoutOrgMap) {
        List<String> assignmentFieldList = Arrays.asList("startdate", "assetclass", "assetsvalue", "nodepreciation", "rdaddition", "assetuse", "accamortizationperiods", "accresidualvalue", "accdepreciationmethod");
        ArrayList<DynamicObject> cardObjList = new ArrayList<DynamicObject>(8);
        String lastPeroidsStr = DateUtils.format((Date)lastPeroids);
        int count = 0;
        for (Row assetData : assetDatas) {
            String key = assetData.get("id") + lastPeroidsStr;
            DynamicObject cardObj = BusinessDataServiceHelper.newDynamicObject((String)CARDENTITY);
            for (String field : assignmentFieldList) {
                cardObj.set(field, assetData.get(field));
            }
            long maindataid = DBServiceHelper.genLongIds((String)CARDENTITY, (int)1)[0];
            cardObj.set("assetdata", assetData.get("id"));
            cardObj.set("id", (Object)maindataid);
            cardObj.set("number", (Object)maindataid);
            cardObj.set("creator", (Object)RequestContext.get().getUserId());
            cardObj.set("createtime", (Object)new Date());
            cardObj.set("status", (Object)"A");
            cardObj.set("enable", (Object)"1");
            cardObj.set("assetstatus", (Object)"on");
            cardObj.set("accountingperiod", (Object)periods);
            cardObj.set("accountorg", assetData.get("taxorg"));
            Map taxorgMap = (Map)enableAccoutOrgMap.get(assetData.getLong("taxorg"));
            cardObj.set("taxorg", taxorgMap.get("taxOrgId"));
            cardObj.set("taxationsys", taxorgMap.get("taxationsysId"));
            cardObj.set("taxarea", taxorgMap.get("taxareId"));
            cardObj.set("policyconfirmationstatus", (Object)"0");
            cardObj.set("datasource", (Object)"system");
            cardObj.set("currency", (Object)1L);
            cardObj.set("taxaccountingbook", (Object)"ybzj");
            cardObj.set("taxresidualvalue", assetData.get("accresidualvalue"));
            cardObj.set("depreciationstatus", (Object)"0");
            BigDecimal accresidualvalue = assetData.getBigDecimal("accresidualvalue");
            if (accresidualvalue == null) {
                accresidualvalue = new BigDecimal(0);
            }
            if (assetIdMap.get(key) != null) {
                DynamicObject lastCardObj = assetIdMap.get(key);
                cardObj.set("taxassetclass", lastCardObj.get("taxassetclass"));
                String booktaxdifferenttype = lastCardObj.getString("booktaxdifferenttype");
                if (booktaxdifferenttype.contains("0")) {
                    cardObj.set("taxbase", lastCardObj.get("taxbase"));
                } else {
                    cardObj.set("taxbase", assetData.get("assetsvalue"));
                }
                cardObj.set("taxdepreciation", lastCardObj.get("taxdepreciation"));
                cardObj.set("depreciationadjustmethod", lastCardObj.get("depreciationadjustmethod"));
                cardObj.set("taxamortizationperiods", lastCardObj.get("taxamortizationperiods"));
                cardObj.set("taxdepreciatedperiods", (Object)(lastCardObj.getInt("taxdepreciatedperiods") + 1));
                if (cardObj.getInt("taxdepreciatedperiods") > cardObj.getInt("taxamortizationperiods")) {
                    cardObj.set("taxdepreciatedperiods", (Object)cardObj.getInt("taxamortizationperiods"));
                }
                cardObj.set("taxsurplusdepperiods", (Object)(cardObj.getInt("taxamortizationperiods") - cardObj.getInt("taxdepreciatedperiods")));
                cardObj.set("netamount", (Object)lastCardObj.getBigDecimal("taxbase").subtract(accresidualvalue));
            } else {
                cardObj.set("taxdepreciatedperiods", (Object)0);
                cardObj.set("netamount", (Object)assetData.getBigDecimal("assetsvalue").subtract(accresidualvalue));
                cardObj.set("taxbase", assetData.get("assetsvalue"));
            }
            cardObjList.add(cardObj);
            ++count;
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(cardObjList));
        return count;
    }

    public static Map<String, Object> identifyGeneralPolicy(List<Object> successPkIds) {
        DynamicObject[] selectCardObjs = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tdm_asset_taxc_card"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        ArrayList<Object> successList = new ArrayList<Object>();
        Map<String, DynamicObject> lastCardMap = AutoGenerateAssetCardService.queryCardDatas(selectCardObjs, "ybzj", Boolean.TRUE);
        Map<String, Long> taxAssetTypeMap = AutoGenerateAssetCardService.queryTaxAssetType(selectCardObjs);
        for (DynamicObject object : selectCardObjs) {
            String accountorg = object.getDynamicObject("accountorg").getString("id");
            String taxationsys = object.getDynamicObject("taxationsys").getString("id");
            String taxarea = object.getDynamicObject("taxarea").getString("id");
            String assetdata = object.getDynamicObject("assetdata").getString("id");
            String assetclass = object.getString("assetclass");
            Date accountingperiod = object.getDate("accountingperiod");
            String lastPeriod = DateUtils.format((Date)DateUtils.addMonth((Date)accountingperiod, (int)-1));
            String lastCardKey = accountorg + assetdata + lastPeriod;
            DynamicObject lastCard = lastCardMap.get(lastCardKey);
            String taxAssetTypeKey = taxationsys + taxarea + assetclass;
            Long taxAssetTypeId = taxAssetTypeMap.getOrDefault(taxAssetTypeKey, null);
            DynamicObject generatePolicy = null;
            if (taxAssetTypeId != null) {
                generatePolicy = AutoGenerateAssetCardService.queryGeneratePolicyByTaxAssetTypeId(taxAssetTypeId, accountingperiod);
            }
            if (generatePolicy == null) {
                String msgerr = String.format(ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25\uff0c\u8d44\u4ea7\u7f16\u7801%1$s\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u7a0e\u52a1\u8d44\u4ea7\u7c7b\u522b\u3002", (String)"AutoGenerateAssetCardService_5", (String)"taxc-tdm-business", (Object[])new Object[0]), object.getDynamicObject("assetdata").getString("assetcode"));
                errorMsgList.add(msgerr);
                continue;
            }
            object.set("taxassetclass", (Object)taxAssetTypeId);
            object.set("taxdepreciation", generatePolicy.get("depreciation"));
            int period = generatePolicy.getInt("period");
            int accamortizationperiods = object.getInt("accamortizationperiods");
            if (period > accamortizationperiods) {
                accamortizationperiods = period;
            }
            if (lastCard != null) {
                String booktaxdifferenttype = lastCard.getString("booktaxdifferenttype");
                object.set("depreciationadjustmethod", lastCard.get("depreciationadjustmethod"));
                if (booktaxdifferenttype.contains("1")) {
                    object.set("taxamortizationperiods", lastCard.get("taxamortizationperiods"));
                } else {
                    object.set("taxamortizationperiods", (Object)accamortizationperiods);
                }
                successList.add(object.get("id"));
                continue;
            }
            object.set("depreciationadjustmethod", generatePolicy.get("adjustway"));
            object.set("taxamortizationperiods", (Object)accamortizationperiods);
            successList.add(object.get("id"));
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(Arrays.asList(selectCardObjs)));
        result.put("successList", successList);
        result.put("errorMsgList", errorMsgList);
        return result;
    }

    public static Map<String, Object> identifyAccelerationPolicy(List<Object> successPkIds) {
        DynamicObject[] selectCardObjs = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tdm_asset_taxc_card"));
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        ArrayList<String> errorMsgList = new ArrayList<String>(8);
        ArrayList<Object> successList = new ArrayList<Object>(8);
        Map<String, DynamicObject> lastCardMap = AutoGenerateAssetCardService.queryCardDatas(selectCardObjs, "jszj", Boolean.TRUE);
        Map<String, DynamicObject> currentCardMap = AutoGenerateAssetCardService.queryCardDatas(selectCardObjs, "jszj", Boolean.FALSE);
        for (Map.Entry<String, DynamicObject> object : currentCardMap.entrySet()) {
            DynamicObject value = object.getValue();
            String number = value.getString("number");
            int index = number.lastIndexOf("-");
            String assetcode = number.substring(0, index);
            String msgerr = String.format(ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25\uff0c\u8d44\u4ea7\u7f16\u7801%1$s\u5728%2$s\u4f1a\u8ba1\u671f\u95f4\u5df2\u5b58\u5728\u52a0\u901f\u5361\u7247\u6570\u636e\u3002", (String)"AutoGenerateAssetCardService_6", (String)"taxc-tdm-business", (Object[])new Object[0]), assetcode, DateUtils.format((Date)value.getDate("accountingperiod")));
            errorMsgList.add(msgerr);
        }
        List needHandleDatas = Arrays.stream(selectCardObjs).filter(e -> !currentCardMap.containsKey(e.getDynamicObject("accountorg").getString("id") + e.getDynamicObject("assetdata").getString("id") + DateUtils.format((Date)e.getDate("accountingperiod")))).collect(Collectors.toList());
        ArrayList<DynamicObject> saveDataList = new ArrayList<DynamicObject>();
        for (DynamicObject object : needHandleDatas) {
            String accountorg = object.getDynamicObject("accountorg").getString("id");
            String assetdata = object.getDynamicObject("assetdata").getString("id");
            String taxassetclassNumber = object.getDynamicObject("taxassetclass") != null ? object.getDynamicObject("taxassetclass").getString("classnumber") : "";
            BigDecimal taxbase = object.getBigDecimal("taxbase");
            Date accountingperiod = object.getDate("accountingperiod");
            int taxamortizationperiods = object.getInt("taxamortizationperiods");
            String lastPeriod = DateUtils.format((Date)DateUtils.addMonth((Date)accountingperiod, (int)-1));
            long maindataid = DBServiceHelper.genLongIds((String)"tdm_asset_taxc_card", (int)1)[0];
            String lastCardKey = accountorg + assetdata + lastPeriod;
            DynamicObject lastCard = lastCardMap.get(lastCardKey);
            if (lastCard != null) {
                DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)"tdm_asset_taxc_card");
                BeanCopyUtils.copyDynamicObject((DynamicObject)object, (DynamicObject)target);
                CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)target.getDataEntityType().getName(), (DynamicObject)target, null);
                String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)target);
                target.set("id", (Object)maindataid);
                target.set("number", (Object)number);
                target.set("datasource", (Object)"system");
                target.set("creator", (Object)RequestContext.get().getCurrUserId());
                target.set("createtime", (Object)new Date());
                target.set("taxaccountingbook", (Object)"jszj");
                target.set("policyconfirmationstatus", (Object)"0");
                target.set("booktaxdifferent", (Object)" ");
                target.set("booktaxdifferenttype", (Object)" ");
                target.set("depreciationstatus", (Object)"0");
                target.set("taxcurrentdepamount", (Object)BigDecimal.ZERO);
                target.set("taxthisyeardepamount", (Object)BigDecimal.ZERO);
                target.set("taxaccumulateddepamount", (Object)BigDecimal.ZERO);
                target.set("quicktaxassetclass", lastCard.get("quicktaxassetclass"));
                target.set("taxdepreciation", lastCard.get("taxdepreciation"));
                target.set("taxamortizationperiods", lastCard.get("taxamortizationperiods"));
                target.set("taxdepreciatedperiods", (Object)(lastCard.getInt("taxdepreciatedperiods") + 1));
                if (target.getInt("taxdepreciatedperiods") > target.getInt("taxamortizationperiods")) {
                    target.set("taxdepreciatedperiods", (Object)target.getInt("taxamortizationperiods"));
                }
                target.set("taxsurplusdepperiods", (Object)(target.getInt("taxamortizationperiods") - target.getInt("taxdepreciatedperiods")));
                target.set("depreciationadjustmethod", lastCard.get("depreciationadjustmethod"));
                target.set("netamount", (Object)target.getBigDecimal("taxbase").subtract(target.getBigDecimal("taxaccumulateddepamount")).subtract(target.getBigDecimal("taxresidualvalue")));
                saveDataList.add(target);
                successList.add(object.get("id"));
                continue;
            }
            if (BigDecimal.valueOf(5000000L).compareTo(taxbase) >= 0 && taxamortizationperiods > 12 && Arrays.asList("701020102", "701020103", "701020104", "701020105").contains(taxassetclassNumber)) {
                DynamicObject generatePolicy = AutoGenerateAssetCardService.queryGeneratePolicyByTaxAssetTypeId(1873325183838727169L, accountingperiod);
                if (generatePolicy == null) continue;
                DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)"tdm_asset_taxc_card");
                BeanCopyUtils.copyDynamicObject((DynamicObject)object, (DynamicObject)target);
                CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)target.getDataEntityType().getName(), (DynamicObject)target, null);
                String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)target);
                target.set("id", (Object)maindataid);
                target.set("number", (Object)number);
                target.set("datasource", (Object)"system");
                target.set("creator", (Object)RequestContext.get().getCurrUserId());
                target.set("createtime", (Object)new Date());
                target.set("taxaccountingbook", (Object)"jszj");
                target.set("policyconfirmationstatus", (Object)"0");
                target.set("booktaxdifferent", (Object)" ");
                target.set("booktaxdifferenttype", (Object)" ");
                target.set("depreciationstatus", (Object)"0");
                target.set("taxcurrentdepamount", (Object)BigDecimal.ZERO);
                target.set("taxthisyeardepamount", (Object)BigDecimal.ZERO);
                target.set("taxaccumulateddepamount", (Object)BigDecimal.ZERO);
                target.set("taxdepreciatedperiods", (Object)0);
                target.set("quicktaxassetclass", (Object)1873325183838727169L);
                target.set("taxdepreciation", generatePolicy.get("depreciation"));
                target.set("taxamortizationperiods", generatePolicy.get("period"));
                target.set("taxsurplusdepperiods", (Object)(target.getInt("taxamortizationperiods") - target.getInt("taxdepreciatedperiods")));
                target.set("netamount", (Object)target.getBigDecimal("taxbase").subtract(target.getBigDecimal("taxaccumulateddepamount")).subtract(target.getBigDecimal("taxresidualvalue")));
                target.set("depreciationadjustmethod", generatePolicy.get("adjustway"));
                saveDataList.add(target);
                successList.add(object.get("id"));
                continue;
            }
            String msgerr = String.format(ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25\uff0c\u8d44\u4ea7\u7f16\u7801%1$s\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u52a0\u901f\u6298\u65e7\u7c7b\u522b\u3002", (String)"AutoGenerateAssetCardService_7", (String)"taxc-tdm-business", (Object[])new Object[0]), object.getDynamicObject("assetdata").getString("assetcode"));
            errorMsgList.add(msgerr);
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(saveDataList));
        result.put("errorMsgList", errorMsgList);
        result.put("successList", successList);
        return result;
    }

    private static DynamicObject queryGeneratePolicyByTaxAssetTypeId(Long taxAssetTypeId, Date accountingperiod) {
        QFilter calssFilter = new QFilter("entryentity.id", "=", (Object)taxAssetTypeId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter dateFilter = new QFilter("entryentity.startdate", "<=", (Object)accountingperiod).and(new QFilter("entryentity.enddate", ">=", (Object)accountingperiod).or(new QFilter("entryentity.enddate", "is null", null)));
        String field = "entryentity.depreciation as depreciation,entryentity.period as period,entryentity.adjustway as adjustway";
        return QueryServiceHelper.queryOne((String)"tpo_yb_depreciation", (String)field, (QFilter[])new QFilter[]{calssFilter, enableFilter, dateFilter});
    }

    private static Map<String, Long> queryTaxAssetType(DynamicObject[] selectCardObjs) {
        List taxationsysList = Arrays.stream(selectCardObjs).map(e -> e.getDynamicObject("taxationsys").getLong("id")).collect(Collectors.toList());
        List taxareaList = Arrays.stream(selectCardObjs).map(e -> e.getDynamicObject("taxarea").getLong("id")).collect(Collectors.toList());
        List assetclassList = Arrays.stream(selectCardObjs).map(e -> e.getString("assetclass")).collect(Collectors.toList());
        QFilter taxationsysFilter = new QFilter("taxationsys", "in", taxationsysList);
        QFilter taxareaFilter = new QFilter("taxarea", "in", taxareaList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter accountassettypeFilter = new QFilter("entryentity.accountassettype", "in", assetclassList);
        String field = "taxationsys,taxarea,entryentity.accountassettype as accountassettype,entryentity.taxassettype as taxassettype";
        DynamicObjectCollection tdmAssetMapping = QueryServiceHelper.query((String)"tdm_asset_mapping", (String)field, (QFilter[])new QFilter[]{taxationsysFilter, taxareaFilter, accountassettypeFilter, enableFilter});
        return tdmAssetMapping.stream().collect(Collectors.toMap(k -> k.getString("taxationsys") + k.getString("taxarea") + k.getString("accountassettype"), v -> v.getLong("taxassettype"), (k1, k2) -> k1));
    }

    private static Map<String, DynamicObject> queryCardDatas(DynamicObject[] selectCardObjs, String taxaccountingbook, Boolean isLastPeriod) {
        List orgidList = Arrays.stream(selectCardObjs).map(e -> e.getDynamicObject("accountorg").getLong("id")).collect(Collectors.toList());
        List periodsList = isLastPeriod != false ? Arrays.stream(selectCardObjs).map(e -> DateUtils.addMonth((Date)e.getDate("accountingperiod"), (int)-1)).collect(Collectors.toList()) : Arrays.stream(selectCardObjs).map(e -> e.getDate("accountingperiod")).collect(Collectors.toList());
        List assetcodeList = Arrays.stream(selectCardObjs).map(e -> e.getDynamicObject("assetdata").getLong("id")).collect(Collectors.toList());
        QFilter taxaccountingbookFilter = new QFilter("taxaccountingbook", "=", (Object)taxaccountingbook);
        QFilter orgFilter = new QFilter("accountorg", "in", orgidList);
        QFilter assetFilter = new QFilter("assetdata", "in", assetcodeList);
        QFilter periodsFilter = new QFilter("accountingperiod", "in", periodsList);
        String field = "number,accountorg,assetdata,accountingperiod,taxbase,taxamortizationperiods,depreciationadjustmethod,booktaxdifferenttype,quicktaxassetclass,taxdepreciatedperiods,taxdepreciation";
        DynamicObject[] lastCard = BusinessDataServiceHelper.load((String)"tdm_asset_taxc_card", (String)field, (QFilter[])new QFilter[]{taxaccountingbookFilter, orgFilter, assetFilter, periodsFilter});
        return Arrays.stream(lastCard).collect(Collectors.toMap(k -> k.getDynamicObject("accountorg").getString("id") + k.getDynamicObject("assetdata").getString("id") + DateUtils.format((Date)k.getDate("accountingperiod")), v -> v));
    }

    public static OperationResult getOperationResult(Map<String, Object> validateMap) {
        List successList = (List)validateMap.get("successList");
        List successPkIds = successList.stream().map(e -> e.get("id")).collect(Collectors.toList());
        List errorMsgList = (List)validateMap.get("errorMsgList");
        int datasize = (Integer)validateMap.get("datasize");
        String successMsg = ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u6570\u636e\u6210\u529f\u3002", (String)"AutoGenerateAssetCardService_10", (String)"taxc-tdm-business", (Object[])new Object[0]);
        String operateName = ResManager.loadKDString((String)"\u6570\u636e\u751f\u6210", (String)"AutoGenerateAssetCardService_11", (String)"taxc-tdm-business", (Object[])new Object[0]);
        return OperationResultHelper.getFatalErrorOperateResult((String)operateName, (List)errorMsgList, (String)successMsg, (int)datasize, successPkIds);
    }

    public static OperationResult getGeneralOperationResult(int size, Map<String, Object> validateMap) {
        List errorMsgList = (List)validateMap.get("errorMsgList");
        List successList = (List)validateMap.get("successList");
        String successMsg = ResManager.loadKDString((String)"\u4e00\u822c\u653f\u7b56\u8bc6\u522b\u6210\u529f\u3002", (String)"AutoGenerateAssetCardService_12", (String)"taxc-tdm-business", (Object[])new Object[0]);
        String operateName = ResManager.loadKDString((String)"\u4e00\u822c\u653f\u7b56\u8bc6\u522b", (String)"AutoGenerateAssetCardService_13", (String)"taxc-tdm-business", (Object[])new Object[0]);
        return OperationResultHelper.getFatalErrorOperateResult((String)operateName, (List)errorMsgList, (String)successMsg, (int)size, (List)successList);
    }

    public static OperationResult getAccelerationOperationResult(int size, Map<String, Object> validateMap) {
        List errorMsgList = (List)validateMap.get("errorMsgList");
        List successList = (List)validateMap.get("successList");
        String successMsg = ResManager.loadKDString((String)"\u52a0\u901f\u6298\u65e7\u653f\u7b56\u8bc6\u522b\u6210\u529f\u3002", (String)"AutoGenerateAssetCardService_14", (String)"taxc-tdm-business", (Object[])new Object[0]);
        String operateName = ResManager.loadKDString((String)"\u52a0\u901f\u6298\u65e7\u653f\u7b56\u8bc6\u522b", (String)"AutoGenerateAssetCardService_15", (String)"taxc-tdm-business", (Object[])new Object[0]);
        return OperationResultHelper.getFatalErrorOperateResult((String)operateName, (List)errorMsgList, (String)successMsg, (int)size, (List)successList);
    }
}

