/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.element;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.taxc.tdm.business.customdatasource.CustomDatasourceDao;

public class ElementBusiness {
    public static List<Map<String, Object>> getDeclareModelDatasourceFilterColumns(String entityName, Long tableId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (entityType.getFields().containsKey("fetchitemtype") && entityType.getFields().containsKey("fetchitem")) {
            ((DynamicProperty)entityType.getFields().get("fetchitemtype")).setAlias("fetchitemtype");
            ((DynamicProperty)entityType.getFields().get("fetchitem")).setAlias("fetchitem");
        }
        List filterColumns = new EntityTypeUtil().getFilterColumns((IDataEntityType)entityType);
        QFilter filter = new QFilter("tableid", "=", (Object)tableId).and("wherestate", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = CustomDatasourceDao.queryDatasourceEntry(new QFilter[]{filter}, "fieldname,bizsubname,fieldsubname");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(filterColumns.size());
        for (Map filterColumn : filterColumns) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String fieldNameDb = dynamicObject.getString("fieldname");
                String fieldName = filterColumn.get("fieldName").toString();
                if (fieldName.contains(".longnumber") || fieldName.contains(".fullname") || !fieldName.startsWith(fieldNameDb + ".") && !fieldName.equals(fieldNameDb)) continue;
                result.add(filterColumn);
            }
        }
        return result;
    }

    public static List<Map<String, Object>> getDatasourceFilterColumns(DynamicObjectCollection datasourceEntryCollection, String isChild, String entityName, String subEntityName) {
        String actualEntityName = entityName;
        if (Boolean.FALSE.toString().equals(isChild) && StringUtils.isNotEmpty((CharSequence)subEntityName)) {
            actualEntityName = subEntityName;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)actualEntityName);
        List filterColumns = new EntityTypeUtil().getFilterColumns((IDataEntityType)entityType);
        Map<String, String> fieldNameBizSubNameMap = datasourceEntryCollection.stream().collect(Collectors.toMap(k -> k.getString("entryentity.fieldsubname") + "_" + k.getString("entryentity.fieldname"), v -> v.getString("entryentity.bizsubname")));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(filterColumns.size());
        HashSet<String> keys = new HashSet<String>(16);
        for (Map filterColumn : filterColumns) {
            String bizSubName;
            String table = (String)filterColumn.get("entryEntity");
            String fieldName = (String)filterColumn.get("fieldName");
            String key = table + "_" + fieldName.split("\\.")[0];
            String entityId = (String)filterColumn.get("entityId");
            String key2 = entityId + "_" + fieldName;
            Boolean isTwiceMatch = false;
            if (fieldNameBizSubNameMap.containsKey(key)) {
                bizSubName = fieldNameBizSubNameMap.get(key);
            } else {
                bizSubName = fieldNameBizSubNameMap.get(key2);
                isTwiceMatch = true;
            }
            if (StringUtils.isEmpty((CharSequence)bizSubName)) continue;
            if ("basedata".equals(filterColumn.get("type"))) {
                String caption = (String)filterColumn.get("fieldCaption");
                filterColumn.put("fieldCaption", caption.replaceAll("\\.", ""));
            } else {
                if (bizSubName.contains(".")) {
                    bizSubName = bizSubName.split("\\.")[1];
                }
                filterColumn.put("fieldCaption", bizSubName);
            }
            if (isTwiceMatch.booleanValue() && !keys.contains(key2)) {
                result.add(filterColumn);
                keys.add(key2);
                continue;
            }
            if (keys.contains(key)) continue;
            result.add(filterColumn);
            keys.add(key);
        }
        return result;
    }
}

