/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.event;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.taxc.tdm.business.depreciation.AccountDepreciationChangeService;

public class AccountDepreciationSaveEvent
implements IEventServicePlugin {
    private static Log logger = LogFactory.getLog(AccountDepreciationSaveEvent.class);

    public Object handleEvent(KDBizEvent evt) {
        if (evt == null || StringUtils.isEmpty((String)evt.getSource())) {
            logger.info("AccountDepreciationSaveEvent evt.source is empty");
            return null;
        }
        String jsonStr = evt.getSource();
        try {
            ArrayList accountDepreInfoList = (ArrayList)SerializationUtils.fromJsonString((String)jsonStr, List.class);
            if (accountDepreInfoList == null || accountDepreInfoList.isEmpty()) {
                logger.error("AccountDepreciationSaveEvent handleEvent accountDepreInfoList is empty");
                return null;
            }
            ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(10);
            for (HashMap accountDepreMap : accountDepreInfoList) {
                HashMap orgMap = (HashMap)accountDepreMap.get("org");
                Object idObj = orgMap.get("id");
                Long orgId = null;
                if (idObj instanceof Integer) {
                    orgId = ((Integer)idObj).longValue();
                } else if (idObj instanceof Long) {
                    orgId = (Long)idObj;
                }
                String assetcode = (String)accountDepreMap.get("assetcode");
                Long accountingPeriodLong = (Long)accountDepreMap.get("accountingperiod");
                Date accountingPeriod = new Date(accountingPeriodLong);
                HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
                paramMap.put("orgId", orgId);
                paramMap.put("assetcode", assetcode);
                paramMap.put("currentPeriod", accountingPeriod);
                paramList.add(paramMap);
            }
            if (!paramList.isEmpty()) {
                AccountDepreciationChangeService.calUpAndDownAndSaveChange(paramList);
            }
        }
        catch (Exception e) {
            logger.info("AccountDepreciationSaveEvent parseJsonError" + e.getMessage());
            return null;
        }
        return null;
    }
}

