/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.hr;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TaxcEmployeeCountBusiness {
    public static DynamicObject queryByDateMonthLatest(Long orgId, Date date) {
        DynamicObject[] dyns;
        if (date == null) {
            return null;
        }
        DynamicObject latest = null;
        for (DynamicObject dyn : dyns = TaxcEmployeeCountBusiness.queryByDateMonth(orgId, date)) {
            if (latest == null) {
                latest = dyn;
                continue;
            }
            Date ld = latest.getDate("countdate");
            Date d = dyn.getDate("countdate");
            if (!d.after(ld)) continue;
            latest = dyn;
        }
        return latest;
    }

    public static DynamicObject[] queryByDateMonthLatestBatch(List<Long> orgIds, Date date) {
        DynamicObject[] dyns;
        if (date == null) {
            return new DynamicObject[0];
        }
        HashMap<Long, List> orgMap = new HashMap<Long, List>(8);
        for (DynamicObject dyn : dyns = TaxcEmployeeCountBusiness.queryByDateMonthBatch(orgIds, date)) {
            Long orgId = dyn.getLong("org.id");
            List list = orgMap.computeIfAbsent(orgId, k -> new ArrayList(10));
            list.add(dyn);
        }
        ArrayList<DynamicObject> target = new ArrayList<DynamicObject>(10);
        for (List list : orgMap.values()) {
            target.add(TaxcEmployeeCountBusiness.getLatestByCountDate(list));
        }
        return target.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] queryByDateMonth(Long orgId, Date date) {
        ArrayList<Long> list = new ArrayList<Long>(2);
        list.add(orgId);
        return TaxcEmployeeCountBusiness.queryByDateMonthBatch(list, date);
    }

    public static DynamicObject[] queryByDateMonthBatch(List<Long> orgIds, Date date) {
        Date start = DateUtils.getFirstDateOfMonth((Date)date);
        Date end = DateUtils.getLastDateOfMonth((Date)date);
        QFilter q = new QFilter("countdate", ">=", (Object)start);
        q.and("countdate", "<=", (Object)end);
        q.and("org", "in", orgIds);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"tdm_employee_count", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,entryentity,org,countdate,headcount,note,entryentity.seq,entryentity.modifierfield,entryentity.modifydatefield", (QFilter[])new QFilter[]{q});
        return dyns;
    }

    private static DynamicObject getLatestByCountDate(List<DynamicObject> dyns) {
        DynamicObject latest = null;
        for (DynamicObject dyn : dyns) {
            if (latest == null) {
                latest = dyn;
                continue;
            }
            Date ld = latest.getDate("countdate");
            Date d = dyn.getDate("countdate");
            if (!d.after(ld)) continue;
            latest = dyn;
        }
        return latest;
    }
}

