/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.integration.function.bgd;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tdm.business.integration.constant.SupplierEnum;

public class BgdHelper {
    public static Long getCurrency(String code) {
        QFilter f = new QFilter("number", "=", (Object)code);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{f});
        if (dyns.length > 0) {
            return dyns[0].getLong("id");
        }
        return null;
    }

    public static Long getOrg(String code) {
        TaxResult ids = TaxcOrgDataServiceHelper.queryTaxcOrgIdByUnifiedsocialcode(Collections.singletonList(code));
        if (ids.isSuccess()) {
            if (((List)ids.getData()).size() == 0) {
                return 0L;
            }
            return (Long)((List)ids.getData()).get(0);
        }
        return 0L;
    }

    public static Long getCustomer(String code) {
        QFilter f = new QFilter("number", "=", (Object)code);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{f});
        if (dyns.length > 0) {
            return dyns[0].getLong("id");
        }
        return 0L;
    }

    public static Long getUnit(SupplierEnum supplier, String code) {
        QFilter f = new QFilter("jldwnumber", "=", (Object)code);
        f.and("suppliernumber", "=", (Object)supplier.getCode());
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"tdm_setting_jldw", (String)"unitfield.id", (QFilter[])new QFilter[]{f});
        if (dyns.length > 0) {
            return dyns[0].getLong("unitfield.id");
        }
        return 0L;
    }

    public static Long getSupervision(String code) {
        QFilter f = new QFilter("number", "=", (Object)code);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bastax_supervision", (String)"id", (QFilter[])new QFilter[]{f});
        if (dyns.length > 0) {
            return dyns[0].getLong("id");
        }
        return 0L;
    }

    public static Long getGoods(Date sbrq, String code) {
        QFilter f = new QFilter("number", "=", (Object)code);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bastax_hscode", (String)"id,startdate,enddate", (QFilter[])new QFilter[]{f});
        if (dyns.length > 0) {
            if (sbrq != null) {
                for (DynamicObject dyn : dyns) {
                    Date start = dyn.getDate("startdate");
                    Date end = dyn.getDate("enddate");
                    if (start == null || end == null || sbrq.before(start) || sbrq.after(end)) continue;
                    return dyn.getLong("id");
                }
            }
            return dyns[0].getLong("id");
        }
        return 0L;
    }
}

