/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.integration.supplier.dzka.api;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.RSAUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.tdm.business.integration.helper.SupplierSettingHelper;
import kd.taxc.tdm.business.integration.supplier.dzka.bean.TokenInfo;
import kd.taxc.tdm.business.integration.supplier.dzka.helper.DzkaHelper;

public class DzkaApi {
    private static Log logger = LogFactory.getLog(DzkaApi.class);

    public static TaxResult<TokenInfo> getToken(String nsrsbh, String nsrmc) {
        String[] business = new String[]{"BSC/BSCSJB/BSCSJB_9"};
        String token = DzkaApi.getRequestToken(nsrsbh, nsrmc, business);
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("token", token);
        String repStr = DzkaApi.iscRequest(JSON.toJSONString(params), "kd_taxc_dzka_token");
        return DzkaHelper.parseFromTokenRep(repStr);
    }

    private static String getRequestToken(String nsrsbh, String nsrmc, String[] business) {
        String senderId = SupplierSettingHelper.getSetting("DZKA_SENDERID");
        String userId = nsrsbh;
        String userName = nsrmc;
        JWTCreator.Builder jwt = JWT.create();
        jwt.withClaim("senderId", senderId);
        jwt.withClaim("orgCode", nsrsbh);
        jwt.withClaim("entName", nsrmc);
        jwt.withClaim("userId", userId);
        jwt.withClaim("userName", userName);
        jwt.withArrayClaim("businessList", business);
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        c.add(12, 3);
        Date exp = c.getTime();
        jwt.withExpiresAt(exp);
        jwt.withIssuedAt(now);
        String publicKeyStr = SupplierSettingHelper.getSetting("DZKA_KD_PUBLICK_KEY", true);
        String privateKeyStr = SupplierSettingHelper.getSetting("DZKA_KD_PRIVATE_KEY", true);
        String token = null;
        try {
            RSAPublicKey publicKey = (RSAPublicKey)RSAUtils.getPublicKey((byte[])Base64.getDecoder().decode(publicKeyStr));
            RSAPrivateKey privateKey = (RSAPrivateKey)RSAUtils.getPrivateKey((byte[])Base64.getDecoder().decode(privateKeyStr));
            token = jwt.sign(Algorithm.RSA512((RSAPublicKey)publicKey, (RSAPrivateKey)privateKey));
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u5357\u65b9\u7535\u5b50\u53e3\u5cb8\u79d8\u94a5\u52a0\u7b7e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u79d8\u94a5\u662f\u5426\u8bbe\u7f6e\u6b63\u786e\u3002", (String)"DzkaApi_0", (String)"taxc-tdm-business", (Object[])new Object[0]));
        }
        return token;
    }

    private static String iscRequest(String jsonBody, String code) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("jsonbody", jsonBody);
        Object result = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscApicService", (String)"invokeScriptApi2", (Object[])new Object[]{code, param, "taxc-tsate"});
        return result.toString();
    }
}

