/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.integration.supplier.dzka.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.RSAUtils;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tdm.business.integration.constant.SupplierEnum;
import kd.taxc.tdm.business.integration.function.bgd.BgdHelper;
import kd.taxc.tdm.business.integration.helper.BwSettingHelper;
import kd.taxc.tdm.business.integration.helper.SupplierSettingHelper;
import kd.taxc.tdm.common.util.DateUtils;
import kd.taxc.tdm.common.util.ExceptionUtil;
import kd.taxc.tdm.common.util.RsaUtil;
import kd.taxc.tdm.common.util.XmlUtil;
import kd.taxc.tdm.common.util.velocity.VmTemplateUtils;

@ApiController(value="dzka", desc="\u7535\u5b50\u53e3\u5cb8")
public class DzkaPushPlugin {
    private static Log logger = LogFactory.getLog(DzkaPushPlugin.class);

    @ApiPostMapping(value="/dzka/push")
    public CustomApiResult<String> pushData(@ApiParam(value="data") @ApiParam(value="data") String data) {
        CustomApiResult result = new CustomApiResult();
        result.setData((Object)"ok");
        result.setStatus(true);
        result.setErrorCode("00");
        StringBuilder executionInfo = new StringBuilder();
        try {
            String decodeData = new String(this.getBw(data), "UTF-8");
            this.saveBgd(decodeData, executionInfo);
            this.saveLog(decodeData);
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.toString((Exception)e));
            result.setData((Object)"fail");
            result.setStatus(false);
            if (e instanceof KDBizException) {
                result.setErrorCode("01");
                result.setMessage(e.getMessage());
            }
            result.setErrorCode("09");
            result.setMessage("system erro");
        }
        return result;
    }

    private boolean saveLog(String bgdDatas) {
        List<String> descrList = this.bgdDescr(bgdDatas);
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(descrList.size());
        for (String descr : descrList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tctb_task_monitor");
            dynamicObject.set("taskdefine", (Object)"3GLAW3/FQANH");
            dynamicObject.set("dispatchtime", (Object)new Date());
            dynamicObject.set("starttime", (Object)new Date());
            dynamicObject.set("endtime", (Object)new Date());
            dynamicObject.set("executetype", (Object)"1");
            dynamicObject.set("progress", (Object)"100");
            dynamicObject.set("status", (Object)"COMPLETED");
            dynamicObject.set("operater", (Object)1L);
            dynamicObject.set("executedetail", (Object)descr);
            dynamicObject.set("createdate", (Object)new Date());
            dynamicObject.set("modifydate", (Object)new Date());
            dyns.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])dyns.toArray(new DynamicObject[0]));
        return true;
    }

    private byte[] getBw(String dzkaEncodeData) {
        try {
            byte[] datas = Base64.getDecoder().decode(dzkaEncodeData);
            String keyStr = SupplierSettingHelper.getSetting("DZKA_KD_PRIVATE_KEY", true);
            byte[] keyBytes = Base64.getDecoder().decode(keyStr);
            PrivateKey key = RSAUtils.getPrivateKey((byte[])keyBytes);
            byte[] deData = RsaUtil.decrypt((byte[])datas, (PrivateKey)key);
            return deData;
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.toString((Exception)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u7535\u5b50\u62a5\u5173\u5355\u6570\u636e\u89e3\u5bc6\u5931\u8d25", (String)"DzkaPushPlugin_1", (String)"taxc-tdm-business", (Object[])new Object[0]));
        }
    }

    private boolean saveBgd(String dzkaDecodeData, StringBuilder executionInfo) {
        List<Map<String, Object>> map;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("bgds", JSON.parseArray((String)dzkaDecodeData));
            map = this.transferData(params);
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.toString((Exception)e));
            executionInfo.append(ResManager.loadKDString((String)"\u62a5\u5173\u5355\u89e3\u6790\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458", (String)"DzkaPushPlugin_2", (String)"taxc-tdm-business", (Object[])new Object[0]));
            return false;
        }
        this.extralDeal(map, executionInfo);
        return this.saveBgds(map, executionInfo);
    }

    private List<String> bgdDescr(String dzkaBgdsData) {
        ArrayList<String> list = new ArrayList<String>(8);
        JSONArray jArray = JSON.parseArray((String)dzkaBgdsData);
        for (int i = 0; i < jArray.size(); ++i) {
            StringBuilder sb = new StringBuilder();
            JSONObject j = jArray.getJSONObject(i);
            sb.append(j.get((Object)"ownerName")).append(j.get((Object)"ownerCode")).append(ResManager.loadKDString((String)"-\u62a5\u5173\u5355\u53f7", (String)"DzkaPushPlugin_3", (String)"taxc-tdm-business", (Object[])new Object[0])).append(j.get((Object)"seqNo"));
            list.add(sb.toString());
        }
        return list;
    }

    private List<Map<String, Object>> transferData(Map<String, Object> map) {
        String templateContent = BwSettingHelper.getBw("dzka/gbd.vm");
        String name = "bgd";
        StringBuilder data = VmTemplateUtils.generateFromTemplate((String)templateContent, (String)name, map);
        List list = (List)XmlUtil.parseXmlString((String)data.toString());
        return list;
    }

    private boolean extralDeal(List<Map<String, Object>> list, StringBuilder executionInfo) {
        for (Map<String, Object> bgd : list) {
            this.dealBgds(bgd);
            List goodsList = (List)bgd.get("entryentity");
            if (goodsList == null) continue;
            for (Map goods : goodsList) {
                this.dealGoods(goods, bgd);
            }
        }
        return true;
    }

    private void dealBgds(Map<String, Object> bgdMap) {
        this.dealFilds(bgdMap, "declarationdate", bgdvalue -> DateUtils.stringToDate((String)((String)bgdvalue)));
        this.dealFilds(bgdMap, "org", bgdvalue -> BgdHelper.getOrg((String)bgdvalue));
        this.dealFilds(bgdMap, "consignor", bgdvalue -> BgdHelper.getOrg((String)bgdvalue));
        this.dealFilds(bgdMap, "consignee", bgdvalue -> BgdHelper.getCustomer((String)bgdvalue));
        this.dealFilds(bgdMap, "premiumcurrency", bgdvalue -> BgdHelper.getCurrency((String)bgdvalue));
        this.dealFilds(bgdMap, "sundrycurrency", bgdvalue -> BgdHelper.getCurrency((String)bgdvalue));
        this.dealFilds(bgdMap, "freightcurrency", bgdvalue -> BgdHelper.getCurrency((String)bgdvalue));
        this.dealFilds(bgdMap, "supervision", bgdvalue -> BgdHelper.getSupervision((String)bgdvalue));
    }

    private void dealGoods(Map<String, Object> goodsMap, Map<String, Object> bgdMap) {
        this.dealFilds(goodsMap, "firstunit", bgdvalue -> BgdHelper.getUnit(SupplierEnum.DZKA, (String)bgdvalue));
        this.dealFilds(goodsMap, "secondunit", bgdvalue -> BgdHelper.getUnit(SupplierEnum.DZKA, (String)bgdvalue));
        this.dealFilds(goodsMap, "tradeunit", bgdvalue -> BgdHelper.getUnit(SupplierEnum.DZKA, (String)bgdvalue));
        this.dealFilds(goodsMap, "tradecurrency", bgdvalue -> BgdHelper.getCurrency((String)bgdvalue));
        Date sbrq = (Date)bgdMap.get("declarationdate");
        this.dealFilds(goodsMap, "hscode", bgdvalue -> BgdHelper.getGoods(sbrq, (String)bgdvalue));
    }

    private void dealFilds(Map<String, Object> map, String key, Function fun) {
        Object dzbgdValue = map.get(key);
        Object kdValue = fun.apply(dzbgdValue);
        map.put(key, kdValue);
    }

    private boolean saveBgds(List<Map<String, Object>> list, StringBuilder executionInfo) {
        String code = "KD_ExportDeclarationUpdate(IERP-IERP)";
        Object[] params = new Object[]{code, list};
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"push", (Object[])params);
        return true;
    }
}

