/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.noise;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class NoiseBaseDataUpdService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(NoiseBaseDataUpdService.class);
    private static final String QUERY_SQL = "select a.fid as fid,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,forg,fmonth,fsourcenumber,fzyproduction,fzjstand,fyjstand,fnoisetime,ffbmonitor,ffbexc,foverlimit,fdayratio,fmulti,fnoiseratio,ftaxdepend,funittax,ftaxauthority,fsbbid,fdatasource from t_tdm_noise_info a left join t_tdm_noise_info_entry b on a.fid=b.fid where b.fid is null";
    private static final String QUERY_JG_SQL = "select fpfksszgswjg,fid from t_tcret_pollution_basedat where fid in (%s);";
    private static final String UPDATE_MAIN_SQL = "update t_tdm_noise_info set ftaxauthority = ? where fid = ?";
    private static final String INSERT_ENTRY_SQL = "INSERT INTO t_tdm_noise_info_entry (fid,fentryid,fseq,fzysd,fcbbzswt,fcbbzswtrate,flcyszycb,flcyszycbrate,fsm,fdwse,fjsyj,fynse,fbqyjse,fbqybtse,fjcfbs,fcbfbs) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List query = DBUtils.query((String)QUERY_SQL);
        if (EmptyCheckUtils.isNotEmpty((Object)query)) {
            String syids = query.stream().filter(a -> a.get("FSOURCENUMBER") != null).map(a -> a.get("FSOURCENUMBER").toString()).collect(Collectors.joining(","));
            HashMap jgMap = new HashMap();
            if (EmptyCheckUtils.isNotEmpty((Object)syids)) {
                List jgResults = DBUtils.query((String)String.format(QUERY_JG_SQL, syids));
                for (Map jgResult : jgResults) {
                    jgMap.put(jgResult.get("FID").toString(), jgResult.get("FPFKSSZGSWJG"));
                }
            }
            ArrayList<Object[]> updParamList = new ArrayList<Object[]>(16);
            ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(16);
            long[] ids = DB.genLongIds((String)"t_tdm_noise_info_entry", (int)query.size());
            for (int i = 0; i < query.size(); ++i) {
                Map row = (Map)query.get(i);
                Object fid = row.get("FID");
                Object fsourcenumber = row.get("FSOURCENUMBER");
                Integer ftaxauthority = fsourcenumber == null ? Integer.valueOf(0) : (jgMap.get(fsourcenumber.toString()) == null ? Integer.valueOf(0) : jgMap.get(fsourcenumber.toString()));
                updParamList.add(new Object[]{ftaxauthority, fid});
                long fentryid = ids[i];
                int fseq = 1;
                Object fzysd = row.get("FNOISETIME");
                Object fjcfbs = row.get("FFBMONITOR");
                Object fcbfbs = row.get("FFBEXC");
                Boolean fcbbzswt = "1".equals(row.get("FOVERLIMIT"));
                BigDecimal fcbbzswtrate = (BigDecimal)row.get("FDAYRATIO");
                Boolean flcyszycb = "1".equals(row.get("FMULTI"));
                BigDecimal flcyszycbrate = (BigDecimal)row.get("FNOISERATIO");
                Object fsm = row.get("FTAXDEPEND");
                BigDecimal fdwse = (BigDecimal)row.get("FUNITTAX");
                BigDecimal fjsyj = fcbbzswtrate.multiply(flcyszycbrate).setScale(2, RoundingMode.HALF_UP);
                BigDecimal fynse = fdwse.multiply(fjsyj).setScale(2, RoundingMode.HALF_UP);
                BigDecimal fbqyjse = BigDecimal.ZERO;
                BigDecimal fbqybtse = fynse.subtract(fbqyjse);
                insertParamList.add(new Object[]{fid, fentryid, fseq, fzysd, fcbbzswt, fcbbzswtrate, flcyszycb, flcyszycbrate, fsm, fdwse, fjsyj, fynse, fbqyjse, fbqybtse, fjcfbs, fcbfbs});
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(updParamList)) {
                        DBUtils.executeBatch((String)"taxc", (String)UPDATE_MAIN_SQL, updParamList);
                    }
                    if (EmptyCheckUtils.isNotEmpty(insertParamList)) {
                        DBUtils.executeBatch((String)"taxc", (String)INSERT_ENTRY_SQL, insertParamList);
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error(ERROR_INFO, t);
                    throw new RuntimeException(t);
                }
            }
        }
    }
}

