/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.noise;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.cal.FelService;
import kd.taxc.tdm.common.util.DateUtils;

public class NoiseCalcService {
    public static final HashSet<String> MAIN_FIELDS = Sets.newHashSet((Object[])new String[]{"zjstand", "yjstand"});
    private static final Map<String, String> exprMap = new HashMap<String, String>(16);
    private static final Map<String, List<String>> keyDependMap;

    public static Map<String, List<String>> getKeyDependMap() {
        return keyDependMap;
    }

    public static Map<String, String> getExprMap() {
        return exprMap;
    }

    public static final Object calcExpr(String expr) {
        return FelService.eval((String)expr, (boolean)true);
    }

    public static final ArrayList<String> getCalcKeys(String name) {
        Map<String, List<String>> keyDependMap = NoiseCalcService.getKeyDependMap();
        boolean hit = false;
        ArrayList<String> calKeys = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : keyDependMap.entrySet()) {
            if (entry.getValue().contains(name)) {
                hit = true;
                calKeys.add(entry.getKey());
                continue;
            }
            if (!hit) continue;
            calKeys.add(entry.getKey());
        }
        return calKeys;
    }

    public static final Set<String> getCalcDependKeys(ArrayList<String> calKeys) {
        Set<String> dependKyes = keyDependMap.entrySet().stream().filter(a -> calKeys.contains(a.getKey())).flatMap(b -> ((List)b.getValue()).stream()).collect(Collectors.toSet());
        return dependKyes;
    }

    public static HashMap<String, Object> calcExprByValueMap(ArrayList<String> calcKeys, HashMap<String, Object> valueMap, Date month) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        for (String calcKey : calcKeys) {
            if (!exprMap.containsKey(calcKey)) continue;
            if ("dwse".equals(calcKey)) {
                Number cbfbs = (Number)valueMap.get("cbfbs");
                if (cbfbs == null) continue;
                Object o = NoiseCalcService.calcDwse(month, cbfbs.intValue());
                resultMap.put(calcKey, o);
                valueMap.put(calcKey, o);
                continue;
            }
            String temp = exprMap.get(calcKey);
            List<String> depends = keyDependMap.get(calcKey);
            for (String depend : depends) {
                temp = temp.replace("[" + depend + "]", valueMap.get(depend) != null ? valueMap.get(depend).toString() : "0");
            }
            Object o = NoiseCalcService.calcExpr(temp);
            resultMap.put(calcKey, o);
            valueMap.put(calcKey, o);
        }
        return resultMap;
    }

    private static Object calcDwse(Date month, Integer cbfbs) {
        QFilter fstatus1;
        QFilter enddate;
        QFilter startdate;
        QFilter groupid;
        DynamicObjectCollection coll;
        QFilter f1 = new QFilter("number", "=", (Object)"zsse");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tcvat_assist_trees", (String)"id", (QFilter[])new QFilter[]{f1});
        if (null != dynamicObject && month != null && (coll = QueryServiceHelper.query((String)"tpo_tcvat_assist", (String)"name,number,entryentity.fvalue1 as fvalue1", (QFilter[])new QFilter[]{groupid = new QFilter("group", "=", (Object)dynamicObject.getLong("id")), startdate = new QFilter("entryentity.startdate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)month)), enddate = new QFilter("entryentity.enddate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)month)).or(QFilter.isNull((String)"entryentity.enddate")), fstatus1 = new QFilter("entryentity.fstatus1", "=", (Object)"1")})).size() > 0) {
            if (16 <= cbfbs) {
                return NoiseCalcService.getValue(coll, "zsse-006");
            }
            if (13 <= cbfbs) {
                return NoiseCalcService.getValue(coll, "zsse-005");
            }
            if (10 <= cbfbs) {
                return NoiseCalcService.getValue(coll, "zsse-004");
            }
            if (7 <= cbfbs) {
                return NoiseCalcService.getValue(coll, "zsse-003");
            }
            if (4 <= cbfbs) {
                return NoiseCalcService.getValue(coll, "zsse-002");
            }
            if (1 <= cbfbs) {
                return NoiseCalcService.getValue(coll, "zsse-001");
            }
        }
        return "0";
    }

    private static String getValue(DynamicObjectCollection coll, String number) {
        Optional<DynamicObject> assist = coll.stream().filter(c -> number.equals(c.getString("number"))).findFirst();
        if (assist.isPresent()) {
            DynamicObject object = assist.get();
            return object.getString("fvalue1");
        }
        return "0";
    }

    static {
        exprMap.put("cbfbs", "max(if('[zysd]'=='day', [jcfbs]-[zjstand], [jcfbs]-[yjstand]), 0)");
        exprMap.put("cbbzswtrate", "if([cbbzswt]==true, 0.5, 1.0)");
        exprMap.put("lcyszycbrate", "if([lcyszycb]==true, 2.0, 1.0)");
        exprMap.put("dwse", "if( [cbfbs] >= 1 && [cbfbs] <= 3, 350, if( [cbfbs] >= 4 && [cbfbs] <= 6, 700,if( [cbfbs] >= 7 && [cbfbs] <= 9, 1400 ,if( [cbfbs] >= 10 && [cbfbs] <= 12, 2800 ,if( [cbfbs] >= 13 && [cbfbs] <= 15, 5600,if( [cbfbs] >= 16, 11200,0))))))");
        exprMap.put("jsyj", "[lcyszycbrate]*[cbbzswtrate]");
        exprMap.put("ynse", "[dwse]*[jsyj]");
        exprMap.put("bqybtse", "[ynse]-[bqyjse]");
        keyDependMap = new LinkedHashMap<String, List<String>>(16);
        keyDependMap.put("cbfbs", Lists.newArrayList((Object[])new String[]{"zysd", "jcfbs", "zjstand", "yjstand"}));
        keyDependMap.put("cbbzswtrate", Lists.newArrayList((Object[])new String[]{"cbbzswt"}));
        keyDependMap.put("lcyszycbrate", Lists.newArrayList((Object[])new String[]{"lcyszycb"}));
        keyDependMap.put("sm", Lists.newArrayList((Object[])new String[]{"cbfbs"}));
        keyDependMap.put("dwse", Lists.newArrayList((Object[])new String[]{"cbfbs"}));
        keyDependMap.put("jsyj", Lists.newArrayList((Object[])new String[]{"cbbzswtrate", "lcyszycbrate"}));
        keyDependMap.put("ynse", Lists.newArrayList((Object[])new String[]{"dwse", "jsyj"}));
        keyDependMap.put("bqybtse", Lists.newArrayList((Object[])new String[]{"ynse", "bqyjse"}));
    }
}

