/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.realestateRevCost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tdm.business.realestateRevCost.CostItemDao;

public class CostItemBusiness {
    public static List<Map<String, Object>> PRESETDATA = new ArrayList<Map<String, Object>>();
    public static String[] copyField = new String[]{"number", "name", "status", "enable", "longnumber", "level", "isleaf", "parent", "ispreset"};

    public static DynamicObject[] queryCostItemDataCollection(List<Long> ids) {
        return CostItemDao.queryCostItemDataCollection(ids, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,ispreset,org");
    }

    public static DynamicObject[] queryCostItemsByFilter(List<QFilter> filterList, String selectProperties) {
        return CostItemDao.queryCostItemByFilter(filterList, StringUtils.isNotEmpty((String)selectProperties) ? selectProperties : "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,ispreset,org");
    }

    public static void presetCostItemData() {
        TaxResult allTaxOrgIdResult = TaxcOrgDataServiceHelper.queryAllTaxcOrgId();
        List allTaxOrgId = (List)allTaxOrgIdResult.getData();
        Set<Long> needPresetTaxOrgId = CostItemDao.queryNeedPresetTaxOrgId(allTaxOrgId);
        if (needPresetTaxOrgId != null && !needPresetTaxOrgId.isEmpty()) {
            int totalCount = needPresetTaxOrgId.size() * PRESETDATA.size();
            int count = 0;
            DynamicObject[] saveObjects = new DynamicObject[totalCount];
            for (Long orgId : needPresetTaxOrgId) {
                for (Map<String, Object> fieldMap : PRESETDATA) {
                    DynamicObject detailEntity = BusinessDataServiceHelper.newDynamicObject((String)"tdm_costitem");
                    for (Map.Entry<String, Object> fieldMapEntry : fieldMap.entrySet()) {
                        detailEntity.set(fieldMapEntry.getKey(), fieldMapEntry.getValue());
                    }
                    detailEntity.set("org", (Object)orgId);
                    saveObjects[count++] = detailEntity;
                }
            }
            SaveServiceHelper.save((DynamicObject[])saveObjects);
        }
    }

    public static void copyToOtherOrgs(Long srcOrg, List<Long> destOrgs) {
        if (srcOrg == null || destOrgs == null) {
            return;
        }
        destOrgs.remove(srcOrg);
        if (destOrgs.isEmpty()) {
            return;
        }
        StringBuilder errorSB = new StringBuilder();
        for (Long orgid : destOrgs) {
            QFilter deleteOpFilter = new QFilter("org", "=", (Object)orgid);
            ArrayList<QFilter> filterList1 = new ArrayList<QFilter>(10);
            filterList1.add(deleteOpFilter);
            DynamicObject[] needDeleteDatas = CostItemBusiness.queryCostItemsByFilter(filterList1, "id,org.id,org.name");
            if (needDeleteDatas == null || needDeleteDatas.length <= 0) continue;
            Object[] needDeteleIds = new Long[needDeleteDatas.length];
            int count = 0;
            for (DynamicObject deleteData : needDeleteDatas) {
                needDeteleIds[count] = deleteData.getLong("id");
                ++count;
            }
            DeleteServiceHelper deleteServiceHelper = new DeleteServiceHelper();
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("fromcopyto", "1");
            OperationResult operationResult = deleteServiceHelper.deleteOperate("tdm_costitem", needDeteleIds, operateOption);
            if (!operationResult.isSuccess()) {
                errorSB.append(needDeleteDatas[0].getDynamicObject("org").getString("name")).append(":\r\n");
                List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                for (IOperateInfo errorInfo : allErrorOrValidateInfo) {
                    errorSB.append(errorInfo.getMessage()).append("\r\n");
                }
            }
            if (errorSB.length() <= 0) continue;
            throw new KDBizException(errorSB.toString());
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)srcOrg);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(orgFilter);
        OperationResult oldCostItems = CostItemBusiness.queryCostItemsByFilter(filterList, null);
        if (((DynamicObject[])oldCostItems).length > 0) {
            Long currentUserId = RequestContext.get().getCurrUserId();
            for (Long destOrgId : destOrgs) {
                HashMap<Long, Long> idMap = new HashMap<Long, Long>(((DynamicObject[])oldCostItems).length);
                long[] ids = DB.genLongIds((String)"t_tdm_costitem", (int)((DynamicObject[])oldCostItems).length);
                int count = 0;
                for (OperationResult oldCostItem : oldCostItems) {
                    idMap.put(oldCostItem.getLong("id"), ids[count]);
                    oldCostItem.set("id", (Object)ids[count]);
                    ++count;
                }
                for (OperationResult costItem : oldCostItems) {
                    if (costItem.get("parent") == null) continue;
                    DynamicObject parent = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tdm_costitem"));
                    parent.set("id", idMap.get(costItem.getDynamicObject("parent").getLong("id")));
                    costItem.set("parent", (Object)parent);
                }
                DynamicObject[] newCostItems = new DynamicObject[((OperationResult)oldCostItems).length];
                for (int i = 0; i < ((OperationResult)oldCostItems).length; ++i) {
                    DynamicObject newCostItem = BusinessDataServiceHelper.newDynamicObject((String)"tdm_costitem");
                    CostItemBusiness.copyCostItem((DynamicObject)oldCostItems[i], newCostItem);
                    newCostItem.set("id", oldCostItems[i].get("id"));
                    newCostItem.set("masterid", oldCostItems[i].get("masterid"));
                    newCostItem.set("org", (Object)destOrgId);
                    newCostItem.set("creator", (Object)currentUserId);
                    newCostItems[i] = newCostItem;
                }
                SaveServiceHelper.save((DynamicObject[])newCostItems);
            }
        }
    }

    public static void copyCostItem(DynamicObject source, DynamicObject target) {
        for (String field : copyField) {
            target.set(field, source.get(field));
        }
    }

    static {
        HashMap<String, Object> LATcal001 = new HashMap<String, Object>();
        LATcal001.put("number", "LATcal001");
        LATcal001.put("longnumber", "LATcal001");
        LATcal001.put("name", ResManager.loadKDString((String)"\u571f\u5730\u6210\u672c", (String)"CostItemBusiness_0", (String)"taxc-tdm-business", (Object[])new Object[0]));
        LATcal001.put("status", "C");
        LATcal001.put("enable", "1");
        LATcal001.put("level", 1);
        LATcal001.put("isleaf", "1");
        LATcal001.put("ispreset", 1);
        HashMap<String, Object> LATcal002 = new HashMap<String, Object>();
        LATcal002.put("number", "LATcal002");
        LATcal002.put("longnumber", "LATcal002");
        LATcal002.put("name", ResManager.loadKDString((String)"\u623f\u5730\u4ea7\u5f00\u53d1\u6210\u672c", (String)"CostItemBusiness_1", (String)"taxc-tdm-business", (Object[])new Object[0]));
        LATcal002.put("status", "C");
        LATcal002.put("enable", "1");
        LATcal002.put("level", 1);
        LATcal002.put("isleaf", "1");
        LATcal002.put("ispreset", 1);
        HashMap<String, Object> LATcal003 = new HashMap<String, Object>();
        LATcal003.put("number", "LATcal003");
        LATcal003.put("longnumber", "LATcal003");
        LATcal003.put("name", ResManager.loadKDString((String)"\u623f\u5730\u4ea7\u5f00\u53d1\u8d39\u7528", (String)"CostItemBusiness_2", (String)"taxc-tdm-business", (Object[])new Object[0]));
        LATcal003.put("status", "C");
        LATcal003.put("enable", "1");
        LATcal003.put("level", 1);
        LATcal003.put("isleaf", "1");
        LATcal003.put("ispreset", 1);
        HashMap<String, Object> LATcal004 = new HashMap<String, Object>();
        LATcal004.put("number", "LATcal004");
        LATcal004.put("longnumber", "LATcal004");
        LATcal004.put("name", ResManager.loadKDString((String)"\u7a0e\u91d1", (String)"CostItemBusiness_3", (String)"taxc-tdm-business", (Object[])new Object[0]));
        LATcal004.put("status", "C");
        LATcal004.put("enable", "1");
        LATcal004.put("level", 1);
        LATcal004.put("isleaf", "1");
        LATcal004.put("ispreset", 1);
        PRESETDATA.add(LATcal001);
        PRESETDATA.add(LATcal002);
        PRESETDATA.add(LATcal003);
        PRESETDATA.add(LATcal004);
    }
}

