/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.realestateRevCost;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DevLandInfoBusiness {
    private static final String BASTAX_TAXPROJECT = "bastax_taxproject";
    private static final String BASTAX_STAGE = "bastax_stage";
    public static final String TDM_DEVELOP_LAND_INFO = "tdm_develop_land_info";

    public static List<Long> getPermOrgs(IFormView view) {
        TaxResult listTaxResult;
        List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"40", (boolean)false);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)view);
        if (!hasPermOrgResult.hasAllOrgPerm() && hasPermOrgResult.getHasPermOrgs().size() > 0) {
            orgIds = hasPermOrgResult.getHasPermOrgs();
        }
        HashSet set1 = (listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayer()).getData() != null ? new HashSet((Collection)listTaxResult.getData()) : new HashSet();
        HashSet set2 = orgIds != null ? new HashSet(orgIds) : new HashSet();
        Sets.SetView intersection = Sets.intersection(set1, set2);
        return new ArrayList<Long>((Collection<Long>)intersection);
    }

    public static Long queryFirstProjectByOrg(Long orgid) {
        QFilter taxorg = new QFilter("taxorg", "=", (Object)orgid);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter qFilter = new QFilter("group.number", "=", (Object)"001");
        DynamicObjectCollection query = QueryServiceHelper.query((String)BASTAX_TAXPROJECT, (String)"id", (QFilter[])new QFilter[]{taxorg, enable, status, qFilter}, (String)"number asc");
        return query.size() == 0 ? null : Long.valueOf(((DynamicObject)query.get(0)).getLong("id"));
    }

    public static BigDecimal queryRoomsByStage(Long stage) {
        QFilter qFilter = new QFilter("stage", "=", (Object)stage);
        DynamicObjectCollection incomeDraft = QueryServiceHelper.query((String)"bastax_room", (String)"id,roomno,name,building,area", (QFilter[])new QFilter[]{qFilter}, (String)"roomno asc");
        BigDecimal area = incomeDraft.stream().map(a -> a.getBigDecimal("area")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return area;
    }

    public static DynamicObjectCollection queryProjectByIds(ArrayList<Long> projectids) {
        QFilter taxorg = new QFilter("id", "in", projectids);
        DynamicObjectCollection query = QueryServiceHelper.query((String)BASTAX_TAXPROJECT, (String)"id,taxorg", (QFilter[])new QFilter[]{taxorg});
        return query;
    }

    public static DynamicObjectCollection queryStageByIds(ArrayList<Long> projectids) {
        QFilter taxorg = new QFilter("id", "in", projectids);
        DynamicObjectCollection query = QueryServiceHelper.query((String)BASTAX_STAGE, (String)"id,taxproject", (QFilter[])new QFilter[]{taxorg});
        return query;
    }

    public static boolean validPeriod(Long orgId, Date startDate) {
        String deadLine;
        if (orgId == null || startDate == null) {
            return true;
        }
        Date endDate = DateUtils.getLastDateOfMonth((Date)startDate);
        DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)orgId.toString(), (Date)startDate, (Date)endDate);
        String string = deadLine = dynamicObject != null ? dynamicObject.getString("deadLine") : null;
        if ("ajsb".equals(deadLine)) {
            int monthOfDate = DateUtils.getMonthOfDate((Date)startDate);
            return Arrays.asList(1, 4, 7, 10).contains(monthOfDate);
        }
        return true;
    }

    public static boolean isDeclared(Date skssqq, Long orgId, Boolean isCurrentPeriod) {
        if (skssqq == null || orgId == null) {
            return false;
        }
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("skssqq", ">=", (Object)skssqq);
        if (isCurrentPeriod.booleanValue()) {
            q2 = new QFilter("skssqq", "=", (Object)skssqq);
        }
        QFilter q3 = new QFilter("declarestatus", "=", (Object)"declared");
        QFilter q4 = new QFilter("type", "in", (Object)TaxTypeEnum.TCVAT.getTemplates());
        DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billstatus,declarestatus", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        return nsrxx != null && "declared".equals(nsrxx.getString("declarestatus"));
    }
}

