/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.taxsource;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tdm.business.datacompare.enums.AcctDepreChangeFieldEnum;
import kd.taxc.tdm.business.depreciation.AccountDepreciationChangeBusiness;

public class FcsTdsTaxsourceServiceHelper {
    public static DynamicObject findTdsTaxsource(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"tdm_tds_basic_info");
    }

    public static DynamicObject[] findTdsTaxsource(Object[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tdm_tds_basic_info"));
    }

    public static BigDecimal updateLandPlotRatio(Long houseId, BigDecimal area, DynamicObjectCollection houseentryentity, DynamicObjectCollection bgentryentity, BigDecimal landarea) {
        if (houseId != null) {
            houseentryentity.forEach(a -> {
                if (houseId.equals(a.getDynamicObject("housenumber").getLong("id"))) {
                    a.set("housearea", (Object)area);
                }
            });
        }
        return FcsTdsTaxsourceServiceHelper.updateLandPlotRatio(houseentryentity, bgentryentity, landarea);
    }

    public static BigDecimal updateLandPlotRatio(DynamicObjectCollection houseentryentity, DynamicObjectCollection bgentryentity, BigDecimal landarea) {
        BigDecimal sumHousearea = houseentryentity.stream().map(a -> a.getBigDecimal("housearea")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        if (bgentryentity.isEmpty()) {
            return BigDecimalUtil.divideObject((Object)sumHousearea, (Object)landarea, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)sumHousearea, (Object)landarea, (int)2);
        }
        List modifytimeList = bgentryentity.stream().sorted(Comparator.comparing(s -> s.getDate("bgmodifydate"))).collect(Collectors.toList());
        BigDecimal bgLandarea = ((DynamicObject)modifytimeList.get(0)).getBigDecimal("bglandarea");
        return BigDecimalUtil.divideObject((Object)sumHousearea, (Object)bgLandarea, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)sumHousearea, (Object)bgLandarea, (int)2);
    }

    public static BigDecimal updateLandUnitPrice(DynamicObjectCollection bgentryentity, BigDecimal price, BigDecimal usagerightamount, BigDecimal landdevcost, BigDecimal landarea) {
        BigDecimal add = price.add(usagerightamount).add(landdevcost);
        if (bgentryentity.isEmpty()) {
            return BigDecimalUtil.divideObject((Object)add, (Object)landarea, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)add, (Object)landarea, (int)2);
        }
        List modifytimeList = bgentryentity.stream().sorted(Comparator.comparing(s -> s.getDate("bgmodifydate"))).collect(Collectors.toList());
        BigDecimal bgLandarea = ((DynamicObject)modifytimeList.get(0)).getBigDecimal("bglandarea");
        return BigDecimalUtil.divideObject((Object)add, (Object)bgLandarea, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)add, (Object)bgLandarea, (int)2);
    }

    public static BigDecimal updateValue(DynamicObjectCollection houseentryentity, BigDecimal landplotratio, BigDecimal housearea, BigDecimal landunitprice, BigDecimal price) {
        if (landplotratio.compareTo(BigDecimal.valueOf(0.5)) < 0) {
            BigDecimal value = BigDecimalUtil.multiplyObject((Object)housearea.multiply(BigDecimal.valueOf(2L)), (Object)landunitprice, (int)2);
            return value;
        }
        BigDecimal sumHousearea = houseentryentity.stream().map(a -> a.getBigDecimal("housearea")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal value = BigDecimalUtil.divideObject((Object)price.multiply(housearea), (Object)sumHousearea, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)price.multiply(housearea), (Object)sumHousearea, (int)2);
        return value;
    }

    public static DynamicObject findFcsTaxsource(Long id) {
        DynamicObject fcsDynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tdm_fcs_basic_info"));
        return fcsDynamicObject;
    }

    public static DynamicObject[] findFcsTaxsource(Object[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tdm_fcs_basic_info"));
    }

    public static Map<Long, DynamicObject> findFcsTaxsource(DynamicObjectCollection houseentryentity) {
        List fcsIds = houseentryentity.stream().map(a -> a.getLong("housenumber.id")).collect(Collectors.toList());
        DynamicObject[] fcsDynamicObjects = BusinessDataServiceHelper.load((Object[])fcsIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tdm_fcs_basic_info"));
        Map<Long, DynamicObject> fcsMaps = Arrays.stream(fcsDynamicObjects).collect(Collectors.toMap(a -> a.getLong("id"), b -> b, (m, n) -> m));
        return fcsMaps;
    }

    public static String convert(List<DynamicObject> updateCollection, DynamicObject dynamicObject, BigDecimal value, Long tdsTaxsourceId) {
        if (dynamicObject != null) {
            boolean checkChangedate;
            Date date = new Date();
            DynamicObjectCollection bgentryentity = dynamicObject.getDynamicObjectCollection("bgentryentity");
            boolean checkAcquiredate = dynamicObject.getDate("acquiredate") != null && DateUtils.stringToDate2((String)DateUtils.format((Date)date, (String)"yyyy-MM"), (String)"yyyy-MM").after(DateUtils.stringToDate2((String)DateUtils.format((Date)dynamicObject.getDate("acquiredate"), (String)"yyyy-MM"), (String)"yyyy-MM"));
            boolean bl = checkChangedate = dynamicObject.getDate("changedate") == null || DateUtils.stringToDate2((String)DateUtils.format((Date)date, (String)"yyyy-MM"), (String)"yyyy-MM").before(DateUtils.stringToDate2((String)DateUtils.format((Date)dynamicObject.getDate("changedate"), (String)"yyyy-MM"), (String)"yyyy-MM"));
            if (!checkAcquiredate || !checkChangedate) {
                return String.format(ResManager.loadKDString((String)"\u623f\u4ea7\u7f16\u53f7\u3010%s\u3011\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u6570\u636e\u63a8\u9001\u5931\u8d25\uff0c\u201c\u53d8\u66f4\u767b\u8bb0\u53f0\u8d26\u201d\u53d8\u66f4\u65f6\u95f4\uff08\u5e74\u3001\u6708\uff09\u53ea\u80fd\u5927\u4e8e\u53d6\u5f97\u65f6\u95f4\uff0c\u6216\u5c0f\u4e8e\u7eb3\u7a0e\u4e49\u52a1\u7ec8\u6b62\u65f6\u95f4", (String)"FcsTdsTaxsourceServiceHelper_1", (String)"taxc-tdm-business", (Object[])new Object[0]), dynamicObject.getString("number"));
            }
            Optional<DynamicObject> lastentity = bgentryentity.stream().filter(a -> DateUtils.format((Date)a.getDate("bgdate"), (String)"yyyy-MM").equals(DateUtils.format((Date)date, (String)"yyyy-MM"))).findFirst();
            DynamicObject entity = null;
            if (CollectionUtils.isEmpty((Collection)bgentryentity)) {
                entity = bgentryentity.addNew();
                FcsTdsTaxsourceServiceHelper.setBgEntity(entity, dynamicObject.getBigDecimal("housevalue"), dynamicObject.getBigDecimal("equipmentvalue"), value, dynamicObject.getBigDecimal("hireassertvalue"));
                entity.set("bgtype", (Object)"ytrtdjz");
            } else if (lastentity.isPresent()) {
                entity = lastentity.get();
                FcsTdsTaxsourceServiceHelper.setBgEntity(entity, entity.getBigDecimal("bghousevalue"), entity.getBigDecimal("bgequipmentvalue"), value, entity.getBigDecimal("bghireassertvalue"));
                if (!entity.getString("bgtype").contains("ytrtdjz")) {
                    entity.set("bgtype", (Object)("ytrtdjz," + entity.getString("bgtype")));
                }
            } else {
                List modifytimeList = bgentryentity.stream().filter(s -> s.getDate("bgdate").before(date)).sorted(Comparator.comparing(s -> s.getDate("bgmodifydate"))).collect(Collectors.toList());
                entity = bgentryentity.addNew();
                if (modifytimeList.size() > 0) {
                    FcsTdsTaxsourceServiceHelper.setBgEntity(entity, ((DynamicObject)modifytimeList.get(0)).getBigDecimal("bghousevalue"), ((DynamicObject)modifytimeList.get(0)).getBigDecimal("bgequipmentvalue"), value, ((DynamicObject)modifytimeList.get(0)).getBigDecimal("bghireassertvalue"));
                } else {
                    FcsTdsTaxsourceServiceHelper.setBgEntity(entity, dynamicObject.getBigDecimal("housevalue"), dynamicObject.getBigDecimal("equipmentvalue"), value, dynamicObject.getBigDecimal("hireassertvalue"));
                }
                entity.set("bgtype", (Object)"ytrtdjz");
            }
            entity.set("datasource", (Object)"1");
            if (entity != null && entity.getBigDecimal("bgassertvalue").compareTo(entity.getBigDecimal("bghireassertvalue")) < 0) {
                return String.format(ResManager.loadKDString((String)"\u623f\u4ea7\u7f16\u53f7\u3010%s\u3011\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u6570\u636e\u63a8\u9001\u5931\u8d25\uff0c\u8c03\u6574\u540e\u7684\u623f\u5c4b\u539f\u503c\u3001\u623f\u5c4b\u9644\u5c5e\u8bbe\u5907\u53ca\u914d\u5957\u8bbe\u65bd\u4e0e\u5e94\u644a\u5165\u571f\u5730\u4ef7\u503c\u5408\u8ba1\u503c\u53ea\u80fd\u5927\u4e8e\u7b49\u4e8e\u53d8\u66f4\u540e\u51fa\u79df\u623f\u4ea7\u539f\u503c\uff08\u5143\uff09", (String)"FcsTdsTaxsourceServiceHelper_3", (String)"taxc-tdm-business", (Object[])new Object[0]), dynamicObject.getString("number"));
            }
            dynamicObject.set("landtaxsource", (Object)tdsTaxsourceId);
            updateCollection.add(dynamicObject);
            return null;
        }
        return null;
    }

    public static DynamicObject setBgEntity(DynamicObject entity, BigDecimal housevalue, BigDecimal equipmentvalue, BigDecimal value, BigDecimal hireassertvalue) {
        entity.set("bgdate", (Object)DateUtils.getLastDateOfMonth2((Date)new Date()));
        entity.set("bghousevalue", (Object)housevalue);
        entity.set("bgequipmentvalue", (Object)equipmentvalue);
        entity.set("bgvalue", (Object)value);
        entity.set("bgassertvalue", (Object)housevalue.add(equipmentvalue).add(value));
        entity.set("bghireassertvalue", (Object)hireassertvalue);
        entity.set("remark", (Object)ResManager.loadKDString((String)"\u644a\u5165\u571f\u5730\u4ef7\u503c\u53d8\u52a8", (String)"FcsTdsTaxsourceServiceHelper_2", (String)"taxc-tdm-business", (Object[])new Object[0]));
        entity.set("bgmodifier", (Object)RequestContext.get().getCurrUserId());
        entity.set("bgmodifydate", (Object)new Date());
        return entity;
    }

    public static Map<Long, BigDecimal> updateTdsFcsInfo(Long fcsId, StringBuilder message) {
        DynamicObject fcsDynamicObject = FcsTdsTaxsourceServiceHelper.findFcsTaxsource(fcsId);
        Map<Long, BigDecimal> valueMap = FcsTdsTaxsourceServiceHelper.updateTdsFcsInfo(message, fcsDynamicObject.getLong("landtaxsource.id"), fcsId, fcsDynamicObject.getBigDecimal("area"));
        return valueMap;
    }

    public static Map<Long, BigDecimal> updateTdsFcsInfo(StringBuilder stringBuilder, Long tdsId, Long houseId, BigDecimal area) {
        DynamicObject tdsDynamicObject;
        ArrayList<DynamicObject> updateCollection = new ArrayList<DynamicObject>();
        if (tdsId != null && 0L != tdsId && (tdsDynamicObject = FcsTdsTaxsourceServiceHelper.findTdsTaxsource(tdsId)) != null) {
            DynamicObjectCollection houseentryentity = tdsDynamicObject.getDynamicObjectCollection("houseentryentity");
            Map<Long, DynamicObject> fcsMaps = FcsTdsTaxsourceServiceHelper.findFcsTaxsource(houseentryentity);
            BigDecimal landplotratio = FcsTdsTaxsourceServiceHelper.updateLandPlotRatio(houseId, area, houseentryentity, tdsDynamicObject.getDynamicObjectCollection("bgentryentity"), tdsDynamicObject.getBigDecimal("landarea"));
            tdsDynamicObject.set("landplotratio", (Object)landplotratio);
            for (DynamicObject object : houseentryentity) {
                BigDecimal sumPrice = tdsDynamicObject.getBigDecimal("price").add(tdsDynamicObject.getBigDecimal("usagerightamount")).add(tdsDynamicObject.getBigDecimal("landdevcost"));
                BigDecimal value = FcsTdsTaxsourceServiceHelper.updateValue(houseentryentity, landplotratio, object.getBigDecimal("housearea"), tdsDynamicObject.getBigDecimal("landunitprice"), sumPrice);
                object.set("value", (Object)value);
                String msg = FcsTdsTaxsourceServiceHelper.convert(updateCollection, fcsMaps.get(object.getLong("housenumber.id")), value, tdsId);
                if (!StringUtil.isNotEmpty((CharSequence)msg)) continue;
                String tabLine = "\n";
                stringBuilder.append(msg).append(tabLine);
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tdsDynamicObject});
                    SaveServiceHelper.save((DynamicObject[])updateCollection.toArray(new DynamicObject[updateCollection.size()]));
                }
                catch (Exception e) {
                    h.markRollback();
                    throw new KDBizException((Throwable)e, new ErrorCode("FcsTdsTaxsourceServiceHelper", ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FcsTdsTaxsourceServiceHelper_0", (String)"taxc-tdm-business", (Object[])new Object[0])), new Object[0]);
                }
            }
            return houseentryentity.stream().collect(Collectors.toMap(a -> a.getLong("housenumber.id"), b -> b.getBigDecimal("value"), (m, n) -> m));
        }
        return new HashMap<Long, BigDecimal>();
    }

    public static void updateLandtaxsource(List<Long> updateHouseIdList) {
        DynamicObject[] dynamicObjects;
        for (DynamicObject object : dynamicObjects = BusinessDataServiceHelper.load((String)"tdm_fcs_basic_info", (String)"id,landtaxsource", (QFilter[])new QFilter[]{new QFilter("id", "in", updateHouseIdList)})) {
            object.set("landtaxsource", (Object)0L);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public static void sycnAssetdata() {
        QFilter periodFilter = new QFilter("accountingperiod", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date())).and(new QFilter("accountingperiod", "<=", (Object)DateUtils.getLastDateOfMonth((Date)new Date())));
        QFilter qFilter = new QFilter("entryentity.changefield", "=", (Object)AcctDepreChangeFieldEnum.ASSETORIVALUE.getFieldName());
        DynamicObjectCollection changeDataList = QueryServiceHelper.query((String)"tdm_accountdepre_change", (String)"id,org,assetcode,assetname,accountingperiod,preaccountdepreid,accountdepreid,entryentity,createdate,entryentity.seq,entryentity.changefield,entryentity.changefieldname,entryentity.oldvalue,entryentity.newvalue", (QFilter[])new QFilter[]{periodFilter, qFilter});
        ArrayList<Long> orgidList = new ArrayList<Long>(8);
        ArrayList<String> assetcodeList = new ArrayList<String>(8);
        HashMap<String, DynamicObject> tdsBasicMap = new HashMap<String, DynamicObject>(8);
        for (DynamicObject object : changeDataList) {
            orgidList.add(object.getLong("org"));
            assetcodeList.add(object.getString("assetcode"));
            long org = object.getLong("org");
            String assetcode = object.getString("assetcode");
            tdsBasicMap.put(FcsTdsTaxsourceServiceHelper.setKey(org, assetcode), object);
        }
        QFilter orgFilter = new QFilter("taxorg", "in", orgidList);
        QFilter assetcoedFilter = new QFilter("assetcode", "in", assetcodeList);
        DynamicObjectCollection assetdataList = QueryServiceHelper.query((String)"tdm_asset_data", (String)"id", (QFilter[])new QFilter[]{orgFilter, assetcoedFilter});
        List assetdataIds = assetdataList.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        DynamicObject[] fcsInfos = BusinessDataServiceHelper.load((String)"tdm_fcs_basic_info", (String)"bgentryentity,housevalue,equipmentvalue,value,assetdata,assertvalue,org,bgentryentity.bgdate,bgentryentity.bgassertvalue,bgentryentity.bghousevalue,bgentryentity.bgequipmentvalue,bgentryentity.bgvalue,bgentryentity.bghireassertvalue,bgentryentity.bgtype,bgentryentity.datasource,bgentryentity.remark,bgentryentity.bgmodifier,bgentryentity.bgmodifydate", (QFilter[])new QFilter[]{new QFilter("assetdata", "in", assetdataIds)});
        ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>(8);
        for (DynamicObject fcsInfo : fcsInfos) {
            DynamicObject assetdata = fcsInfo.getDynamicObject("assetdata");
            String assetcode = assetdata.getString("assetcode");
            DynamicObject taxorg = assetdata.getDynamicObject("taxorg");
            Long orgId = taxorg.getLong("id");
            DynamicObject changedFcsObj = (DynamicObject)tdsBasicMap.get(FcsTdsTaxsourceServiceHelper.setKey(orgId, assetcode));
            if (changedFcsObj == null) continue;
            FcsTdsTaxsourceServiceHelper.addEntity(Collections.singletonList(changedFcsObj), fcsInfo);
            updateData.add(fcsInfo);
        }
        if (!CollectionUtils.isEmpty(updateData)) {
            SaveServiceHelper.save((DynamicObject[])updateData.toArray(new DynamicObject[0]));
        }
    }

    public static void sycnAssetdata(List<Object> successPkIds) {
        DynamicObject[] selectAccounts = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tdm_fcs_basic_info"));
        HashMap<String, DynamicObject> tdsBasicMap = new HashMap<String, DynamicObject>(selectAccounts.length);
        ArrayList<Map<String, Object>> paramsList = new ArrayList<Map<String, Object>>(selectAccounts.length);
        for (DynamicObject selectAccount : selectAccounts) {
            FcsTdsTaxsourceServiceHelper.createParams(tdsBasicMap, paramsList, selectAccount);
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        List<DynamicObjectCollection> changeDataList = AccountDepreciationChangeBusiness.batchQueryChangeData(paramsList);
        ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>(8);
        FcsTdsTaxsourceServiceHelper.handleData(tdsBasicMap, changeDataList, updateData);
        if (!CollectionUtils.isEmpty(updateData)) {
            SaveServiceHelper.save((DynamicObject[])updateData.toArray(new DynamicObject[0]));
        }
    }

    private static void handleData(Map<String, DynamicObject> tdsBasicMap, List<DynamicObjectCollection> changeDataList, List<DynamicObject> updateData) {
        for (DynamicObjectCollection objects : changeDataList) {
            List<DynamicObject> collect;
            if (CollectionUtils.isEmpty((Collection)objects) || CollectionUtils.isEmpty(collect = objects.stream().filter(e -> AcctDepreChangeFieldEnum.ASSETORIVALUE.getFieldName().equals(e.getString("entryentity.changefield"))).collect(Collectors.toList()))) continue;
            DynamicObject object = (DynamicObject)collect.get(0);
            long org = object.getLong("org");
            String assetcode = object.getString("assetcode");
            DynamicObject fcsObj = tdsBasicMap.get(FcsTdsTaxsourceServiceHelper.setKey(org, assetcode));
            if (fcsObj == null) continue;
            FcsTdsTaxsourceServiceHelper.addEntity(collect, fcsObj);
            updateData.add(fcsObj);
        }
    }

    private static void createParams(Map<String, DynamicObject> tdsBasicMap, List<Map<String, Object>> paramsList, DynamicObject selectAccount) {
        Date startdate;
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(4);
        DynamicObject assetdata = selectAccount.getDynamicObject("assetdata");
        String assetcode = assetdata.getString("assetcode");
        DynamicObject taxorg = assetdata.getDynamicObject("taxorg");
        Long orgId = taxorg.getLong("id");
        DynamicObjectCollection bgentryentity = selectAccount.getDynamicObjectCollection("bgentryentity");
        Date enddate = new Date();
        Date changedate = selectAccount.getDate("changedate");
        if (changedate != null && DateUtils.addMonth((Date)changedate, (int)-1).compareTo(enddate) < 0) {
            enddate = DateUtils.addMonth((Date)changedate, (int)-1);
        }
        if (CollectionUtils.isEmpty((Collection)bgentryentity)) {
            startdate = selectAccount.getDate("acquiredate");
        } else {
            Optional<DynamicObject> bgdate = bgentryentity.stream().max(Comparator.comparing(a -> a.getDate("bgdate")));
            if (bgdate.isPresent()) {
                Date bgdate1 = bgdate.get().getDate("bgdate");
                startdate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)bgdate1, (int)1));
                if (startdate.compareTo(enddate) > 0) {
                    return;
                }
            } else {
                return;
            }
        }
        paramsMap.put("orgId", orgId);
        paramsMap.put("assetcode", assetcode);
        paramsMap.put("startdate", startdate);
        paramsMap.put("enddate", enddate);
        paramsList.add(paramsMap);
        tdsBasicMap.put(FcsTdsTaxsourceServiceHelper.setKey(orgId, assetcode), selectAccount);
    }

    private static void addEntity(List<DynamicObject> collect, DynamicObject fcsObj) {
        DynamicObjectCollection bgentryentity = fcsObj.getDynamicObjectCollection("bgentryentity");
        Boolean assertvalueform = (Boolean)SystemParamUtil.getAppParameter((String)"tcret", (String)"assertvalueform", (long)fcsObj.getDynamicObject("org").getLong("id"));
        if (CollectionUtils.isEmpty((Collection)bgentryentity)) {
            BigDecimal assertvalue = fcsObj.getBigDecimal("assertvalue");
            BigDecimal housevalue = fcsObj.getBigDecimal("housevalue");
            BigDecimal equipmentvalue = fcsObj.getBigDecimal("equipmentvalue");
            BigDecimal ytrtvalue = fcsObj.getBigDecimal("value");
            BigDecimal bghireassertvalue = BigDecimal.ZERO;
            if (assertvalueform == null || !assertvalueform.booleanValue() && (housevalue == null || BigDecimal.ZERO.compareTo(housevalue) == 0)) {
                housevalue = assertvalue;
            }
            FcsTdsTaxsourceServiceHelper.addEntity(collect, bgentryentity, housevalue, equipmentvalue, ytrtvalue, bghireassertvalue);
        } else {
            Optional<DynamicObject> bgdateOpt = bgentryentity.stream().max(Comparator.comparing(a -> a.getDate("bgdate")));
            if (bgdateOpt.isPresent()) {
                DynamicObject bgObj = bgdateOpt.get();
                BigDecimal bgassertvalue = bgObj.getBigDecimal("bgassertvalue");
                BigDecimal bghousevalue = bgObj.getBigDecimal("bghousevalue");
                BigDecimal equipmentvalue = bgObj.getBigDecimal("bgequipmentvalue");
                BigDecimal ytrtvalue = bgObj.getBigDecimal("bgvalue");
                BigDecimal bghireassertvalue = bgObj.getBigDecimal("bghireassertvalue");
                if (!(assertvalueform != null && assertvalueform.booleanValue() || bghousevalue != null && BigDecimal.ZERO.compareTo(bgassertvalue) != 0)) {
                    bghousevalue = bgassertvalue;
                }
                FcsTdsTaxsourceServiceHelper.addEntity(collect, bgentryentity, bghousevalue, equipmentvalue, ytrtvalue, bghireassertvalue);
            }
        }
    }

    private static void addEntity(List<DynamicObject> bgdate, DynamicObjectCollection bgentryentity, BigDecimal housevalue, BigDecimal equipmentvalue, BigDecimal ytrtvalue, BigDecimal bghireassertvalue) {
        List sortBgdata = bgdate.stream().sorted(Comparator.comparing(a -> a.getDate("accountingperiod"))).collect(Collectors.toList());
        boolean existChanged = true;
        for (DynamicObject object : sortBgdata) {
            BigDecimal newvalue = new BigDecimal(object.getString("entryentity.newvalue"));
            if (existChanged && housevalue.compareTo(newvalue) == 0) continue;
            existChanged = false;
            DynamicObject object1 = bgentryentity.addNew();
            object1.set("bgdate", (Object)DateUtils.getLastDateOfMonth((Date)object.getDate("accountingperiod")));
            object1.set("bgtype", (Object)"fcyz");
            object1.set("bghousevalue", (Object)newvalue);
            object1.set("bgequipmentvalue", (Object)equipmentvalue);
            object1.set("bgvalue", (Object)ytrtvalue);
            object1.set("bgassertvalue", (Object)newvalue.add(equipmentvalue).add(ytrtvalue));
            object1.set("bghireassertvalue", (Object)bghireassertvalue);
            object1.set("datasource", (Object)"1");
            object1.set("remark", (Object)ResManager.loadKDString((String)"\u8d44\u4ea7\u4fe1\u606f\u53d8\u52a8", (String)"FcsTdsTaxsourceServiceHelper_4", (String)"taxc-tdm-business", (Object[])new Object[0]));
        }
    }

    private static String setKey(Long orgId, String assetcode) {
        return orgId + assetcode;
    }
}

