/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.business.yhgl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.BaseRowModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.file.ExportExcelUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TsqtReductService {
    private static final Log logger = LogFactory.getLog(TsqtReductService.class);
    public static final String ENTRY_NAME = "tdm_tsqt_reduct";
    public static final String TSXX_DIALOG = "tdm_tsqtxx_dialog";
    public static final String SPECIAL_GROUP = "tdm_special_group";

    public String checkData(DynamicObject dyo) {
        return null;
    }

    public boolean validDate(Date startDate, Date endDate) {
        if (ObjectUtils.anyNull((Object[])new Object[]{startDate, endDate})) {
            return true;
        }
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)endDate);
        Date lastDateOfMonth2 = DateUtils.getLastDateOfMonth2((Date)startDate);
        return startDate.compareTo(firstDateOfMonth) == 0 && endDate.compareTo(lastDateOfMonth2) == 0;
    }

    public List<Long> queryOrgIdsWithPerm(long userId, String appid, String entityid) {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)userId, (String)appid, (String)entityid, (String)"47150e89000000ac");
        if (taxResult.isSuccess()) {
            return (List)taxResult.getData();
        }
        return Collections.emptyList();
    }

    public List<Long> queryOrgIdsWithPermWithoutSubOrg(long userId, String appid, String entityid) {
        List<Long> orgIds = this.queryOrgIdsWithPerm(userId, appid, entityid);
        if (CollectionUtils.isNotEmpty(orgIds)) {
            Date now = new Date();
            List subOrgIds = OrgUtils.filterOrgGroupSubOrg(orgIds, (String)"zzs", (Date)now, (Date)now);
            if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
                orgIds.removeIf(subOrgIds::contains);
            }
            return orgIds;
        }
        return Collections.emptyList();
    }

    public DynamicObject[] loadSpecialGroupData(List<Long> ids) {
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)SPECIAL_GROUP));
    }

    public String queryMaxBndycjyfs(Long specialGroupId, Long mainId) {
        return this.queryMaxBndycjyfs(specialGroupId, null, mainId);
    }

    public String queryMaxBndycjyfs(Long specialGroupId, String workYear, Long mainId) {
        DynamicObjectCollection query;
        QFilter filter = new QFilter("entryentity.specialid", "=", (Object)specialGroupId);
        if (mainId != null && mainId != 0L) {
            filter.and(new QFilter("id", "!=", (Object)mainId));
        }
        if (StringUtils.isNotBlank((CharSequence)workYear)) {
            filter.and("entryentity.workyear", "=", (Object)workYear);
        }
        if (CollectionUtils.isNotEmpty((Collection)(query = QueryServiceHelper.query((String)ENTRY_NAME, (String)"entryentity.sjgzyfs as sjgzyfs", (QFilter[])new QFilter[]{filter}, (String)"entryentity.sjgzyfs desc")))) {
            return ((DynamicObject)query.get(0)).getString("sjgzyfs");
        }
        return "0";
    }

    public boolean sjgzyfsEditCheck(String staffname, String workyear, int sjgzyfs, Long mainId) {
        QFilter filter = new QFilter("entryentity.staffname", "=", (Object)staffname);
        filter.and(new QFilter("entryentity.workyear", "=", (Object)workyear));
        filter.and(new QFilter("entryentity.sjgzyfs", ">", (Object)sjgzyfs));
        filter.and(new QFilter("id", "!=", (Object)mainId));
        return QueryServiceHelper.exists((String)ENTRY_NAME, (QFilter[])new QFilter[]{filter});
    }

    public BigDecimal queryYcjjmed(Long specialGroupId, String workyear, Long mainId) {
        QFilter filter = new QFilter("entryentity.specialid", "=", (Object)specialGroupId);
        filter.and(new QFilter("entryentity.workyear", "=", (Object)workyear));
        filter.and(new QFilter("id", "!=", (Object)mainId));
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTRY_NAME, (String)"entryentity.bqkcjjmed as bqkcjjmed", (QFilter[])new QFilter[]{filter});
        return query.stream().map(o -> o.getBigDecimal("bqkcjjmed")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public List<Long> queryTsqtxxDialogIds(String orgId, Date startDate, String selectIds, String tsqttype) {
        Date now = new Date();
        List orgGroupIds = OrgUtils.getAuditOrgGroupDetails((Long)Long.valueOf(orgId), (String)"zzs", (Date)now, (Date)now);
        QFilter filter = CollectionUtils.isNotEmpty((Collection)orgGroupIds) ? new QFilter("org", "in", (Object)orgGroupIds) : new QFilter("org", "=", (Object)Long.parseLong(orgId));
        if ("zdqt".equals(tsqttype)) {
            filter.and(new QFilter("type", "in", Arrays.asList("2", "3")));
        } else if ("zzjytysb".equals(tsqttype)) {
            filter.and(new QFilter("type", "=", (Object)"1"));
        }
        filter.and(new QFilter("ssstartmonth", "<=", (Object)startDate));
        DynamicObjectCollection data = QueryServiceHelper.query((String)SPECIAL_GROUP, (String)"id,ssstartmonth,leavedate", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> ids = new ArrayList<Long>(data.size());
        int collectYear = DateUtils.getYearOfDate((Date)startDate);
        for (DynamicObject datum : data) {
            Date ssstartmonth = datum.getDate("ssstartmonth");
            Date d1 = DateUtils.addYear((Date)ssstartmonth, (int)3);
            int year = DateUtils.getYearOfDate((Date)(d1 = DateUtils.addMonth((Date)d1, (int)-1)));
            if (collectYear > year) continue;
            Date leavedate = datum.getDate("leavedate");
            if (leavedate == null) {
                ids.add(datum.getLong("id"));
                continue;
            }
            int leaveYear = DateUtils.getYearOfDate((Date)leavedate);
            if (collectYear != leaveYear) continue;
            ids.add(datum.getLong("id"));
        }
        if (StringUtils.isNotBlank((CharSequence)selectIds)) {
            Set selectedIdSet = Arrays.stream(selectIds.split(",")).map(Long::valueOf).collect(Collectors.toSet());
            ids.removeIf(selectedIdSet::contains);
        }
        return ids;
    }

    public int getBndkcjyfs(int collectYear, Date ssstartmonth, Date leavedate) {
        int bndkcjyfs;
        Date sb3 = DateUtils.addYear((Date)ssstartmonth, (int)3);
        sb3 = DateUtils.addMonth((Date)sb3, (int)-1);
        int sb3Year = DateUtils.getYearOfDate((Date)sb3);
        int sb3Month = DateUtils.getMonthOfDate((Date)sb3);
        int ssYear = DateUtils.getYearOfDate((Date)ssstartmonth);
        int ssMonth = DateUtils.getMonthOfDate((Date)ssstartmonth);
        if (ssYear == collectYear) {
            if (leavedate == null) {
                bndkcjyfs = 12 - ssMonth + 1;
            } else {
                int leaveMonth = DateUtils.getMonthOfDate((Date)leavedate);
                bndkcjyfs = leaveMonth - ssMonth + 1;
            }
        } else if (leavedate == null) {
            bndkcjyfs = sb3Year == collectYear ? sb3Month : 12;
        } else {
            int leaveMonth = DateUtils.getMonthOfDate((Date)leavedate);
            bndkcjyfs = sb3Year == collectYear ? Integer.min(leaveMonth, sb3Month) : leaveMonth;
        }
        return bndkcjyfs;
    }

    public int getSjgzyfs(Date startDate, Date ssstartmonth, Date leavedate) {
        int sjgzyfs;
        int collectYear = DateUtils.getYearOfDate((Date)startDate);
        int collectMonth = DateUtils.getMonthOfDate((Date)startDate);
        int ssYear = DateUtils.getYearOfDate((Date)ssstartmonth);
        int ssMonth = DateUtils.getMonthOfDate((Date)ssstartmonth);
        Date sb3 = DateUtils.addYear((Date)ssstartmonth, (int)3);
        sb3 = DateUtils.addMonth((Date)sb3, (int)-1);
        int sb3Year = DateUtils.getYearOfDate((Date)sb3);
        int sb3Month = DateUtils.getMonthOfDate((Date)sb3);
        if (ssYear == collectYear) {
            if (leavedate == null || DateUtils.getFirstDateOfMonth((Date)leavedate).compareTo(DateUtils.getFirstDateOfMonth((Date)startDate)) >= 0) {
                sjgzyfs = collectMonth - ssMonth + 1;
            } else {
                int leaveMonth = DateUtils.getMonthOfDate((Date)leavedate);
                sjgzyfs = leaveMonth - ssMonth + 1;
            }
        } else {
            sjgzyfs = leavedate == null ? (sb3Year == collectYear ? Integer.min(sb3Month, collectMonth) : collectMonth) : (sb3Year == collectYear ? Integer.min(sb3Month, DateUtils.getMonthOfDate((Date)leavedate)) : Integer.min(DateUtils.getMonthOfDate((Date)leavedate), collectMonth));
        }
        return sjgzyfs;
    }

    public Long defualtOrg(Long orgId, long userId, String appid, String entityid) {
        Date now;
        DynamicObject orgDeclarePlan;
        List<Long> orgIds = this.queryOrgIdsWithPerm(userId, appid, entityid);
        if (!orgIds.contains(orgId)) {
            orgId = null;
        }
        if ("tcvat".equals(appid) && orgId != null && (orgDeclarePlan = OrgUtils.getOrgDeclarePlan((Long)orgId, (Date)(now = new Date()), (Date)now)) != null) {
            DynamicObjectCollection orgrow = orgDeclarePlan.getDynamicObjectCollection("orgrow");
            for (DynamicObject object : orgrow) {
                Long orgid = object.getDynamicObject("orgid").getLong("id");
                if (!orgId.equals(orgid) || !"3".equals(object.getString("declaration"))) continue;
                orgId = null;
                break;
            }
        }
        return orgId;
    }

    public DynamicObject loadTsqtReduct(Long pkId) {
        return BusinessDataServiceHelper.loadSingle((Object)pkId, (String)ENTRY_NAME);
    }

    public Long queryTsqtReductId(Long orgId, Date startDate, Date endDate, String tsqttype) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter dateFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        QFilter filter = new QFilter("tsqttype", "=", (Object)tsqttype);
        DynamicObject object = QueryServiceHelper.queryOne((String)ENTRY_NAME, (String)"id", (QFilter[])new QFilter[]{orgFilter, dateFilter, filter});
        return object != null ? Long.valueOf(object.getLong("id")) : null;
    }

    public BigDecimal queryDekcbzje(Long orgId, Date startDate, String tsqttype) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter dateFilter = new QFilter("enddate", "<", (Object)startDate);
        QFilter filter = new QFilter("tsqttype", "=", (Object)tsqttype);
        DynamicObjectCollection object = QueryServiceHelper.query((String)ENTRY_NAME, (String)"dekcbzje", (QFilter[])new QFilter[]{orgFilter, dateFilter, filter}, (String)"startdate desc");
        return CollectionUtils.isNotEmpty((Collection)object) ? ((DynamicObject)object.get(0)).getBigDecimal("dekcbzje") : BigDecimal.ZERO;
    }

    public String exportSheet(Long pkId) {
        String urls;
        List data;
        File file;
        DynamicObject billData = this.loadTsqtReduct(pkId);
        if (billData == null) {
            return null;
        }
        String entryName = "entryentity";
        String pluginName = "kd.taxc.tdm.common.entity.TsqtZdqtInfoExportDto";
        if ("zzjytysb".equals(billData.getString("tsqttype"))) {
            pluginName = "kd.taxc.tdm.common.entity.TsqtZzjytysbInfoExportDto";
        }
        if ((file = ExportExcelUtils.exportExcelWithSheet(null, null, (List)(data = BeanUtils.dynamicToDto((String)pluginName, null, (DynamicObjectCollection)billData.getDynamicObjectCollection(entryName), null)), ((BaseRowModel)data.get(0)).getClass())) == null) {
            return null;
        }
        String fileName = billData.getString("billno") + billData.getString("org.name") + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSS");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)fis, 5000);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return urls;
    }
}

