/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.mservice.externalapi.constant;

import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.tdm.common.constant.MultiLangEnumBridge;

public enum ApiClassify {
    TAX(ApiType.ONE, "tax_api", new MultiLangEnumBridge("\u7a0e\u5c40\u5bf9\u63a5", "ApiClassify_0", "taxc-tdm-mservice")),
    ARCHIVE(ApiType.TWO, "archive_api", new MultiLangEnumBridge("\u7535\u5b50\u6863\u6848", "ApiClassify_1", "taxc-tdm-mservice"));

    private static final String hanlder_package_name = "kd.taxc.tdm.mservice.externalapi.handler";
    private static final String adapter_package_name = "kd.taxc.tdm.mservice.externalapi.adapter";
    private static final String validator_package_name = "kd.taxc.tdm.mservice.externalapi.validator";
    private ApiType apiType;
    private MultiLangEnumBridge apiName;
    private String apiPrefix;

    private ApiClassify(ApiType apiType, String apiPrefix, MultiLangEnumBridge apiName) {
        this.apiType = apiType;
        this.apiPrefix = apiPrefix;
        this.apiName = apiName;
    }

    public ApiType getApiType() {
        return this.apiType;
    }

    public void setApiType(ApiType apiType) {
        this.apiType = apiType;
    }

    public String getApiName() {
        return this.apiName.loadKDString();
    }

    public void setApiName(MultiLangEnumBridge apiName) {
        this.apiName = apiName;
    }

    public String getApiPrefix() {
        return this.apiPrefix;
    }

    public void setApiPrefix(String apiPrefix) {
        this.apiPrefix = apiPrefix;
    }

    public static String getInstanceNameByApiType(String apiType) {
        for (ApiClassify value : ApiClassify.values()) {
            if (!StringUtils.equals((CharSequence)value.getApiType().getType(), (CharSequence)apiType)) continue;
            return value.getApiType().getHandlerClassName();
        }
        return "";
    }

    public static String getAdapterNameByApiType(String apiType) {
        for (ApiClassify value : ApiClassify.values()) {
            if (!StringUtils.equals((CharSequence)value.getApiType().getType(), (CharSequence)apiType)) continue;
            return value.getApiType().getAdapterClassName();
        }
        return "";
    }

    public static String getValidatorNameByApiType(String apiType) {
        for (ApiClassify value : ApiClassify.values()) {
            if (!StringUtils.equals((CharSequence)value.getApiType().getType(), (CharSequence)apiType)) continue;
            return value.getApiType().getValidatorClassName();
        }
        return "";
    }

    public static String getApiPrefixByApiType(String apiType) {
        for (ApiClassify value : ApiClassify.values()) {
            if (!StringUtils.equals((CharSequence)value.getApiType().getType(), (CharSequence)apiType)) continue;
            return value.getApiPrefix();
        }
        return "";
    }

    public static String getTypeValue(ApiClassify apiType) {
        for (ApiClassify value : ApiClassify.values()) {
            if (value != apiType) continue;
            return value.getApiType().getType();
        }
        return "";
    }

    static enum ApiType {
        ONE("1", "kd.taxc.tdm.mservice.externalapi.handler.TaxApiHandler", "kd.taxc.tdm.mservice.externalapi.adapter.TaxApiAdapter", "kd.taxc.tdm.mservice.externalapi.validator.TaxApiValidator"),
        TWO("2", "kd.taxc.tdm.mservice.externalapi.handler.ArchiveApiHandler", "kd.taxc.tdm.mservice.externalapi.adapter.ArchiveApiAdapter", "kd.taxc.tdm.mservice.externalapi.validator.ArchiveApiValidator");

        private String type;
        private String handlerClassName;
        private String adapterClassName;
        private String validatorClassName;

        private ApiType(String type, String handlerClassName, String adapterClassName, String validatorClassName) {
            this.type = type;
            this.handlerClassName = handlerClassName;
            this.adapterClassName = adapterClassName;
            this.validatorClassName = validatorClassName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getHandlerClassName() {
            return this.handlerClassName;
        }

        public void setHandlerClassName(String handlerClassName) {
            this.handlerClassName = handlerClassName;
        }

        public String getAdapterClassName() {
            return this.adapterClassName;
        }

        public void setAdapterClassName(String adapterClassName) {
            this.adapterClassName = adapterClassName;
        }

        public String getValidatorClassName() {
            return this.validatorClassName;
        }

        public void setValidatorClassName(String validatorClassName) {
            this.validatorClassName = validatorClassName;
        }
    }
}

