/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.mservice.externalapi.handler;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.tdm.common.constant.RequestResult;
import kd.taxc.tdm.mservice.externalapi.adapter.AbstractApiAdapter;
import kd.taxc.tdm.mservice.externalapi.constant.ApiClassify;
import kd.taxc.tdm.mservice.externalapi.constant.ApiConstant;
import kd.taxc.tdm.mservice.externalapi.constant.ErrorCode;
import kd.taxc.tdm.mservice.externalapi.entity.ApiInputModel;
import kd.taxc.tdm.mservice.externalapi.entity.RequestMapping;
import kd.taxc.tdm.mservice.externalapi.factory.AdapterFactory;
import kd.taxc.tdm.mservice.externalapi.factory.ValidatorFactory;
import kd.taxc.tdm.mservice.externalapi.handler.ApiHandler;
import kd.taxc.tdm.mservice.externalapi.validator.AbstractApiValidator;

public abstract class AbstractApiHandler
implements ApiHandler {
    private static Log logger = LogFactory.getLog(AbstractApiAdapter.class);
    private static final boolean MOCK = false;

    protected RequestResult validateData(ApiInputModel apiInputModel) {
        AbstractApiValidator validator = ValidatorFactory.findValidator(apiInputModel.getApiType());
        return validator.validateData(apiInputModel.getInputParams());
    }

    @Override
    public abstract RequestResult handleRequest(ApiInputModel var1);

    private static AbstractApiAdapter findAdapter(String apiType) {
        return AdapterFactory.findAdapter(apiType);
    }

    private static RequestResult invokeApiTemplate(ApiInputModel apiInputModel) {
        RequestMapping requestMapping = apiInputModel.getRequestMapping();
        boolean enableSingleApiNumber = apiInputModel.getEnableSingleApiNumber();
        RequestResult lookupApi = AbstractApiHandler.lookupApiMapping(apiInputModel.getApiNumber(), apiInputModel.getApiType(), requestMapping, enableSingleApiNumber);
        if (!lookupApi.getSuccess()) {
            return lookupApi;
        }
        String apiNumber = (String)lookupApi.getData();
        Map<String, Object> requestMap = AbstractApiHandler.transform(apiInputModel.getInputParams(), requestMapping, enableSingleApiNumber);
        return AbstractApiHandler.invokeIscApiSink(apiInputModel.getApiClassify(), apiNumber, requestMap, apiInputModel.getCaller());
    }

    protected RequestResult handleApiTemplate(ApiInputModel apiInputModel) {
        AbstractApiAdapter apiAdapter = AbstractApiHandler.findAdapter(apiInputModel.getApiType());
        RequestResult invokeResult = AbstractApiHandler.invokeApiTemplate(apiInputModel);
        return apiAdapter.warpResponse(invokeResult);
    }

    private static RequestResult lookupApiMapping(String apiNumber, String apiType, RequestMapping requestMapping, boolean enableSingleApiNumber) {
        Map<String, String> apiMapping = ApiConstant.getApiMapping();
        String iscApiNumber = apiMapping.get(ApiClassify.getApiPrefixByApiType(apiType) + "_" + apiNumber);
        if (!enableSingleApiNumber) {
            iscApiNumber = apiMapping.get(ApiClassify.getApiPrefixByApiType(apiType) + "_" + apiNumber + "_" + requestMapping.getMethod().toLowerCase());
        }
        if (StringUtils.isBlank((CharSequence)iscApiNumber)) {
            return RequestResult.fail((String)ErrorCode.R0001.getName(), (String)ErrorCode.R0001.getCode());
        }
        return RequestResult.success((Object)iscApiNumber.toLowerCase());
    }

    private static Map<String, Object> transform(Map<String, Object> inputParams, RequestMapping requestMapping, boolean enableSingleApiNumber) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("inputParams", inputParams);
        request.put("requestMapping", JSON.parseObject((String)JSON.toJSONString((Object)requestMapping)));
        request.put("enableSingleApiNumber", enableSingleApiNumber);
        return request;
    }

    private static RequestResult invokeIscApiSink(String apiGroup, String apiNumber, Map<String, Object> params, String caller) {
        String cloudId = "isc";
        String appId = "iscb";
        String serviceName = "IscApicService";
        String methodName = StringUtils.equals((CharSequence)"1", (CharSequence)apiGroup) ? "invokeExternalApi2" : "invokeScriptApi2";
        try {
            Object data = DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{apiNumber, params, null});
            RequestResult success = RequestResult.success((Object)data);
            success.setErrorCode(ErrorCode.SUCCESS.getCode());
            return success;
        }
        catch (Exception e) {
            logger.error("service:" + cloudId + "," + appId + "," + serviceName + "," + methodName + "fail:" + e);
            RequestResult ex = RequestResult.ex((Throwable)e);
            ex.setErrorCode(ErrorCode.FAIL.getCode());
            return ex;
        }
    }

    protected String getVersion() {
        return "1.0";
    }
}

