/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.mservice.externalapi.trace;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tdm.mservice.externalapi.trace.AppParameterServiceHelper;
import kd.taxc.tdm.mservice.externalapi.trace.Caller;
import kd.taxc.tdm.mservice.externalapi.trace.D;
import kd.taxc.tdm.mservice.externalapi.trace.DefaultTraceOutput;
import kd.taxc.tdm.mservice.externalapi.trace.TraceItem;
import kd.taxc.tdm.mservice.externalapi.trace.TraceManager;
import kd.taxc.tdm.mservice.externalapi.trace.TraceOutput;
import kd.taxc.tdm.mservice.externalapi.trace.TraceTask;
import kd.taxc.tdm.mservice.externalapi.trace.TraceType;

public class TraceStack {
    private static Log logger = LogFactory.getLog(TraceStack.class);

    public static Object trace(Caller caller, TraceTask task) {
        long traceId = ((TraceOutput)DefaultTraceOutput.INSTANCE.get()).newId();
        return TraceStack.trace(caller, traceId, task);
    }

    public static Object trace(Caller caller, long traceId, TraceTask task) {
        if (TraceStack.isTraceEnabled()) {
            RequestContext ctx = RequestContext.get();
            String number = TraceManager.findBestEntryOfUnknownTrace() + (ctx == null ? "" : " - " + ctx.getUserName());
            return TraceManager.trace(traceId, caller.getType().name(), number, 0L, task);
        }
        return task.invoke();
    }

    public static void traceJob(long jobId, String title, TraceTask task) {
        long traceId = TraceStack.getTraceId(jobId);
        TraceManager.trace(traceId, TraceType.EXE_JOB.name(), title, jobId, task);
    }

    public static void traceMQ(String number, TraceTask task) {
        long traceId = ((TraceOutput)DefaultTraceOutput.INSTANCE.get()).newId();
        RequestContext ctx = RequestContext.get();
        number = number + (ctx == null ? "" : " - " + ctx.getUserName());
        TraceManager.trace(traceId, TraceType.MQ.name(), number, 0L, task);
    }

    public static Object traceCallback(String number, TraceTask task) {
        long traceId = ((TraceOutput)DefaultTraceOutput.INSTANCE.get()).newId();
        return TraceManager.trace(traceId, TraceType.CALLBACK.name(), number, 0L, task);
    }

    public static Object trace(TraceItem current, TraceTask task) {
        return TraceManager.trace(current, task);
    }

    public static TraceItem current() {
        return TraceManager.current();
    }

    public static Object run(TraceType type, DynamicObject runtime, TraceTask task) {
        String number = TraceStack.getNumber(runtime);
        long id = runtime.getLong("id");
        return TraceStack.run(type, number, id, task);
    }

    private static String getNumber(DynamicObject runtime) {
        String number = TraceStack.getNumber0(runtime);
        if (number == null) {
            number = runtime.getDataEntityType().getName() + "/" + runtime.get("id");
        }
        return number;
    }

    private static String getNumber0(DynamicObject runtime) {
        DataEntityPropertyCollection properties = runtime.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"number")) {
            return D.s(runtime.get("number"));
        }
        if (properties.containsKey((Object)"params")) {
            return D.s(runtime.get("params"));
        }
        if (properties.containsKey((Object)"msg_digest")) {
            return D.s(runtime.get("msg_digest"));
        }
        return null;
    }

    public static Object run(TraceType type, String number, long defId, TraceTask task) {
        return TraceManager.run(type.name(), number, defId, task);
    }

    public static boolean isTraceEnabled() {
        try {
            return "true".equals(AppParameterServiceHelper.getParameterFromCache("enable_trace"));
        }
        catch (Exception e) {
            logger.warn("failed to get 'enable_trace' parameter.", (Throwable)e);
            return true;
        }
    }

    public static boolean isHttpTraceEnabled() {
        try {
            return "true".equals(AppParameterServiceHelper.getParameterFromCache("enable_http_trace"));
        }
        catch (Exception e) {
            logger.warn("failed to get 'enable_http_trace' parameter.", (Throwable)e);
            return true;
        }
    }

    public static long getTraceId(long defId) {
        return TraceStack.isTraceEnabled() ? new DefaultTraceOutput().newId() : 0L;
    }
}

