/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.mservice.externalapi.util;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.tdm.common.constant.RequestResult;
import kd.taxc.tdm.common.util.EmptyCheckUtils;
import kd.taxc.tdm.mservice.externalapi.constant.ErrorCode;
import kd.taxc.tdm.mservice.externalapi.entity.ApiInputModel;
import kd.taxc.tdm.mservice.externalapi.entity.RequestMapping;

public class CheckApiParamUtil {
    public static RequestResult checkInput(String inputJson) {
        RequestResult requestResult = RequestResult.success(null);
        if (StringUtils.isBlank((CharSequence)inputJson)) {
            requestResult = RequestResult.fail((String)ErrorCode.P0001.getName(), (String)ErrorCode.P0001.getCode());
        }
        Map params = (Map)SerializationUtils.fromJsonString((String)inputJson, Map.class);
        requestResult.setData((Object)params);
        return requestResult;
    }

    public static RequestResult checkGeneralParams(Map<String, Object> inputParams) {
        if (StringUtils.isBlank(inputParams)) {
            return RequestResult.fail((String)ErrorCode.P0001.getName(), (String)ErrorCode.P0001.getCode());
        }
        ApiInputModel apiInputModel = (ApiInputModel)JSON.parseObject((String)JSON.toJSONString(inputParams), ApiInputModel.class);
        if (StringUtils.isBlank((CharSequence)apiInputModel.getApiType())) {
            return RequestResult.fail((String)ErrorCode.P0002.getName(), (String)ErrorCode.P0002.getCode());
        }
        if (StringUtils.isBlank((CharSequence)apiInputModel.getCaller())) {
            return RequestResult.fail((String)ErrorCode.P0003.getName(), (String)ErrorCode.P0003.getCode());
        }
        if (!apiInputModel.getEnableSingleApiNumber()) {
            RequestMapping requestMapping = apiInputModel.getRequestMapping();
            if (EmptyCheckUtils.isEmpty((Object)requestMapping) || EmptyCheckUtils.isEmpty((Object)requestMapping.getUrl()) || EmptyCheckUtils.isEmpty((Object)requestMapping.getMethod()) || EmptyCheckUtils.isEmpty(requestMapping.getHeaders())) {
                return RequestResult.fail((String)ErrorCode.P0004.getName(), (String)ErrorCode.P0004.getCode());
            }
            CheckApiParamUtil.fillDefaultValue(apiInputModel, requestMapping);
        }
        return RequestResult.success((Object)apiInputModel);
    }

    private static void fillDefaultValue(ApiInputModel apiInputModel, RequestMapping requestMapping) {
        Map<String, Object> cookies;
        String charset = requestMapping.getCharset();
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = StandardCharsets.UTF_8.name();
            requestMapping.setCharset(charset);
            apiInputModel.setRequestMapping(requestMapping);
        }
        if (EmptyCheckUtils.isEmpty(cookies = requestMapping.getCookies())) {
            cookies = Collections.emptyMap();
            requestMapping.setCookies(cookies);
            apiInputModel.setRequestMapping(requestMapping);
        }
    }
}

