/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.mservice.skill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.taxc.tdm.business.skill.TaxTdmSkillBusiness;
import kd.taxc.tdm.common.enums.TaxTdmSkillEnum;
import kd.taxc.tdm.common.util.EmptyCheckUtils;

public class TaxTdmSkillApi
implements ISkillRunnable {
    private static String SKILL_NUMBER = "sjcjjqr";

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        String skillNum = skillRunContext.getSkillNum();
        Date startTime = skillRunContext.getStartTime();
        Date endTime = skillRunContext.getEndTime();
        if (SKILL_NUMBER.equalsIgnoreCase(skillNum)) {
            ArrayList list = new ArrayList(4);
            for (TaxTdmSkillEnum target : TaxTdmSkillEnum.values()) {
                String number = target.getNumber();
                String value = this.getValueByNumber(number, startTime, endTime);
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("number", number);
                paramMap.put("name", target.getName());
                paramMap.put("valueType", target.getValueType());
                paramMap.put("value", String.valueOf(value));
                list.add(paramMap);
            }
            skillResult.setData(list);
        }
        skillResult.setDate(skillRunContext.getStartTime());
        skillResult.setTotalCount(this.getTotalCount(startTime, endTime));
        skillResult.setFailCount(Integer.valueOf(0));
        return skillResult;
    }

    private String getValueByNumber(String number, Date startTime, Date endTime) {
        switch (number) {
            case "dytbpzsl": {
                DataSet thisMonthRecording = TaxTdmSkillBusiness.queryThisMonthRecording();
                return EmptyCheckUtils.isEmpty((Object)thisMonthRecording) ? "0" : String.valueOf(thisMonthRecording.count("id", false));
            }
            case "dytbkmyebsl": {
                DataSet thisMonthBalance = TaxTdmSkillBusiness.querythisMonthBalance();
                return EmptyCheckUtils.isEmpty((Object)thisMonthBalance) ? "0" : String.valueOf(thisMonthBalance.splitByGroup(new String[]{"org", "accountbookstype", "accountyear", "accountperiod", "isadjust", "adjperi"}).length);
            }
            case "dytbzcqdsl": {
                DataSet thisMonthAsset = TaxTdmSkillBusiness.querythisMonthAsset();
                return EmptyCheckUtils.isEmpty((Object)thisMonthAsset) ? "0" : String.valueOf(thisMonthAsset.count("id", false));
            }
        }
        return "0";
    }

    private Integer getTotalCount(Date startTime, Date endTime) {
        int recordingCount = TaxTdmSkillBusiness.queryRecordingCount((Date)startTime, (Date)endTime);
        int balanceCount = TaxTdmSkillBusiness.queryBalanceCount((Date)startTime, (Date)endTime);
        int assetCount = TaxTdmSkillBusiness.queryAssetCount((Date)startTime, (Date)endTime);
        return recordingCount + balanceCount + assetCount;
    }
}

