/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.mservice.upgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.taxc.tdm.common.util.EmptyCheckUtils;

public abstract class BaseMergeUpgradeServiceImpl
implements IUpgradeService {
    protected static final Log logger = LogFactory.getLog(BaseMergeUpgradeServiceImpl.class);
    private static final int BATCH_EXEC_NUMS = 1000000;
    private static final int BATCH_INTERVAL = 3;
    private static final int THREAD_NUMS = 5;
    private static final int MAX_ERROR_TIMES = 3;
    protected UpgradeResult result;
    private static DBRoute route = DBRoute.of((String)"taxc");
    private String servicename = this.getServicename();

    protected boolean mergeDataTemplate() {
        boolean execResult;
        long beginTime = System.currentTimeMillis();
        Map<Integer, Object[]> params = this.getExecSqlParams(this.getSplitTablename(), "fid");
        String switchName = this.getSwitchName();
        logger.info(switchName + "\u83b7\u53d6\u5206\u6279\u7684\u8d77\u6b62id\u96c6\u5408\u8017\u8d39\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - beginTime));
        logger.info(switchName + "\u603b\u6279\u6b21\uff1a" + params.size());
        if (this.isIgnoreExecUpgrade(switchName)) {
            execResult = true;
        } else {
            if (EmptyCheckUtils.isEmpty(params)) {
                execResult = true;
            } else if (params.size() == 1) {
                DB.execute((DBRoute)route, (String)this.getSingleUpdateSql());
                execResult = true;
            } else {
                execResult = true;
            }
            logger.info(switchName + "\u603b\u6279\u6b21\u6267\u884c\u8017\u8d39\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - beginTime));
            if (execResult) {
                this.updateSwitch(switchName);
            }
        }
        return execResult;
    }

    public Map<Integer, Object[]> getExecSqlParams(String splitTablename, String idcol) {
        String countSql = "select count(1) as count,min(" + idcol + ") as minid,max(" + idcol + ") as maxid from " + splitTablename;
        long count = 0L;
        long minid = 0L;
        long maxid = 0L;
        try (DataSet countSet = DB.queryDataSet((String)this.servicename, (DBRoute)route, (String)countSql);){
            for (Row row : countSet) {
                count = row.getLong("count");
                if (count <= 0L) continue;
                minid = row.getLong("minid");
                maxid = row.getLong("maxid");
                break;
            }
        }
        if (count <= 0L) {
            return Collections.emptyMap();
        }
        if (count <= 1000000L) {
            return Collections.singletonMap(1, new Object[]{minid, maxid + 1L});
        }
        int batchs = new BigDecimal(count).divide(new BigDecimal(1000000), RoundingMode.CEILING).intValue();
        HashMap<Integer, Object[]> params = new HashMap<Integer, Object[]>(batchs);
        HashMap<Integer, Object[]> paramsReorder = new HashMap<Integer, Object[]>(batchs);
        long idFrom = minid;
        long idTo = 0L;
        String nextIdSql = "select top 1," + 1000000 + " " + idcol + " as id from " + splitTablename + " where " + idcol + " >= ?" + " order by " + idcol;
        for (int i = 1; i <= batchs; ++i) {
            Object[] param2 = new Object[4];
            if (i == batchs) {
                idTo = maxid + 1L;
            } else {
                try (DataSet nextIdtoSet = DB.queryDataSet((String)this.servicename, (DBRoute)route, (String)nextIdSql, (Object[])new Object[]{idFrom});){
                    if (nextIdtoSet.hasNext()) {
                        Row row = nextIdtoSet.next();
                        idTo = row.getLong("id");
                    }
                }
            }
            param2[0] = idFrom;
            param2[1] = idTo;
            param2[2] = idFrom;
            param2[3] = idTo;
            params.put(i, param2);
            idFrom = idTo;
        }
        StringBuilder paramBuilder = new StringBuilder(this.servicename).append(':');
        params.values().forEach(param -> paramBuilder.append(Arrays.toString(param)));
        logger.info(paramBuilder.toString());
        int index = 1;
        for (int i = 1; i <= 3; ++i) {
            for (int j = i; j <= batchs; j += 3) {
                Object[] param3 = (Object[])params.get(j);
                paramsReorder.put(index, param3);
                ++index;
            }
        }
        return paramsReorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeSplitSql(String splitUpdateSql, Map<Integer, Object[]> params) {
        int size = params.size();
        try (ThreadPool pool = null;){
            String tenantId = "Default";
            RequestContextInfo rci = RequestContextInfo.get();
            if (rci != null) {
                tenantId = rci.getTenantId();
            }
            String poolname = tenantId + '.' + this.servicename;
            pool = ThreadPools.newCachedThreadPool((String)poolname, (int)5, (int)10);
            HashSet<Integer> execIndexes = new HashSet<Integer>(5);
            int errtimes = 0;
            while (!params.isEmpty()) {
                if (errtimes >= 3) {
                    StringBuilder errlogBuilder = new StringBuilder(this.servicename).append(" error:");
                    params.values().forEach(param -> errlogBuilder.append(Arrays.toString(param)));
                    errlogBuilder.append(splitUpdateSql);
                    String errlog = errlogBuilder.toString();
                    this.result.setLog(errlog);
                    this.result.setErrorInfo(errlog);
                    logger.error(errlog);
                    boolean bl = false;
                    return bl;
                }
                execIndexes.clear();
                int firstIndex = 0;
                for (int i = 1; i <= 2; ++i) {
                    for (int j = 1; j <= size && (i != 2 || j < firstIndex); ++j) {
                        if (params.containsKey(j)) {
                            if (firstIndex == 0) {
                                firstIndex = j;
                            }
                            execIndexes.add(j);
                        }
                        if (execIndexes.size() != 5) continue;
                        this.concurrentHandleSql(pool, splitUpdateSql, params, execIndexes);
                        execIndexes.clear();
                        firstIndex = 0;
                    }
                }
                if (execIndexes.size() > 0) {
                    this.concurrentHandleSql(pool, splitUpdateSql, params, execIndexes);
                }
                ++errtimes;
            }
            boolean bl = true;
            return bl;
        }
    }

    private void concurrentHandleSql(ThreadPool pool, final String sql, Map<Integer, Object[]> params, Set<Integer> execIndexes) {
        HashMap<Integer, Future> execFutureMap = new HashMap<Integer, Future>(5);
        Iterator<Object> iterator = execIndexes.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            final Object[] param = params.get(n);
            Future future = pool.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    StringBuilder execBuilder = new StringBuilder(BaseMergeUpgradeServiceImpl.this.servicename).append(" exec:").append(Arrays.toString(param)).append(sql);
                    long beginTime = System.currentTimeMillis();
                    logger.info(execBuilder.toString());
                    DB.execute((DBRoute)route, (String)sql, (Object[])param);
                    logger.info("\u5355\u6279\u6267\u884c\u7684\u8017\u8d39\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - beginTime));
                    return true;
                }
            });
            execFutureMap.put(n, future);
        }
        for (Map.Entry entry : execFutureMap.entrySet()) {
            int index = (Integer)entry.getKey();
            try {
                if (!((Boolean)((Future)entry.getValue()).get()).booleanValue()) continue;
                params.remove(index);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.info(e.toString());
                for (StackTraceElement trace : e.getStackTrace()) {
                    logger.info(trace.toString());
                }
            }
        }
    }

    public boolean isIgnoreExecUpgrade(String switchname) {
        boolean flag = false;
        return flag;
    }

    public void updateSwitch(String switchname) {
    }

    protected String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }

    protected abstract String getSplitTablename();

    protected abstract String getSwitchName();

    protected abstract String getSingleUpdateSql();

    protected abstract String getSplitUpdateSql();

    protected abstract String getServicename();
}

