/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.mservice.upgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.tdm.mservice.upgrade.BaseMergeUpgradeServiceImpl;

public class RecordingUpgradeServiceImpl
extends BaseMergeUpgradeServiceImpl {
    protected static final Log logger = LogFactory.getLog(RecordingUpgradeServiceImpl.class);
    private static final int BATCH_EXEC_NUMS = 1000000;
    private static final int BATCH_INTERVAL = 3;
    private static DBRoute route = DBRoute.of((String)"taxc");
    private String servicename = this.getServicename();
    private static final String SINGLE_UPDATE_SQL = "UPDATE t_tdm_recordingvoucher t  SET FNOWRITEOFF = FCREDITLOCALCURRENCY + FDEBITLOCALCURRENCY  WHERE fnowriteoff = 0 and fwriteoff = 0 ";
    private static final String SPLIT_UPDATE_SQL = "UPDATE t_tdm_recordingvoucher t  SET FNOWRITEOFF = FCREDITLOCALCURRENCY + FDEBITLOCALCURRENCY  WHERE fid >= ? and fid < ? and fnowriteoff = 0 and fwriteoff = 0 ";
    private static final String VOUCHER_DATA_UPGRADE_SUCCESS = "voucher data update success";
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        long count;
        this.result = new UpgradeResult();
        boolean updateSuccess = true;
        String log = VOUCHER_DATA_UPGRADE_SUCCESS;
        String info = VOUCHER_DATA_UPGRADE_SUCCESS;
        String countSql = "select count(*) as count from t_tdm_recordingvoucher";
        try (DataSet countSet = DB.queryDataSet((String)this.servicename, (DBRoute)route, (String)countSql);){
            count = countSet.next().getLong("count");
            logger.info("\u51ed\u8bc1\u8868\u6570\u636e\u603b\u6570\u4e3a\uff1a" + count);
        }
        catch (Exception exception) {
            info = log = this.getStackTraceMessage(exception);
            logger.info("\u67e5\u8be2\u51ed\u8bc1\u8868\u6570\u636e\u603b\u6570\u8d85\u65f6\u6216\u5176\u4ed6\u5f02\u5e38");
            this.result.setLog(log);
            this.result.setSuccess(true);
            this.result.setEl("");
            this.result.setErrorInfo(info);
            return this.result;
        }
        if (count < 10000000L) {
            try {
                logger.info("\u51ed\u8bc1\u8868\u6570\u636e\u91cf\u5c0f\u4e8e\u4e00\u5343\u4e07\uff0c\u81ea\u52a8\u66f4\u65b0");
                updateSuccess = this.mergeDataTemplate();
            }
            catch (Exception exception) {
                updateSuccess = false;
                info = log = this.getStackTraceMessage(exception);
            }
        }
        this.result.setLog(log);
        this.result.setSuccess(updateSuccess);
        this.result.setEl("");
        this.result.setErrorInfo(info);
        return this.result;
    }

    @Override
    public Map<Integer, Object[]> getExecSqlParams(String splitTablename, String idcol) {
        String countSql = "select count(1) as count,min(" + idcol + ") as minid,max(" + idcol + ") as maxid from " + splitTablename;
        long count = 0L;
        long minid = 0L;
        long maxid = 0L;
        try (DataSet countSet = DB.queryDataSet((String)this.servicename, (DBRoute)route, (String)countSql);){
            for (Row row : countSet) {
                count = row.getLong("count");
                if (count <= 0L) continue;
                minid = row.getLong("minid");
                maxid = row.getLong("maxid");
                break;
            }
        }
        if (count <= 0L) {
            return Collections.emptyMap();
        }
        if (count <= 1000000L) {
            return Collections.singletonMap(1, new Object[]{minid, maxid + 1L});
        }
        int batchs = new BigDecimal(count).divide(new BigDecimal(1000000), RoundingMode.CEILING).intValue();
        HashMap<Integer, Object[]> params = new HashMap<Integer, Object[]>(batchs);
        HashMap<Integer, Object[]> paramsReorder = new HashMap<Integer, Object[]>(batchs);
        long idFrom = minid;
        long idTo = 0L;
        String nextIdSql = "select top 1," + 1000000 + " " + idcol + " as id from " + splitTablename + " where " + idcol + " >= ?" + " order by " + idcol;
        for (int i = 1; i <= batchs; ++i) {
            Object[] param2 = new Object[2];
            if (i == batchs) {
                idTo = maxid + 1L;
            } else {
                try (DataSet nextIdtoSet = DB.queryDataSet((String)this.servicename, (DBRoute)route, (String)nextIdSql, (Object[])new Object[]{idFrom});){
                    if (nextIdtoSet.hasNext()) {
                        Row row = nextIdtoSet.next();
                        idTo = row.getLong("id");
                    }
                }
            }
            param2[0] = idFrom;
            param2[1] = idTo;
            params.put(i, param2);
            idFrom = idTo;
        }
        StringBuilder paramBuilder = new StringBuilder(this.servicename).append(':');
        params.values().forEach(param -> paramBuilder.append(Arrays.toString(param)));
        logger.info(paramBuilder.toString());
        int index = 1;
        for (int i = 1; i <= 3; ++i) {
            for (int j = i; j <= batchs; j += 3) {
                Object[] param3 = (Object[])params.get(j);
                paramsReorder.put(index, param3);
                ++index;
            }
        }
        return paramsReorder;
    }

    @Override
    public String getSplitTablename() {
        return "t_tdm_recordingvoucher";
    }

    @Override
    public String getSwitchName() {
        return "tdm_recording_voucher_new";
    }

    @Override
    public String getSingleUpdateSql() {
        return SINGLE_UPDATE_SQL;
    }

    @Override
    public String getSplitUpdateSql() {
        return SPLIT_UPDATE_SQL;
    }

    @Override
    public String getServicename() {
        return this.getClass().getName();
    }
}

